/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils.transfer;

import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.gcube.dataanalysis.geo.utils.transfer.HttpFileSystemConfBuilderPatched;

public class Utils {
    protected static FileSystemOptions createDefaultOptions(String URI2, int connectiontimeout) {
        FileSystemOptions opts = new FileSystemOptions();
        if (URI2.startsWith("ftp://")) {
            FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(opts, true);
            FtpFileSystemConfigBuilder.getInstance().setSoTimeout(opts, Integer.valueOf(connectiontimeout));
            FtpFileSystemConfigBuilder.getInstance().setDataTimeout(opts, Integer.valueOf(connectiontimeout));
            return opts;
        }
        if (URI2.startsWith("sftp://")) {
            SftpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(opts, true);
            SftpFileSystemConfigBuilder.getInstance().setTimeout(opts, Integer.valueOf(connectiontimeout));
            return opts;
        }
        if (!URI2.startsWith("s3://")) {
            if (URI2.startsWith("http://") || URI2.startsWith("https://")) {
                HttpFileSystemConfBuilderPatched.getInstance().setTimeout(opts, connectiontimeout);
                HttpFileSystemConfBuilderPatched.getInstance().setFollowRedirect(opts, true);
                return opts;
            }
            if (URI2.startsWith("smp://")) {
                return opts;
            }
        }
        return null;
    }
}

