/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.tests;

import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;

public class TestSGVMInterpolation {
    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./PARALLEL_PROCESSING");
        config.setParam("InputFile", "./tacsatmini.csv");
        config.setParam("npoints", "10");
        config.setParam("interval", "120");
        config.setParam("margin", "10");
        config.setParam("res", "100");
        config.setParam("method", "SL");
        config.setParam("fm", "0.5");
        config.setParam("distscale", "20");
        config.setParam("sigline", "0.2");
        config.setParam("minspeedThr", "2");
        config.setParam("maxspeedThr", "6");
        config.setParam("headingAdjustment", "0");
        config.setParam("equalDist", "true");
        config.setGcubeScope("/gcube/devsec/devVRE");
        config.setParam("ServiceUserName", "test.user");
        config.setAgent("SGVM_INTERPOLATION");
        List transducers = TransducerersFactory.getTransducerers((AlgorithmConfiguration)config);
        ComputationalAgent transducer = (ComputationalAgent)transducers.get(0);
        transducer.init();
        Regressor.process((ComputationalAgent)transducer);
        StatisticalType st = transducer.getOutput();
        System.out.println("st:" + ((PrimitiveType)st).getContent());
    }
}

