/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.wps.test.processes;

import java.util.HashMap;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;
import org.gcube.dataanalysis.geo.wps.interfaces.WPSProcess;

public class TestWPSProcess {
    static String[] algorithms = new String[]{"com.terradue.wps_hadoop.processes.examples.async.Async", "com.terradue.wps_hadoop.processes.ird.kernel_density.KernelDensity", "com.terradue.wps_hadoop.processes.terradue.envi_enrich.EnviEnrich", "com.terradue.wps_hadoop.processes.fao.intersection.Intersection", "com.terradue.wps_hadoop.processes.fao.spread.Spread"};
    static String wps = "http://wps01.i-marine.d4science.org:80/wps/WebProcessingService";
    static AlgorithmConfiguration[] configs = new AlgorithmConfiguration[]{TestWPSProcess.testAsynch(), TestWPSProcess.testKernelDensity(), TestWPSProcess.testEnvironmentalEnrichment(), TestWPSProcess.testIntersection(), TestWPSProcess.testSpread()};

    public static void main(String[] args) throws Exception {
        System.out.println("TEST 1");
        int i = 0;
        while (i < algorithms.length) {
            AnalysisLogger.getLogger().debug((Object)("Executing:" + algorithms[i]));
            WPSProcess trans = new WPSProcess(wps, algorithms[i]);
            trans.setConfiguration(configs[i]);
            trans.init();
            Regressor.process((ComputationalAgent)trans);
            StatisticalType st = trans.getOutput();
            AnalysisLogger.getLogger().debug((Object)("ST:" + st));
            PrimitiveType p = (PrimitiveType)st;
            HashMap map = (HashMap)p.getContent();
            for (Object v : map.values()) {
                System.out.println("Out: " + ((PrimitiveType)v).getContent());
            }
            Object var2_2 = null;
            ++i;
        }
    }

    private static AlgorithmConfiguration testAsynch() {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setParam("secondsDelay", "1");
        return config;
    }

    private static AlgorithmConfiguration testKernelDensity() {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setParam("species", "Carcharodon carcharias");
        return config;
    }

    private static AlgorithmConfiguration testEnvironmentalEnrichment() {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setParam("species", "Carcharodon carcharias");
        config.setParam("envVars", "salinity" + AlgorithmConfiguration.listSeparator + "sst");
        return config;
    }

    private static AlgorithmConfiguration testIntersection() {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setParam("masterWfsUrl", "http://www.fao.org/figis/geoserver/species/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=species:SPECIES_DIST_OCC");
        config.setParam("slaveWfsUrls", "http://mdst-macroes.ird.fr:8080/constellation/WS/wfs/longhurst?service=WFS&version=1.1.0&request=GetFeature&typeName=Longhurst_world_v4_2010:Longhurst_world_v4_2010");
        config.setParam("outputFormat", "GML");
        return config;
    }

    private static AlgorithmConfiguration testSpread() {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setParam("geoColumn", "field0");
        config.setParam("quantityColumn", "field4");
        config.setParam("sourceAreaLayerName", "FAO_AREAS");
        config.setParam("targetAreaLayerName", "EEZ_HIGHSEAS");
        config.setParam("dataUrls", "https://dl.dropboxusercontent.com/u/24368142/timeseries_100.json");
        return config;
    }

    private static AlgorithmConfiguration testTuna1() {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setParam("species", "Thunnus albacares");
        config.setParam("wfsUrl", "http://www.fao.org/figis/geoserver/species/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=species:SPECIES_DIST_OCC");
        return config;
    }

    private static AlgorithmConfiguration testTuna2() {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setParam("species", "Thunnus albacares");
        config.setParam("wfsUrl", "http://www.fao.org/figis/geoserver/species/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=species:SPECIES_DIST_OCC");
        return config;
    }
}

