/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;

public class MathFunctions {
    public static void main(String[] args) {
        System.out.println(" " + MathFunctions.roundDecimal(300.23454, 2));
    }

    public static double roundDecimal(double number, int decimalposition) {
        double n = (double)Math.round(number * Math.pow(10.0, decimalposition)) / Math.pow(10.0, decimalposition);
        return n;
    }

    public static float incrementPerc(float perc, float quantity, int N) {
        if (N == 0) {
            return quantity;
        }
        float out = 0.0f;
        int N_plus_1 = N + 1;
        out = (float)(((double)perc + (double)quantity / (double)N) * ((double)N / (double)N_plus_1));
        return out;
    }

    public static ArrayList<Integer> generateRandoms(int numberOfRandoms, int min, int max) {
        ArrayList<Integer> randomsSet = new ArrayList<Integer>();
        if (numberOfRandoms == -1) {
            for (int i = min; i < max; ++i) {
                randomsSet.add(i);
            }
        } else {
            int numofrandstogenerate = 0;
            numofrandstogenerate = numberOfRandoms <= max ? numberOfRandoms : max;
            if (numofrandstogenerate == 0) {
                randomsSet.add(0);
            } else {
                for (int i = 0; i < numofrandstogenerate; ++i) {
                    int RNum = -1;
                    RNum = (int)((double)max * Math.random()) + min;
                    while (randomsSet.contains(RNum)) {
                        RNum = (int)((double)max * Math.random()) + min;
                    }
                    if (RNum < 0) continue;
                    randomsSet.add(RNum);
                }
            }
        }
        return randomsSet;
    }

    public static int[] generateSequence(int elements) {
        int[] sequence = new int[elements];
        for (int i = 0; i < elements; ++i) {
            sequence[i] = i;
        }
        return sequence;
    }

    public static BigInteger chunk2Index(int chunkIndex, int chunkSize) {
        return BigInteger.valueOf(chunkIndex).multiply(BigInteger.valueOf(chunkSize));
    }

    public static double mean(double[] p) {
        double sum = 0.0;
        for (int i = 0; i < p.length; ++i) {
            sum += p[i];
        }
        return sum / (double)p.length;
    }

    public static double[] derivative(double[] a) {
        double[] d = new double[a.length];
        double max = 1.0;
        if (a.length > 0) {
            int i;
            for (i = 0; i < a.length; ++i) {
                double current;
                double previous = current = a[i];
                if (i > 0) {
                    previous = a[i - 1];
                }
                d[i] = current - previous;
                if (!(Math.abs(d[i]) > max)) continue;
                max = Math.abs(d[i]);
            }
            for (i = 0; i < a.length; ++i) {
                d[i] = d[i] / max;
            }
        }
        return d;
    }

    public static boolean[] findSpikes(double[] derivative, double threshold) {
        boolean[] d = new boolean[derivative.length];
        if (d.length > 0) {
            d[0] = false;
            for (int i = 1; i < derivative.length - 1; ++i) {
                if (derivative[i] / derivative[i + 1] < 0.0) {
                    if (!(threshold > 0.0) || !(Math.abs(derivative[i]) > threshold)) continue;
                    d[i] = true;
                    continue;
                }
                d[i] = false;
            }
            d[derivative.length - 1] = false;
        }
        return d;
    }

    public static boolean[] findSpikes(double[] derivative) {
        return MathFunctions.findSpikes(derivative, -1.0);
    }

    public static double[] points2Double(List<Point<? extends Number, ? extends Number>> pointslist, int seriesIndex, int numbOfPoints) {
        double[] points = new double[numbOfPoints];
        for (int y = 0; y < numbOfPoints; ++y) {
            double value;
            points[y] = value = pointslist.get(seriesIndex).getEntries().get(y).getValue().doubleValue();
        }
        return points;
    }

    public static boolean isIn(List<Integer> indexarray, int index) {
        int size = indexarray.size();
        for (int i = 0; i < size; ++i) {
            if (index != indexarray.get(i)) continue;
            return true;
        }
        return false;
    }

    public static List<Integer> findZeros(double[] points) {
        int size = points.length;
        ArrayList<Integer> zeros = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            if (points[i] != 0.0) continue;
            int start = i;
            int end = i;
            for (int j = i + 1; j < size; ++j) {
                if (points[j] == 0.0) continue;
                end = j - 1;
                break;
            }
            int center = start + (end - start) / 2;
            zeros.add(center);
            i = end;
        }
        return zeros;
    }

    public static double[] logSubdivision(double start, double end, int numberOfParts) {
        if (end <= start) {
            return null;
        }
        if (start == 0.0) {
            start = 0.01;
        }
        double logStart = Math.log(start);
        double logEnd = Math.log(end);
        double step = 0.0;
        if (numberOfParts > 0) {
            double difference = logEnd - logStart;
            step = difference / (double)numberOfParts;
        }
        double[] linearpoints = new double[numberOfParts + 1];
        for (int i = 0; i < numberOfParts + 1; ++i) {
            linearpoints[i] = Math.exp(logStart + (double)i * step);
            if (!(linearpoints[i] < 0.011)) continue;
            linearpoints[i] = 0.0;
        }
        return linearpoints;
    }
}

