/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.test.checks;

import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;

public class TestTransducer {
    public static void main(String[] args) throws Exception {
        System.out.println("TEST 1");
        List<Transducerer> trans = TransducerersFactory.getTransducerers(TestTransducer.testConfigLocal());
        trans.get(0).init();
        TestTransducer.transduce(trans.get(0));
        trans = null;
    }

    private static void transduce(Transducerer trans) throws Exception {
        if (trans != null) {
            TestTransducer tgs;
            TestTransducer testTransducer = tgs = new TestTransducer();
            testTransducer.getClass();
            ThreadCalculator tc = testTransducer.new ThreadCalculator(trans);
            Thread t = new Thread(tc);
            t.start();
            while (trans.getStatus() < 100.0f) {
                System.out.println("STATUS: " + trans.getStatus());
                Thread.sleep(1000L);
            }
        } else {
            AnalysisLogger.getLogger().trace((Object)"Generator Algorithm Not Supported");
        }
    }

    private static AlgorithmConfiguration testConfigLocal() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setNumberOfResources(1);
        config.setAgent("BIOCLIMATE_HSPEC");
        config.setParam("HSPEC_TABLE_LIST", "hspec_validation" + AlgorithmConfiguration.getListSeparator() + "hspec_validation2");
        config.setParam("HSPEC_TABLE_NAMES", "test" + AlgorithmConfiguration.getListSeparator() + "test");
        config.setParam("Threshold", "0.5");
        config.setParam("DatabaseUserName", "gcube");
        config.setParam("DatabasePassword", "d4science2");
        config.setParam("DatabaseURL", "jdbc:postgresql://localhost/testdb");
        config.setParam("DatabaseDriver", "org.postgresql.Driver");
        return config;
    }

    public class ThreadCalculator
    implements Runnable {
        Transducerer dg;

        public ThreadCalculator(Transducerer dg) {
            this.dg = dg;
        }

        @Override
        public void run() {
            try {
                this.dg.compute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

