/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.utils;

import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;

public class Operations {
    public double[] means;
    public double[] variances;

    public static double scalarProduct(double[] a, double[] b) {
        double sum = 0.0;
        int i = 0;
        while (i < a.length) {
            if (i < b.length) {
                sum += a[i] * b[i];
            }
            ++i;
        }
        return sum;
    }

    public static double sumVector(double[] a) {
        double sum = 0.0;
        int i = 0;
        while (i < a.length) {
            sum += a[i];
            ++i;
        }
        return sum;
    }

    public static double[] vectorialDifference(double[] a, double[] b) {
        double[] diff = new double[a.length];
        int i = 0;
        while (i < a.length) {
            diff[i] = i < b.length ? a[i] - b[i] : a[i];
            ++i;
        }
        return diff;
    }

    public static double[] vectorialAbsoluteDifference(double[] a, double[] b) {
        double[] diff = new double[a.length];
        int i = 0;
        while (i < a.length) {
            diff[i] = i < b.length ? Math.abs(a[i] - b[i]) : Math.abs(a[i]);
            ++i;
        }
        return diff;
    }

    public static double getMax(double[] points) {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < points.length) {
            if (max < points[i]) {
                max = points[i];
            }
            ++i;
        }
        return max;
    }

    public static int getMax(int[] points) {
        int max = -2147483647;
        int i = 0;
        while (i < points.length) {
            if (max < points[i]) {
                max = points[i];
            }
            ++i;
        }
        return max;
    }

    public static int getMin(int[] points) {
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < points.length) {
            if (min > points[i]) {
                min = points[i];
            }
            ++i;
        }
        return min;
    }

    public static double getMin(double[] points) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < points.length) {
            if (min > points[i]) {
                min = points[i];
            }
            ++i;
        }
        return min;
    }

    public static double[] calcFrequencies(double[] interval, double[] points) {
        int intervs = interval.length;
        int npoints = points.length;
        double[] frequencies = new double[intervs];
        int i = 0;
        while (i < intervs) {
            int j = 0;
            while (j < npoints) {
                if (i == 0 && points[j] < interval[i] || i == intervs - 1 && points[j] >= interval[i - 1] && points[j] <= interval[i] || i > 0 && points[j] >= interval[i - 1] && points[j] < interval[i]) {
                    frequencies[i] = frequencies[i] + 1.0;
                }
                ++j;
            }
            ++i;
        }
        return frequencies;
    }

    public static double[] normalizeFrequencies(double[] frequencies, int numberOfPoints) {
        int intervs = frequencies.length;
        int i = 0;
        while (i < intervs) {
            frequencies[i] = frequencies[i] / (double)numberOfPoints;
            ++i;
        }
        return frequencies;
    }

    public static boolean intervalContainsPoints(double min, double max, double[] points) {
        boolean contains = false;
        int i = 0;
        while (i < points.length) {
            if (points[i] >= min && points[i] < max) {
                contains = true;
                break;
            }
            ++i;
        }
        return contains;
    }

    public static double[] uniformDivide(double max, double min, double[] points) {
        int i;
        int maxintervals;
        int n = maxintervals = 10;
        boolean subdivisionOK = false;
        double gap = (max - min) / (double)n;
        while (!subdivisionOK) {
            boolean notcontains = false;
            i = 0;
            while (i < n) {
                double rightmost = 0.0;
                rightmost = i == n - 1 ? max + 0.01 : min + gap * (double)(i + 1);
                if (!Operations.intervalContainsPoints(min + gap * (double)i, rightmost, points)) {
                    notcontains = true;
                    break;
                }
                ++i;
            }
            if (notcontains && n > 0) {
                gap = (max - min) / (double)(--n);
                continue;
            }
            if (n == 0) {
                n = maxintervals;
                subdivisionOK = true;
                continue;
            }
            subdivisionOK = true;
        }
        double[] intervals = new double[n];
        i = 0;
        while (i < n) {
            intervals[i] = i < n - 1 ? min + gap * (double)(i + 1) : Double.POSITIVE_INFINITY;
            ++i;
        }
        return intervals;
    }

    public double[][] standardize(double[][] matrix) {
        return this.standardize(matrix, null, null);
    }

    public double[][] standardize(double[][] matrix, double[] meansVec, double[] variancesVec) {
        if (matrix.length > 0) {
            int ncols = matrix[0].length;
            int mrows = matrix.length;
            if (this.means == null && this.variances == null) {
                this.means = new double[ncols];
                this.variances = new double[ncols];
            }
            double[][] matrixT = Transformations.traspose(matrix);
            int i = 0;
            while (i < ncols) {
                double[] icolumn = matrixT[i];
                double mean = 0.0;
                if (meansVec == null) {
                    this.means[i] = mean = MathFunctions.mean(icolumn);
                } else {
                    mean = meansVec[i];
                }
                double variance = 0.0;
                if (variancesVec == null) {
                    this.variances[i] = variance = com.rapidminer.tools.math.MathFunctions.variance((double[])icolumn, (double)Double.NEGATIVE_INFINITY);
                } else {
                    variance = variancesVec[i];
                }
                int j = 0;
                while (j < mrows) {
                    double numerator = icolumn[j] - mean;
                    icolumn[j] = numerator == 0.0 && variance == 0.0 ? 0.0 : (variance == 0.0 ? Double.MAX_VALUE : numerator / variance);
                    ++j;
                }
                ++i;
            }
            matrix = Transformations.traspose(matrixT);
        }
        return matrix;
    }

    public static int calcNumOfRepresentativeElements(int numberOfElements, int minimumNumberToTake) {
        return (int)Math.max((double)minimumNumberToTake, (double)numberOfElements / Math.log10(numberOfElements));
    }

    public static double[] linearInterpolation(double el1, double el2, int intervals) {
        double step = (el2 - el1) / (double)intervals;
        double[] intervalsd = new double[intervals];
        intervalsd[0] = el1;
        int i = 1;
        while (i < intervals - 1) {
            intervalsd[i] = el1 + step * (double)i;
            ++i;
        }
        intervalsd[intervals - 1] = el2;
        return intervalsd;
    }

    private static double parabol(double a, double b, double c, double x, double shift) {
        return a * (x - shift) * (x - shift) + b * (x - shift) + c;
    }

    public static double[] inverseParabol(double a, double b, double c, double y) {
        double[] ret = new double[]{(-1.0 * b + Math.sqrt(b * b + 4.0 * a * (Math.abs(y) - c))) / (2.0 * a), (-1.0 * b - Math.sqrt(b * b + 4.0 * a * (Math.abs(y) - c))) / (2.0 * a)};
        return ret;
    }

    public static double logaritmicTransformation(double y) {
        if ((y = Math.abs(y)) == 0.0) {
            return -1.7976931348623157E308;
        }
        return Math.log10(y);
    }

    public static double[] parabolicInterpolation(double startP, double endP, int intervals) {
        double start = startP;
        double end = endP;
        double shift = start;
        double a = 1000.0;
        double b = 0.0;
        double c = 0.0;
        double parabolStart = Operations.parabol(a, b, c, start, shift);
        if (start < 0.0) {
            parabolStart *= -1.0;
        }
        double parabolEnd = Operations.parabol(a, b, c, end, start);
        if (end < 0.0) {
            parabolEnd *= -1.0;
        }
        double step = 0.0;
        if (intervals > 0) {
            double difference = Math.abs(parabolEnd - parabolStart);
            step = difference / (double)intervals;
        }
        double[] linearpoints = new double[intervals];
        linearpoints[0] = startP;
        int i = 1;
        while (i < intervals - 1) {
            double ypoint = 0.0;
            ypoint = end > start ? parabolStart + (double)i * step : parabolStart - (double)i * step;
            double[] res = Operations.inverseParabol(a, b, c, Math.abs(ypoint));
            linearpoints[i] = ypoint < 0.0 ? res[1] + shift : res[0] + shift;
            ++i;
        }
        linearpoints[intervals - 1] = endP;
        return linearpoints;
    }

    public static void main1(String[] args) {
        double[] points = new double[20];
        int i = 0;
        while (i < 20) {
            points[i] = 10.0 * Math.random();
            ++i;
        }
        double max = Operations.getMax(points);
        double min = Operations.getMin(points);
        System.out.println("<" + min + "," + max + ">");
        double[] interval = Operations.uniformDivide(max, min, points);
        double[] frequencies = Operations.calcFrequencies(interval, points);
        int i2 = 0;
        while (i2 < interval.length) {
            System.out.print(String.valueOf(interval[i2]) + " ");
            System.out.println("->" + frequencies[i2] + " ");
            ++i2;
        }
    }

    public static void main(String[] args) {
        int[] ii = Operations.takeChunks(11549, 115);
        System.out.println("OK");
    }

    public static int[] takeChunks(int numberOfElements, int partitionFactor) {
        int[] partitions = new int[1];
        if (partitionFactor <= 0) {
            return partitions;
        }
        if (partitionFactor == 1) {
            partitions[0] = numberOfElements;
            return partitions;
        }
        int chunksize = numberOfElements / partitionFactor;
        int rest = numberOfElements % partitionFactor;
        if (chunksize == 0) {
            partitions = new int[numberOfElements];
            int i = 0;
            while (i < numberOfElements) {
                partitions[i] = 1;
                ++i;
            }
        } else {
            partitions = new int[partitionFactor];
            int i = 0;
            while (i < partitionFactor) {
                partitions[i] = chunksize;
                ++i;
            }
            i = 0;
            while (i < rest) {
                int n = i++;
                partitions[n] = partitions[n] + 1;
            }
        }
        return partitions;
    }

    public static int chunkize(int numberOfElements, int partitionFactor) {
        int chunksize = numberOfElements / partitionFactor;
        int rest = numberOfElements % partitionFactor;
        if (chunksize == 0) {
            chunksize = 1;
        } else if (rest != 0) {
            ++chunksize;
        }
        return chunksize;
    }
}

