/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.test.tablescomparisons;

import java.math.BigInteger;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.hibernate.SessionFactory;

public class TablesComparison {
    private BigInteger numOfElements;
    private int errorCounter;
    protected String LogFile = "ALog.properties";
    int chunkSize = 7000;
    static double Threshold = 0.01;
    public String referenceTable = "hspec_suitable2050_test_parallel_validation";
    public String analyzedTable = "hspec_suitable2050_test_parallel_validation2";
    public String referenceCriteria = "speciesid,csquarecode";
    public String destinationCriteria = "speciesid,csquarecode";
    public String referenceSelectedColumns = "speciesid,csquarecode,probability,boundboxyn,faoareayn";
    public String destinationSelectedColumns = "speciesid,csquarecode,probability,boundboxyn,faoareayn";
    public static String selectElementsQuery = "select %1$s from %2$s order by %3$s";
    protected SessionFactory referencedbConnection;
    protected SessionFactory destinationdbConnection;

    public TablesComparison(AlgorithmConfiguration config) throws Exception {
        AnalysisLogger.setLogger(config.getConfigPath() + this.LogFile);
        this.referencedbConnection = DatabaseFactory.initDBConnection(config.getConfigPath() + AlgorithmConfiguration.defaultConnectionFile, config);
        AnalysisLogger.getLogger().debug((Object)"ReferenceDB initialized");
        this.destinationdbConnection = DatabaseFactory.initDBConnection(config.getConfigPath() + AlgorithmConfiguration.defaultConnectionFile, config);
        AnalysisLogger.getLogger().debug((Object)"OriginalDB initialized");
    }

    public BigInteger countElements(String tablename, SessionFactory session) {
        BigInteger count = BigInteger.ZERO;
        String countingQuery = "select count(*) from " + tablename;
        AnalysisLogger.getLogger().debug((Object)("Getting DB elements by this query: " + countingQuery));
        List<Object> result = DatabaseFactory.executeSQLQuery(countingQuery, session);
        count = (BigInteger)result.get(0);
        return count;
    }

    public List<Object> takeChunkOfElements(String tablename, String selectedColumns, String criteria, int limit, int offset, SessionFactory session) {
        String query = String.format(selectElementsQuery, selectedColumns, tablename, criteria) + " limit " + limit + " offset " + offset;
        AnalysisLogger.getLogger().debug((Object)("takeChunkOfElements-> executing query on DB: " + query));
        List<Object> results = DatabaseFactory.executeSQLQuery(query, session);
        return results;
    }

    public double isNumber(String element) {
        try {
            double d = Double.parseDouble(element);
            return d;
        }
        catch (Exception e) {
            return -1.7976931348623157E308;
        }
    }

    public static void main(String[] args) throws Exception {
        String configPath = "./cfg/";
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath(configPath);
        TablesComparison ec = new TablesComparison(config);
        long t0 = System.currentTimeMillis();
        ec.runTest();
        long t1 = System.currentTimeMillis();
        float difference = t1 - t0;
        System.out.println("Elapsed time : " + (difference /= 60000.0f) + " min");
    }

    public boolean runTest() {
        long t0 = System.currentTimeMillis();
        this.numOfElements = this.countElements(this.analyzedTable, this.destinationdbConnection);
        AnalysisLogger.getLogger().debug((Object)("Remote DB contains " + this.numOfElements + " elements."));
        int maxNumber = this.numOfElements.intValue();
        int numOfChunks = maxNumber / this.chunkSize;
        if (maxNumber % this.chunkSize > 0) {
            ++numOfChunks;
        }
        int startIndex = 0;
        this.errorCounter = 0;
        boolean equal = true;
        for (int i = startIndex; i < numOfChunks; ++i) {
            int offset = i * this.chunkSize;
            List<Object> referencechunk = this.takeChunkOfElements(this.referenceTable, this.referenceSelectedColumns, this.referenceCriteria, this.chunkSize, offset, this.referencedbConnection);
            List<Object> destinationchunk = this.takeChunkOfElements(this.analyzedTable, this.destinationSelectedColumns, this.destinationCriteria, this.chunkSize, offset, this.destinationdbConnection);
            int m = referencechunk.size();
            for (int j = 0; j < m; ++j) {
                Object[] refrow = (Object[])referencechunk.get(j);
                Object[] destrow = (Object[])destinationchunk.get(j);
                int columns = destrow.length;
                for (int k = 0; k < columns; ++k) {
                    String refelem = "" + refrow[k];
                    String destelem = "" + destrow[k];
                    double d = this.isNumber(refelem);
                    if (d != -1.7976931348623157E308) {
                        if (Math.abs(d - this.isNumber(destelem)) > Threshold) {
                            ++this.errorCounter;
                            equal = false;
                            AnalysisLogger.getLogger().debug((Object)("ERROR - DISCREPANCY AT NUMBERS COMPARISON: " + refelem + " vs " + destelem));
                        }
                    } else if (!refelem.equals(destelem)) {
                        ++this.errorCounter;
                        equal = false;
                        AnalysisLogger.getLogger().debug((Object)("ERROR - DISCREPANCY AT STRING COMPARISON: " + refelem + " vs " + destelem));
                    }
                    if (!equal) break;
                }
                if (!equal) break;
            }
            if (!equal) break;
            AnalysisLogger.getLogger().debug((Object)("CHUNK NUMBER " + i + " OK!"));
        }
        long t1 = System.currentTimeMillis();
        AnalysisLogger.getLogger().debug((Object)("ELAPSED TIME: " + (t1 - t0) + " ms"));
        this.referencedbConnection.close();
        this.destinationdbConnection.close();
        return equal;
    }
}

