/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.test.checks;

import java.util.HashMap;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.evaluation.DiscrepancyAnalysis;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;

public class TestEvaluation {
    public static void main(String[] args) throws Exception {
        List<ComputationalAgent> evaluators = EvaluatorsFactory.getEvaluators(TestEvaluation.testQuality());
        TestEvaluation.evaluate(evaluators.get(0), TestEvaluation.testQuality());
        evaluators = null;
        System.out.println("\n**********-------************\n");
        evaluators = EvaluatorsFactory.getEvaluators(TestEvaluation.testDiscrepancy());
        TestEvaluation.evaluate(evaluators.get(0), TestEvaluation.testDiscrepancy());
        evaluators = null;
    }

    private static void evaluate(ComputationalAgent evaluator, AlgorithmConfiguration config) throws Exception {
        if (evaluator != null) {
            String ress;
            String resLoad;
            TestEvaluation tgs;
            TestEvaluation testEvaluation = tgs = new TestEvaluation();
            testEvaluation.getClass();
            ThreadCalculator tc = testEvaluation.new ThreadCalculator(evaluator, config);
            Thread t = new Thread(tc);
            t.start();
            while (evaluator.getStatus() < 100.0f) {
                resLoad = evaluator.getResourceLoad();
                ress = evaluator.getResources();
                System.out.println("LOAD: " + resLoad);
                System.out.println("RESOURCES: " + ress);
                System.out.println("STATUS: " + evaluator.getStatus());
                Thread.sleep(1000L);
            }
            resLoad = evaluator.getResourceLoad();
            ress = evaluator.getResources();
            System.out.println("\nLOAD: " + resLoad);
            System.out.println("RESOURCES: " + ress);
            System.out.println("STATUS: " + evaluator.getStatus());
        } else {
            AnalysisLogger.getLogger().trace((Object)"Generator Algorithm Not Supported");
        }
    }

    private static AlgorithmConfiguration testQuality() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./cfg/");
        config.setNumberOfResources(1);
        config.setAgent("QUALITY_ANALYSIS");
        config.setParam("PositiveCasesTable", "presence_data_baskingshark");
        config.setParam("NegativeCasesTable", "absence_data_baskingshark2");
        config.setParam("PositiveCasesTableKeyColumn", "csquarecode");
        config.setParam("NegativeCasesTableKeyColumn", "csquarecode");
        config.setParam("DistributionTable", "hspec_native_baskingshark_aquamaps");
        config.setParam("DistributionTableKeyColumn", "csquarecode");
        config.setParam("DistributionTableProbabilityColumn", "probability");
        config.setParam("PositiveThreshold", "0.5");
        config.setParam("NegativeThreshold", "0.5");
        return config;
    }

    private static AlgorithmConfiguration testDiscrepancy() {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./cfg/");
        config.setNumberOfResources(1);
        config.setAgent("DISCREPANCY_ANALYSIS");
        config.setParam("FirstTable", "hspec_native_baskingshark_aquamaps");
        config.setParam("SecondTable", "hspec_suitable_nn_Fis22747");
        config.setParam("FirstTableCsquareColumn", "csquarecode");
        config.setParam("SecondTableCsquareColumn", "csquarecode");
        config.setParam("FirstTableProbabilityColumn", "probability");
        config.setParam("SecondTableProbabilityColumn", "probability");
        config.setParam("ComparisonThreshold", "0.1");
        return config;
    }

    public class ThreadCalculator
    implements Runnable {
        ComputationalAgent dg;
        AlgorithmConfiguration config;

        public ThreadCalculator(ComputationalAgent dg, AlgorithmConfiguration config) {
            this.dg = dg;
            this.config = config;
        }

        @Override
        public void run() {
            try {
                this.dg.compute();
                PrimitiveType output = (PrimitiveType)this.dg.getOutput();
                HashMap out = (HashMap)output.getContent();
                DiscrepancyAnalysis.visualizeResults(out);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

