/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.timeseries.charts.support.types;

import java.io.Serializable;
import org.gcube.portlets.user.timeseries.charts.support.assertions.Assertion;
import org.gcube.portlets.user.timeseries.charts.support.exceptions.InvalidParameterException;

public class ValueEntry<T extends Number>
implements Serializable {
    private static final long serialVersionUID = -6765421417425929840L;
    private String label = null;
    private T value = null;

    private ValueEntry() {
    }

    public ValueEntry(T value) throws InvalidParameterException {
        this.setValue(value);
    }

    public ValueEntry(String label, T value) throws InvalidParameterException {
        this(value);
        this.setLabel(label);
    }

    public final void setLabel(String label) {
        if (label != null) {
            this.label = label.trim();
        }
    }

    public final void setValue(T value) throws InvalidParameterException {
        Assertion<InvalidParameterException> checker = new Assertion<InvalidParameterException>();
        checker.validate(value != null, new InvalidParameterException("Invalid parameter value. Null not allowed."));
        this.value = value;
    }

    public final String getLabel() {
        return this.label;
    }

    public final T getValue() {
        return this.value;
    }

    public final String toString() {
        return (this.label != null ? this.label : "N/D") + " -> " + this.getValue();
    }
}

