/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.analysis.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.CategoryOrderedList;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.CategoryScores;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.SingleResult;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.chunks.ChunkSet;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.chunks.ReferenceChunk;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.chunks.ReferenceChunkSet;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.chunks.SetOfReferenceChunkSet;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.chunks.SingletonChunkSet;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.chunks.TimeSeriesChunk;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.chunks.TimeSeriesChunkSet;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.contentmanagement.lexicalmatcher.utils.MathFunctions;
import org.hibernate.SessionFactory;

public class Engine {
    private String ConfigurationFileNameLocal = "lexicalguesser/hibernate.cfg.xml";
    private SessionFactory referenceDBSession;
    public ArrayList<String> bestCategories;
    public ArrayList<Double> bestScores;
    public ArrayList<String> bestColumns;
    public HashMap<String, CategoryScores> scoresTable;
    public String columnFilter;
    private LexicalEngineConfiguration config;
    private TimeSeriesChunk singletonChunk;
    boolean[] threadActivity;

    public ArrayList<SingleResult> getSingletonMatches() {
        return this.singletonChunk.getDetailedResults();
    }

    public String getSingletonElement() {
        return this.singletonChunk.getSingletonEntry();
    }

    public SessionFactory getDBSession() throws Exception {
        if (this.referenceDBSession == null) {
            this.referenceDBSession = DatabaseFactory.initDBConnection(this.ConfigurationFileNameLocal);
        }
        return this.referenceDBSession;
    }

    public SessionFactory getDBSession(LexicalEngineConfiguration externalConf) throws Exception {
        if (this.referenceDBSession == null) {
            this.referenceDBSession = DatabaseFactory.initDBConnection(this.ConfigurationFileNameLocal, externalConf);
        }
        return this.referenceDBSession;
    }

    public void resetEngine(LexicalEngineConfiguration Config2, String ColumnFilter) {
        this.config = Config2;
        this.scoresTable = new HashMap();
        this.bestCategories = new ArrayList();
        this.bestColumns = new ArrayList();
        this.bestScores = new ArrayList();
        this.columnFilter = ColumnFilter;
    }

    public Engine(LexicalEngineConfiguration Config2, String ColumnFilter) {
        this.config = Config2;
        this.scoresTable = new HashMap();
        this.bestCategories = new ArrayList();
        this.bestColumns = new ArrayList();
        this.bestScores = new ArrayList();
        this.columnFilter = ColumnFilter;
    }

    public void calcLike(CategoryOrderedList col, String unknownSeriesName, String unknownSeriesColumn) {
        this.scoresTable = col.getScoresTable();
        TimeSeriesChunkSet tsChunkSet = null;
        try {
            tsChunkSet = new TimeSeriesChunkSet(this.config.TimeSeriesChunksToTake, this.config.chunkSize, unknownSeriesName, unknownSeriesColumn, this.config, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().error((Object)("Engine->calcLike->  ERROR could not retrieve time series chunks " + e.getLocalizedMessage()));
        }
        if (tsChunkSet != null) {
            SetOfReferenceChunkSet setRefChunksSet = new SetOfReferenceChunkSet(col.getOrderedList(), this.config, this);
            TimeSeriesChunk tsChunk = tsChunkSet.nextChunk();
            while (tsChunk != null) {
                ReferenceChunkSet refChunkSet = setRefChunksSet.getNextChunkSet();
                while (refChunkSet != null) {
                    ReferenceChunk refChunk = refChunkSet.nextChunk();
                    while (refChunk != null) {
                        try {
                            tsChunk.compareToReferenceChunk(this.scoresTable, refChunk);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            AnalysisLogger.getLogger().error((Object)("Engine->calcLike->  ERROR could not compare time series chunk with reference chunk " + e.getLocalizedMessage()));
                        }
                        refChunk = refChunkSet.nextChunk();
                    }
                    this.UpdateScores(refChunkSet.getSeriesName(), false);
                    refChunkSet = setRefChunksSet.getNextChunkSet();
                }
                tsChunk = tsChunkSet.nextChunk();
            }
        }
    }

    private void wait4Thread(int index) {
        while (this.threadActivity[index]) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void startNewTCalc(TimeSeriesChunk tsChunk, ReferenceChunkSet refChunkSet, int index) {
        this.threadActivity[index] = true;
        ThreadCalculator tc = new ThreadCalculator(tsChunk, refChunkSet, index);
        Thread t = new Thread(tc);
        t.start();
    }

    public void calcLikeThread(CategoryOrderedList col, String unknownSeriesName, String unknownSeriesColumn, String singletonString) {
        this.scoresTable = col.getScoresTable();
        ChunkSet tsChunkSet = null;
        int[] currentThreads = MathFunctions.generateSequence(this.config.numberOfThreadsToUse);
        int currentThread = 0;
        this.threadActivity = new boolean[currentThreads.length];
        for (int j = 0; j < this.threadActivity.length; ++j) {
            this.threadActivity[j] = false;
        }
        try {
            tsChunkSet = singletonString == null ? new TimeSeriesChunkSet(this.config.TimeSeriesChunksToTake, this.config.chunkSize, unknownSeriesName, unknownSeriesColumn, this.config, this) : new SingletonChunkSet(singletonString, this.config, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().error((Object)("Engine->calcLike->  ERROR could not retrieve time series chunks " + e.getLocalizedMessage()));
        }
        if (tsChunkSet != null) {
            SetOfReferenceChunkSet setRefChunksSet = new SetOfReferenceChunkSet(col.getOrderedList(), this.config, this);
            TimeSeriesChunk tsChunk = (TimeSeriesChunk)tsChunkSet.nextChunk();
            AnalysisLogger.getLogger().debug((Object)("tsChunk is null " + (tsChunk != null)));
            while (tsChunk != null) {
                ReferenceChunkSet refChunkSet = setRefChunksSet.getNextChunkSet();
                while (refChunkSet != null) {
                    this.wait4Thread(currentThreads[currentThread]);
                    this.startNewTCalc(tsChunk, refChunkSet, currentThreads[currentThread]);
                    refChunkSet = setRefChunksSet.getNextChunkSet();
                    if (++currentThread < currentThreads.length) continue;
                    currentThread = 0;
                }
                if (tsChunk.isSingleton()) {
                    this.singletonChunk = tsChunk;
                    break;
                }
                tsChunk = (TimeSeriesChunk)tsChunkSet.nextChunk();
            }
            for (int i : currentThreads) {
                this.wait4Thread(i);
            }
        }
    }

    private void makeComparisonsTSChunk2RefChunks(TimeSeriesChunk tsChunk, ReferenceChunkSet refChunkSet) {
        ReferenceChunk refChunk = refChunkSet.nextChunk();
        while (refChunk != null) {
            try {
                tsChunk.compareToReferenceChunk(this.scoresTable, refChunk, this.columnFilter);
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().error((Object)("Engine->calcLike->  ERROR could not compare time series chunk with reference chunk " + e.getLocalizedMessage()));
            }
            if (tsChunk.mustInterruptProcess()) break;
            refChunk = refChunkSet.nextChunk();
        }
        this.UpdateScores(refChunkSet.getSeriesName(), tsChunk.isSingleton());
    }

    private void UpdateScores(String categoryName, boolean singletonMatch) {
        CategoryScores categoryScore = this.scoresTable.get(categoryName);
        ArrayList<String> bestCols = categoryScore.findBestList();
        String bestColumn = null;
        double score = 0.0;
        if (bestCols.size() > 0) {
            bestColumn = bestCols.get(0);
            score = categoryScore.getScore(bestColumn, singletonMatch);
        }
        AnalysisLogger.getLogger().trace((Object)("Engine->UpdateScores->  \tBEST SUITABLE COLUMN IS: " + bestColumn));
        AnalysisLogger.getLogger().trace((Object)("Engine->UpdateScores->  \tBEST SCORE IS: " + score));
        if (score > (double)this.config.categoryDiscardThreshold) {
            int index = 0;
            for (Double dscore : this.bestScores) {
                if (dscore < score) break;
                ++index;
            }
            this.bestCategories.add(index, categoryName);
            this.bestScores.add(index, score);
            this.bestColumns.add(index, bestColumn);
            this.checkAndAddColumns(categoryScore, bestCols, categoryName, singletonMatch);
        }
    }

    private void checkAndAddColumns(CategoryScores scores, ArrayList<String> bestCols, String categoryName, boolean singletonMatch) {
        int size = bestCols.size();
        double bestScore = scores.getScore(bestCols.get(0), singletonMatch);
        for (int i = 1; i < size; ++i) {
            double score;
            String column = bestCols.get(i);
            if (column == null || !((score = (double)scores.getScore(column, singletonMatch)) > 0.0) || !(score >= bestScore - 0.5 * bestScore)) continue;
            int index = 0;
            for (Double dscore : this.bestScores) {
                if (dscore < score) break;
                ++index;
            }
            this.bestColumns.add(index, column);
            this.bestScores.add(index, score);
            this.bestCategories.add(index, categoryName);
        }
    }

    private class ThreadCalculator
    implements Runnable {
        TimeSeriesChunk tsChunk;
        ReferenceChunkSet refChunksSet;
        int index;

        public ThreadCalculator(TimeSeriesChunk tsChunk, ReferenceChunkSet refChunksSet, int index) {
            this.tsChunk = tsChunk;
            this.refChunksSet = refChunksSet;
            this.index = index;
        }

        @Override
        public void run() {
            Engine.this.makeComparisonsTSChunk2RefChunks(this.tsChunk, this.refChunksSet);
            Engine.this.threadActivity[this.index] = false;
        }
    }
}

