/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers.charts;

import java.awt.Image;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.hibernate.SessionFactory;

public abstract class AbstractChartsProducer
extends StandardLocalExternalAlgorithm {
    protected static String inputTableParameter = "InputTable";
    protected static String attributesParameter = "Attributes";
    protected static String quantitiesParameter = "Quantities";
    protected static String timeParameter = "Time";
    protected static String topElementsNumber = "TopElementsNumber";
    public LinkedHashMap<String, Image> producedImages = new LinkedHashMap();
    public LinkedHashMap<String, File> producedFiles = new LinkedHashMap();
    public boolean displaycharts = false;
    protected int maxElements = 10;
    protected SessionFactory connection = null;

    @Override
    protected abstract void setInputParameters();

    @Override
    public StatisticalType getOutput() {
        LinkedHashMap<String, PrimitiveType> outputmap = new LinkedHashMap<String, PrimitiveType>();
        if (this.producedImages.size() > 0) {
            PrimitiveType images = new PrimitiveType(HashMap.class.getName(), this.producedImages, PrimitiveTypes.IMAGES, "images", "Charts");
            outputmap.put("Images", images);
        }
        if (this.producedFiles.size() > 0) {
            for (String file : this.producedFiles.keySet()) {
                File f = this.producedFiles.get(file);
                PrimitiveType p = new PrimitiveType(File.class.getName(), f, PrimitiveTypes.FILE, f.getName(), file);
                outputmap.put(file, p);
            }
        }
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), outputmap, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    @Override
    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"ChartsProducer Initialized");
    }

    @Override
    public abstract String getDescription();

    public String[] getDimensions() {
        String dimensionS = IOHelper.getInputParameter(this.config, attributesParameter);
        String[] dimensions = null;
        try {
            dimensions = dimensionS.split(AlgorithmConfiguration.getListSeparator());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dimensions != null && dimensions.length == 1 && dimensions[0].trim().length() == 0) {
            dimensions = null;
        }
        return dimensions;
    }

    public String[] getQuantities() {
        String quantitieS = IOHelper.getInputParameter(this.config, quantitiesParameter);
        String[] quantities = new String[]{""};
        if (quantitieS != null) {
            quantities = quantitieS.split(AlgorithmConfiguration.getListSeparator());
        }
        return quantities;
    }

    public String getTimeDimension() {
        String timeS = IOHelper.getInputParameter(this.config, timeParameter);
        return timeS;
    }

    public String InfoRetrievalQuery(String table, String[] dimensions, String quantity, String time) {
        if (time != null) {
            if (dimensions != null && dimensions.length > 0) {
                return "select distinct " + Arrays.toString(dimensions).replace("[", "").replace("]", "") + " , " + quantity + " as qa123a," + time + " as timea123a from " + table + " order by timea123a";
            }
            return "select distinct " + quantity + "," + time + " from " + table + " order by " + time;
        }
        try {
            this.maxElements = Integer.parseInt(IOHelper.getInputParameter(this.config, topElementsNumber));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (dimensions != null && dimensions.length > 0) {
            String field = Arrays.toString(dimensions).replace("[", "").replace("]", "");
            return "select distinct " + field + " , sum(CAST (" + quantity + " as real))  as qa123a from " + table + " where CAST(" + quantity + " as character varying) <>'' " + " group by " + field + " order by qa123a DESC limit " + this.maxElements;
        }
        return "select distinct row_number() over(), " + quantity + " from " + table + " order by " + quantity + " DESC limit " + this.maxElements;
    }

    @Override
    protected void process() throws Exception {
        this.status = 10.0f;
        AnalysisLogger.setLogger(this.config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
        try {
            AnalysisLogger.getLogger().debug((Object)"ChartsProducer started");
            String driver = this.config.getParam("DatabaseDriver");
            String username = this.config.getParam("DatabaseUserName");
            String pwd = this.config.getParam("DatabasePassword");
            String url = this.config.getParam("DatabaseURL");
            String table = IOHelper.getInputParameter(this.config, inputTableParameter);
            AnalysisLogger.getLogger().debug((Object)("ChartsProducer: Driver: " + driver + " User " + username + " URL " + url + " Table: " + table));
            this.connection = DatabaseUtils.initDBSession(this.config);
            AnalysisLogger.getLogger().debug((Object)"ChartsProducer: Connection initialized");
            LexicalEngineConfiguration conf = new LexicalEngineConfiguration();
            conf.setDatabaseUserName(username);
            conf.setDatabasePassword(pwd);
            conf.setDatabaseDriver(driver);
            conf.setDatabaseURL(url);
            conf.setDatabaseDialect("org.hibernate.dialect.PostgreSQLDialect");
            String[] dimensions = this.getDimensions();
            String[] quantities = this.getQuantities();
            String time = this.getTimeDimension();
            boolean noCharts = true;
            this.status = 40.0f;
            float step = (90.0f - this.status) / (float)quantities.length;
            for (String quantity : quantities) {
                String query = this.InfoRetrievalQuery(table, dimensions, quantity, time);
                AnalysisLogger.getLogger().debug((Object)("ChartsProducer: Query for retrieving information " + query));
                List<Object> values = DatabaseFactory.executeSQLQuery(query, this.connection);
                if (values == null) {
                    throw new Exception("There are issued in managing selected attributes and quantities");
                }
                if (values.size() == 0) {
                    throw new Exception("There are no viable values to be processed");
                }
                LinkedHashMap<String, Object> charts = this.createCharts(dimensions, quantity, time, values, this.displaycharts);
                for (String chartName : charts.keySet()) {
                    Object chart = charts.get(chartName);
                    if (chart == null) continue;
                    noCharts = false;
                    if (chart instanceof File) {
                        this.producedFiles.put("Chart focused on " + quantity + " - " + chartName, (File)chart);
                        continue;
                    }
                    this.producedImages.put("Chart focused on " + quantity + " - " + chartName, (Image)chart);
                }
                this.status += step;
            }
            if (noCharts) {
                throw new Exception("Error - no chart was produced because of incompatibility with the selected input parameters");
            }
            AnalysisLogger.getLogger().debug((Object)"ChartsProducer: finished");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exception("Error during the computation: " + e.getMessage());
        }
        finally {
            this.shutdown();
            this.status = 100.0f;
        }
    }

    public abstract LinkedHashMap<String, Object> createCharts(String[] var1, String var2, String var3, List<Object> var4, boolean var5);

    @Override
    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"ChartsProducer shutdown");
        DatabaseUtils.closeDBConnection(this.connection);
    }
}

