/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.timeseries.charts.support.types;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.gcube.portlets.user.timeseries.charts.support.assertions.Assertion;
import org.gcube.portlets.user.timeseries.charts.support.exceptions.InvalidParameterException;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;
import org.gcube.portlets.user.timeseries.charts.support.types.ValueEntry;

public class GraphData
implements Serializable {
    private static final long serialVersionUID = 930654337632116093L;
    private List<Point<? extends Number, ? extends Number>> data = null;
    private Number minY = 0;
    private Number maxY = 50000;

    public GraphData() {
    }

    public GraphData(List<Point<? extends Number, ? extends Number>> data, boolean invertAxis) throws InvalidParameterException {
        Assertion<InvalidParameterException> checker = new Assertion<InvalidParameterException>();
        checker.validate(data != null && data.size() > 0, new InvalidParameterException("Invalid data. Null and empty not allowed"));
        this.data = invertAxis ? this.invertAxis(data) : data;
    }

    public final List<Point<? extends Number, ? extends Number>> getData() {
        return this.data;
    }

    private List<Point<? extends Number, ? extends Number>> invertAxis(List<Point<? extends Number, ? extends Number>> points) {
        Vector<Point<? extends Number, ? extends Number>> retval = new Vector<Point<? extends Number, ? extends Number>>();
        int linesNum = points.get(0).getEntries().size();
        int i = 0;
        while (i < linesNum) {
            try {
                retval.add(new Point(points.get(0).getEntries().get(i).getLabel(), Double.valueOf(points.get(0).getEntries().get(i).getValue().toString())));
            }
            catch (InvalidParameterException e) {
                e.printStackTrace();
            }
            ++i;
        }
        for (Point<? extends Number, ? extends Number> xPoint : points) {
            int i2 = 0;
            while (i2 < linesNum) {
                try {
                    ((Point)retval.get(i2)).addEntry(new ValueEntry<Double>(xPoint.getLabel(), Double.valueOf(xPoint.getEntries().get(i2).getValue().toString())));
                }
                catch (InvalidParameterException e) {
                    e.printStackTrace();
                }
                ++i2;
            }
        }
        return retval;
    }

    public final void setMaxY(Number maxY) {
        this.maxY = maxY;
    }

    public final void setMinY(Number minY) {
        this.minY = minY;
    }

    public final Number getMinY() {
        return this.minY;
    }

    public final Number getMaxY() {
        return this.maxY;
    }
}

