package org.gcube.dataanalysis.executor.plugin;

import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.lifetime.State.Done;
import org.gcube.common.core.utils.handlers.lifetime.State.Failed;
import org.gcube.common.core.utils.handlers.lifetime.State.Running;
import org.gcube.dataanalysis.executor.messagequeue.ATTRIBUTE;
import org.gcube.dataanalysis.executor.messagequeue.Consumer;
import org.gcube.dataanalysis.executor.messagequeue.QCONSTANTS;
import org.gcube.dataanalysis.executor.messagequeue.QueueManager;
import org.gcube.vremanagement.executor.plugin.ExecutorTask;
import org.gcube.vremanagement.executor.state.TaskRuntime;

public class GenericWorkerPlugin extends GCUBEHandler<TaskRuntime> implements ExecutorTask {

	@Override
	public void stop() throws UnsupportedOperationException, Exception {
		
		this.getLogger().trace("GenericWorkerPlugin: Stopped - closed all watchers");
	}

	public static Consumer activeT;
//	public static Producer activeP;
	public static QueueWatcher qWatcher;
	public static Hashtable<String, String> sessionBlackList;
	public static Boolean processing;
	public static Boolean creating;
	ConsumerWatcher consumerwatcher;
	Timer consumerWatcherTimer;
	
	@Override
	public void run() throws Exception {
		this.setState(Running.INSTANCE);
		this.getLogger().trace("GenericWorkerPlugin: Start");
		TaskRuntime runtime = this.getHandled();
		String nodeAddress = GHNContext.getContext().getHostname();

		Map<String, Object> inputs = runtime.getInputs();
		this.getLogger().trace("GenericWorkerPlugin: Inputs: " + inputs + " on node: " + nodeAddress);

		try {
			String uniqueTopicName = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.TOPIC_NAME.name()));
			String user = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.QUEUE_USER.name()));
			String password = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.QUEUE_PASSWORD.name()));
			String queueURL = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.QUEUE_URL.name()));
			String topicResponseName = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.TOPIC_RESPONSE_NAME.name()));
			String session = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.QSESSION.name()));
			String erase = ScriptIOWorker.getString((String) inputs.get(ATTRIBUTE.ERASE.name()));

			if (session == null) {
				this.getLogger().trace("GenericWorkerPlugin: Session is null ignoring message");
			} else {
				
				if (consumerwatcher==null || consumerWatcherTimer==null){
					this.getLogger().trace("GenericWorkerPlugin: Starting consumer watcher");
					consumerWatcherTimer = new Timer();
					consumerwatcher = new ConsumerWatcher();
					consumerWatcherTimer.schedule(consumerwatcher, 0, QCONSTANTS.QueueLifeTime);
				}
				
				if (qWatcher==null){
					qWatcher = new QueueWatcher(QCONSTANTS.QueueLifeTime);
				}
				if (qWatcher.isTooMuch()){
					resetAll();
				}
				// if a session has to be erased - then put it in the black list
				if ((erase != null) && (erase.equals("true"))) {
					this.getLogger().trace("GenericWorkerPlugin: purging session " + session + " on queue " + uniqueTopicName);
					if (sessionBlackList == null)
						sessionBlackList = new Hashtable<String, String>();
					sessionBlackList.put(session, uniqueTopicName);
					this.getLogger().trace("GenericWorkerPlugin: topic " + session + "on queue " + uniqueTopicName + " has been blacklisted");
				}
				// manage the case in which the worker is processing
				else {
					if (getProcessing()) {
						// ignore polling message
						this.getLogger().trace("GenericWorkerPlugin: Worker is Computing - Ignoring Request");
					} else {
						if (!getCreating()) {
							setCreating(true);
							// activate the messages consumer
							this.getLogger().trace("GenericWorkerPlugin: Adding Topic " + uniqueTopicName + " with session " + session);
							// activate queue manager
							if (activeT == null) {
								if (sessionBlackList == null)
									sessionBlackList = new Hashtable<String, String>();
								this.getLogger().trace("GenericWorkerPlugin: Active Queue is null - creating");
								this.getLogger().trace("GenericWorkerPlugin: Creating Producer");
								/*
								QueueManager qmR = new QueueManager();
								qmR.createAndConnect(user, password, queueURL, topicResponseName);
								activeP = new Producer(qmR, topicResponseName);
								*/
								this.getLogger().trace("GenericWorkerPlugin: Creating Consumer");
								QueueManager qm = new QueueManager();
								qm.createAndConnect(user, password, queueURL, uniqueTopicName);
								QueueListener ql = new QueueListener(qm, uniqueTopicName, nodeAddress, this.logger);
								activeT = new Consumer(qm, ql, ql, uniqueTopicName);
								this.getLogger().trace("GenericWorkerPlugin: Active Queue was created!");
								
								
							this.getLogger().trace("GenericWorkerPlugin: Setting Creation flag to FALSE");
							Thread.sleep(10000);
							setCreating(false);
							this.getLogger().trace("GenericWorkerPlugin: Creation was set to FALSE");
							}
						} else
							this.getLogger().trace("GenericWorkerPlugin: Warning - Worker is occupied");
					}
				}
				this.getLogger().trace("GenericWorkerPlugin: Finished");
			}

			this.setState(Done.INSTANCE);

		} catch (Exception e) {
			e.printStackTrace();
			this.getLogger().error("GenericWorkerPlugin: Error " + e.getLocalizedMessage());
			this.getLogger().trace("GenericWorkerPlugin: Completely Finished");
			this.setState(Failed.INSTANCE);
		} finally {
			stop();
		}
	}

	public static  void setProcessing(boolean state) {
		processing = state;
		if (processing)
			resetWatcher();
	}

	public static  boolean getProcessing() {
		if (processing == null)
			processing = false;

		return processing;
	}

	public static boolean getCreating() {
		if (creating == null)
			creating = false;

		return creating;
	}

	public static void setCreating(boolean state) {
		creating = state;
		if (creating)
			resetWatcher();
	}
	
	public static void resetWatcher(){
		qWatcher.reset();
	}
	
	public void resetAll(){
		try{
			if (activeT != null) {
				activeT.stop();
				activeT.closeSession();
				activeT=null;
				}
		}catch(Exception e){
			e.printStackTrace();
		}
		setCreating(false);
		
		/*
		try{
			if (activeP != null) {
				activeP.stop();
				activeP.closeSession();
				activeP=null;
				}
		}catch(Exception e){
			e.printStackTrace();
		}
		*/
		sessionBlackList = null;
		resetWatcher();
		purgeConsumerWatcher();
		this.getLogger().trace("GenericWorkerPlugin: Reset All!");
	}
	
	
	private void purgeConsumerWatcher(){
		
		this.getLogger().trace("GenericWorkerPlugin: Stopping - closing all watchers");
		if (consumerwatcher!=null){
			consumerwatcher.cancel();
			if (consumerWatcherTimer!=null){
				consumerWatcherTimer.cancel();
				consumerWatcherTimer.purge();
			}
			consumerwatcher=null;
			consumerWatcherTimer=null;
		}
		this.getLogger().trace("GenericWorkerPlugin: Stopping - closed all watchers");
	}
	
	public class ConsumerWatcher extends TimerTask {

		public ConsumerWatcher() {
		
		}
		@Override
		public void run() {
			try {
				if (qWatcher!=null && qWatcher.isTooMuch() && !getProcessing() && !getCreating()){
					resetAll();
				}
			} catch (Exception e) {
				System.out.println("GenericWorkerPlugin: ERROR IN RESETTING WATCHER!");
				e.printStackTrace();
			}
		}

	}
	
}
