package org.gcube.dataanalysis.copernicus.motu.client;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;

import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class ThreadedDownloader extends ThreadedWorker<DownloadRequestEnvelope> {

    /**
     * A Logger for this class
     */
    private static Logger logger = Logger.getLogger(ThreadedDownloader.class);

    /**
     * Default location of downloaded files
     */
    private static final String DEFAULT_DOWNLOAD_DIR = "/tmp";

    /**
     * The directory where files are downloaded to.
     */
    private File destinationDir;

    /**
     *
     */
    @Override
    public void doWork(DownloadRequestEnvelope chunk)
            throws MalformedURLException, IOException {
        URL source = new URL(chunk.getStatus().getRemoteUri());
        // File destination = new File(getDestinationDir(),
        // chunk.getStatus().getRequestId() + ".nc");
        File destination = new File(getDestinationDir(),
                chunk.getName() + ".nc");
        logger.info("downloading from " + source + " to " + destination);
        chunk.setDownloadStatus("downloading");
        FileUtils.copyURLToFile(source, destination);
        logger.info("download of " + destination.getName() + " complete.");
        chunk.setDownloadStatus("downloaded");
        chunk.setEnd(Calendar.getInstance());
    }

    /**
     * Return the destination directory of downloaded files.
     * 
     * @return The destination directory
     */
    public File getDestinationDir() {
        if (this.destinationDir != null) {
            return destinationDir;
        } else {
            return new File(DEFAULT_DOWNLOAD_DIR);
        }
    }

    /**
     * Set the destination directory of downloaded files.
     * 
     * @param dir
     *            The destination directory
     */
    public void setDestinationDir(final File dir) {
        this.destinationDir = dir;
    }

}
