/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import java.util.Collection;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequest;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequestEnvelope;
import org.gcube.dataanalysis.copernicus.motu.client.PlainMotuClient;
import org.gcube.dataanalysis.copernicus.motu.client.RequestSplitter;
import org.gcube.dataanalysis.copernicus.motu.client.ThreadedDownloader;
import org.gcube.dataanalysis.copernicus.motu.client.ThreadedSubmitter;
import org.gcube.dataanalysis.copernicus.motu.client.WorkCompleteListener;
import org.gcube.dataanalysis.copernicus.motu.model.Axis;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.gcube.dataanalysis.copernicus.motu.model.RequestSize;
import org.gcube.dataanalysis.copernicus.motu.model.ServiceMetadata;
import org.gcube.dataanalysis.copernicus.motu.model.StatusModeResponse;
import org.gcube.dataanalysis.copernicus.motu.util.NetworkUtils;

public class MotuClient
extends PlainMotuClient {
    private static final Logger LOGGER = Logger.getLogger(MotuClient.class);
    private Long preferredDownloadSize;
    private static final String[] DEFAULT_VAR_SPLIT = new String[]{"v", "t", "x", "y", "z"};
    private static final Long CHECK_INTERVAL = 10000L;

    public MotuClient(String serviceURL) {
        super(serviceURL);
    }

    public Long getPreferredDownloadSize() {
        if (this.preferredDownloadSize != null) {
            return this.preferredDownloadSize;
        }
        return Long.MAX_VALUE;
    }

    public void setPreferredDownloadSize(Long preferredDownloadSize) {
        this.preferredDownloadSize = preferredDownloadSize;
    }

    public void downloadProduct(DownloadRequest request) throws Exception {
        this.downloadProduct(request, DEFAULT_VAR_SPLIT);
    }

    @Override
    public RequestSize getSize(DownloadRequest request) throws Exception {
        this.ensureParameters(request);
        return super.getSize(request);
    }

    public RequestSize getSize(String service, String product) throws Exception {
        DownloadRequest request = new DownloadRequest();
        request.setService(service);
        request.setProduct(product);
        return this.getSize(request);
    }

    private DownloadRequest ensureParameters(DownloadRequest request) throws Exception {
        ProductMetadataInfo pmi = this.describeProduct(request);
        if (request.gettLo() == null) {
            request.settLo(pmi.getTimeCoverage().getStart());
        }
        if (request.gettHi() == null) {
            request.settHi(pmi.getTimeCoverage().getEnd());
        }
        for (Axis axis : pmi.getDataGeospatialCoverage()) {
            if (axis.getName().equals("lon")) {
                if (request.getxLo() == null) {
                    request.setxLo(Double.parseDouble(axis.getLower()));
                }
                if (request.getxHi() == null) {
                    request.setxHi(Double.parseDouble(axis.getUpper()));
                }
            }
            if (axis.getName().equals("lat")) {
                if (request.getyLo() == null) {
                    request.setyLo(Double.parseDouble(axis.getLower()));
                }
                if (request.getyHi() == null) {
                    request.setyHi(Double.parseDouble(axis.getUpper()));
                }
            }
            if (!axis.getName().equals("depth")) continue;
            if (request.getzLo() == null) {
                request.setzLo(Double.parseDouble(axis.getLower()));
            }
            if (request.getzHi() != null) continue;
            request.setzHi(Double.parseDouble(axis.getUpper()));
        }
        return request;
    }

    public ProductMetadataInfo describeProduct(String service, String product) throws Exception {
        DownloadRequest request = new DownloadRequest();
        request.setService(service);
        request.setProduct(product);
        return super.describeProduct(request);
    }

    public void downloadProduct(DownloadRequest request, String ... splitParameters) throws Exception {
        ThreadedSubmitter ts = new ThreadedSubmitter(this);
        final ThreadedDownloader td = new ThreadedDownloader();
        ts.setListener(new WorkCompleteListener<DownloadRequestEnvelope>(){

            @Override
            public void workComplete(DownloadRequestEnvelope chunk) {
                td.push(chunk);
            }
        });
        this.ensureParameters(request);
        RequestSplitter splitter = new RequestSplitter(request);
        splitter.setMotuClient(this);
        for (DownloadRequestEnvelope envelope : splitter.splitRequest(splitParameters)) {
            ts.push(envelope);
        }
        while (!ts.isComplete() || !td.isComplete()) {
            Thread.sleep(CHECK_INTERVAL);
        }
    }

    public Collection<ServiceMetadata> listServices() throws Exception {
        String url = this.getServiceURL() + "?action=listservices";
        String html = NetworkUtils.doGet(url, this.getCasProxy());
        String str = "<tr> <td> <a href=\\?action=listcatalog&service=([^>]+)> ([^<]+) </a> </td> <td> ([^<]+) </td> </tr>";
        str = str.replaceAll("\\s", "\\\\s*");
        Pattern pattern = Pattern.compile(str);
        Vector<ServiceMetadata> output = new Vector<ServiceMetadata>();
        Matcher m = pattern.matcher(html);
        while (m.find()) {
            ServiceMetadata service = new ServiceMetadata();
            service.setName(m.group(1).trim());
            service.setDescription(m.group(2).trim());
            service.setType(m.group(3).trim());
            output.add(service);
        }
        return output;
    }

    public Collection<String> listProductsNames(String service) throws Exception {
        String url = this.getServiceURL() + "?action=listcatalog&service=" + service;
        String html = NetworkUtils.doGet(url, this.getCasProxy());
        String str = "<a href=\\?action=productdownloadhome&service=([^&]+)&product=([^&>]+)>";
        str = str.replaceAll("\\s", "\\\\s*");
        Pattern pattern = Pattern.compile(str);
        Vector<String> output = new Vector<String>();
        Matcher m = pattern.matcher(html);
        while (m.find()) {
            output.add(m.group(2));
        }
        return output;
    }

    public Collection<StatusModeResponse> checkAllStatus(Collection<StatusModeResponse> requests) throws Exception {
        Vector<StatusModeResponse> out = new Vector<StatusModeResponse>();
        for (StatusModeResponse smr : requests) {
            out.add(super.checkStatus(smr.getRequestId()));
        }
        for (StatusModeResponse smr : out) {
            LOGGER.info((Object)("Status of " + smr.getRequestId() + " is " + smr.getStatus()));
        }
        return out;
    }
}

