/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import org.apache.log4j.Logger;
import org.gcube.dataanalysis.copernicus.motu.client.CASClient;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequest;
import org.gcube.dataanalysis.copernicus.motu.client.MultiValueParameters;
import org.gcube.dataanalysis.copernicus.motu.model.MotuUnmarshaller;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.gcube.dataanalysis.copernicus.motu.model.RequestSize;
import org.gcube.dataanalysis.copernicus.motu.model.StatusModeResponse;
import org.gcube.dataanalysis.copernicus.motu.util.NetworkUtils;

public class PlainMotuClient {
    private static Logger logger = Logger.getLogger(PlainMotuClient.class);
    private String serviceURL;
    private CASClient casProxy;
    private String username;
    private String password;

    public PlainMotuClient(String serviceURL) {
        this.serviceURL = serviceURL;
        this.casProxy = new CASClient();
    }

    public void setUsername(String username) {
        this.username = username;
        this.casProxy.setUsername(username);
    }

    public void setPassword(String password) {
        this.password = password;
        this.casProxy.setPassword(password);
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public StatusModeResponse queueProductDownload(DownloadRequest request) throws Exception {
        request.setAction("productdownload");
        logger.info((Object)"queuing request for product download...");
        String url = this.getServiceURL() + "?" + NetworkUtils.getDataString(request.getParametersMap());
        String xmlStatus = NetworkUtils.doGet(url, this.getCasProxy());
        logger.debug((Object)("status xml is " + xmlStatus));
        return MotuUnmarshaller.getStatusModeResponse(xmlStatus);
    }

    public RequestSize getSize(DownloadRequest request) throws Exception {
        request.setAction("getsize");
        logger.info((Object)"requesting response size...");
        String url = this.getServiceURL() + "?" + NetworkUtils.getDataString(request.getParametersMap());
        String xmlStatus = NetworkUtils.doGet(url, this.getCasProxy());
        logger.debug((Object)("status xml is " + xmlStatus));
        return MotuUnmarshaller.getRequestSize(xmlStatus);
    }

    public ProductMetadataInfo describeProduct(DownloadRequest request) throws Exception {
        request.setAction("describeproduct");
        logger.info((Object)"getting product metadata");
        String url = this.getServiceURL() + "?" + NetworkUtils.getDataString(request.getParametersMap());
        String xmlMetadata = NetworkUtils.doGet(url, this.getCasProxy());
        return MotuUnmarshaller.getProductMetadataInfo(xmlMetadata);
    }

    public void describeCoverage(DownloadRequest request) throws Exception {
        request.setAction("describecoverage");
        logger.info((Object)"getting product coverage");
        String url = this.getServiceURL() + "?" + NetworkUtils.getDataString(request.getParametersMap()) + "&datasetID=" + request.getProduct();
        String xmlCoverage = NetworkUtils.doGet(url, this.getCasProxy());
        logger.debug((Object)("coverage xml is " + xmlCoverage));
    }

    public StatusModeResponse checkStatus(String requestId) throws Exception {
        logger.info((Object)("checking status for request " + requestId));
        MultiValueParameters params = new MultiValueParameters();
        params.put("action", "getreqstatus");
        params.put("requestid", requestId);
        String url = this.getServiceURL() + "?" + NetworkUtils.getDataString(params);
        String xmlStatus = NetworkUtils.doGet(url, this.getCasProxy());
        logger.debug((Object)("status xml is " + xmlStatus));
        return MotuUnmarshaller.getStatusModeResponse(xmlStatus);
    }

    public StatusModeResponse waitForComplete(String requestId) throws Exception {
        StatusModeResponse statusResponse = null;
        while (true) {
            statusResponse = this.checkStatus(requestId);
            logger.debug((Object)statusResponse.getStatus());
            if (statusResponse.isInProgress()) {
                logger.info((Object)"Product is not yet ready. Waiting...");
            } else {
                if (statusResponse.isReady()) {
                    logger.info((Object)("Product is ready for download from " + statusResponse.getRemoteUri()));
                    break;
                }
                if (statusResponse.isError()) {
                    logger.error((Object)statusResponse.getMessage());
                    break;
                }
            }
            Thread.sleep(20000L);
        }
        return statusResponse;
    }

    public CASClient getCasProxy() {
        return this.casProxy;
    }
}

