/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Formatter;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.plug.CFpointObs;

public class CFpointObsExt
extends CFpointObs {
    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        return conv != null && conv.equalsIgnoreCase("CDM-Extended-CF");
    }

    @Override
    protected boolean identifyEncodingStation(NetcdfDataset ds, CFpointObs.EncodingInfo info, CF.FeatureType ftype, Formatter errlog) {
        Dimension stnDim;
        Structure obs = info.time.getParentStructure();
        if (obs.getRank() == 0) {
            errlog.format("CFpointObs: must have a non-scalar Time coordinate%n", new Object[0]);
            return false;
        }
        Dimension obsDim = obs.getDimension(0);
        Structure station = info.lat.getParentStructure();
        if (station.getRank() == 0) {
            info.set(CFpointObs.Encoding.single, null, obsDim);
        }
        if (this.identifyRaggeds(ds, info, stnDim = station.getDimension(0), obsDim, errlog)) {
            return true;
        }
        errlog.format("CFpointObsExt: %s Must have Lat/Lon coordinates of rank 0 or 1%n", new Object[]{ftype});
        return false;
    }

    @Override
    protected boolean identifyEncodingProfile(NetcdfDataset ds, CFpointObs.EncodingInfo info, Formatter errlog) {
        Evaluator.VarAtt varatt = Evaluator.findVariableWithAttribute(ds, "sample_dimension");
        if (varatt == null) {
            return false;
        }
        String dimName = varatt.att.getStringValue();
        Dimension obsDim = ds.findDimension(dimName);
        Structure profile = info.lat.getParentStructure();
        if (profile.getRank() == 0) {
            info.set(CFpointObs.Encoding.single, null, obsDim);
        }
        Dimension profileDim = profile.getDimension(0);
        info.childStruct = Evaluator.findStructureWithDimensions(ds, obsDim, null);
        if (this.identifyRaggeds(ds, info, profileDim, obsDim, errlog)) {
            return true;
        }
        errlog.format("CFpointObsExt: %s only supports ragged array representation%n", new Object[]{CF.FeatureType.profile});
        return false;
    }

    @Override
    protected boolean identifyEncodingTraj(NetcdfDataset ds, CFpointObs.EncodingInfo info, Formatter errlog) {
        Dimension trajDim;
        info.childStruct = info.lat.getParentStructure();
        Dimension obsDim = info.childStruct.getDimension(0);
        Variable varatt = Evaluator.findVariableWithAttributeValue(ds, "cf_role", "trajectory_id");
        Structure traj = varatt.getParentStructure();
        if (traj.getRank() == 0) {
            info.set(CFpointObs.Encoding.single, null, obsDim);
        }
        if (this.identifyRaggeds(ds, info, trajDim = traj.getDimension(0), obsDim, errlog)) {
            return true;
        }
        errlog.format("CFpointObsExt: %s only supports ragged array representation%n", new Object[]{CF.FeatureType.trajectory});
        return false;
    }

    @Override
    protected boolean identifyEncodingTimeSeriesProfile(NetcdfDataset ds, CFpointObs.EncodingInfo info, CF.FeatureType ftype, Formatter errlog) {
        Evaluator.VarAtt varatt = Evaluator.findVariableWithAttribute(ds, "sample_dimension");
        if (varatt == null) {
            return false;
        }
        String dimName = varatt.att.getStringValue();
        info.grandChildDim = ds.findDimension(dimName);
        info.grandChildStruct = Evaluator.findStructureWithDimensions(ds, info.grandChildDim, null);
        Variable stdId = Evaluator.findVariableWithAttributeValue(ds, "cf_role", "timeseries_id");
        Structure stn = stdId.getParentStructure();
        if (stn.getRank() == 0) {
            info.set(CFpointObs.Encoding.single, null, info.grandChildDim);
        }
        info.parentDim = stn.getDimension(0);
        info.parentStruct = stn;
        Variable profileId = Evaluator.findVariableWithAttributeValue(ds, "cf_role", "profile_id");
        Structure profile = profileId.getParentStructure();
        info.childDim = profile.getDimension(0);
        info.childStruct = profile;
        CoordinateAxis z = this.findZAxisNotStationAlt(ds);
        if (z == null) {
            errlog.format("CFpointObs: timeSeriesProfile must have a z coordinate, not the station altitude%n", new Object[0]);
            return false;
        }
        info.alt = z;
        if (this.identifyDoubleRaggeds(ds, info, errlog)) {
            return true;
        }
        errlog.format("CFpointObsExt: %s only supports ragged array representation%n", new Object[]{CF.FeatureType.timeSeriesProfile});
        return false;
    }

    @Override
    protected boolean identifyEncodingSection(NetcdfDataset ds, CFpointObs.EncodingInfo info, CF.FeatureType ftype, Formatter errlog) {
        Evaluator.VarAtt varatt = Evaluator.findVariableWithAttribute(ds, "sample_dimension");
        if (varatt == null) {
            return false;
        }
        String dimName = varatt.att.getStringValue();
        info.grandChildDim = ds.findDimension(dimName);
        info.grandChildStruct = Evaluator.findStructureWithDimensions(ds, info.grandChildDim, null);
        Variable trajId = Evaluator.findVariableWithAttributeValue(ds, "cf_role", "trajectory_id");
        Structure traj = trajId.getParentStructure();
        if (traj.getRank() == 0) {
            info.set(CFpointObs.Encoding.single, null, info.grandChildDim);
        }
        info.parentDim = traj.getDimension(0);
        info.parentStruct = traj;
        Variable profileId = Evaluator.findVariableWithAttributeValue(ds, "cf_role", "profile_id");
        Structure profile = profileId.getParentStructure();
        info.childDim = profile.getDimension(0);
        info.childStruct = profile;
        CoordinateAxis z = this.findZAxisNotStationAlt(ds);
        if (z == null) {
            errlog.format("CFpointObs: section must have a z coordinate%n", new Object[0]);
            return false;
        }
        if (z.getRank() == 0 && z.getParentStructure() == null) {
            errlog.format("CFpointObs: section cannot have a scalar z coordinate%n", new Object[0]);
            return false;
        }
        info.alt = z;
        if (this.identifyDoubleRaggeds(ds, info, errlog)) {
            return true;
        }
        errlog.format("CFpointObsExt: %s only supports ragged array representation%n", new Object[]{CF.FeatureType.trajectoryProfile});
        return false;
    }
}

