/*
 * Decompiled with CFR 0.152.
 */
package opendap.servers.parsers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import opendap.dap.parsers.ParseException;
import opendap.servers.parsers.CeParser;
import opendap.servers.parsers.Ceparse;
import opendap.servers.parsers.ExprParserConstants;
import ucar.nc2.util.EscapeStrings;

class Celex
implements CeParser.Lexer,
ExprParserConstants {
    static final String wordchars1 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%\\";
    static final String wordcharsn = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%\\ ";
    static final String numchars1 = "+-0123456789";
    static final String numcharsn = "Ee.+-0123456789";
    static final String wordornumberchars1 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%\\.";
    static final String wordornumbercharsn = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-+_/%\\ .";
    static String worddelims = "{}[]:;=,&";
    Ceparse parsestate = null;
    Reader stream = null;
    StringBuilder input = null;
    StringBuilder yytext = null;
    int charno = 0;
    Object lval = null;
    StringBuilder lookahead = null;
    String url = null;
    String constraint = null;

    public Celex(Ceparse state) {
        this.reset(state, null);
    }

    public void reset(Ceparse state, String constraint) {
        this.parsestate = state;
        this.input = new StringBuilder();
        this.yytext = new StringBuilder();
        this.lookahead = new StringBuilder();
        this.lval = null;
        this.charno = 0;
        this.constraint = constraint;
        this.stream = this.constraint == null ? null : new StringReader(this.constraint);
    }

    public String getInput() {
        return this.input.toString();
    }

    int peek() throws IOException {
        int c = this.read();
        this.pushback(c);
        return c;
    }

    void pushback(int c) {
        this.lookahead.insert(0, (char)c);
        --this.charno;
    }

    int read() throws IOException {
        int c;
        if (this.lookahead.length() == 0) {
            c = this.stream.read();
            if (c < 0) {
                c = 0;
            }
            ++this.charno;
        } else {
            c = this.lookahead.charAt(0);
            this.lookahead.deleteCharAt(0);
        }
        return c;
    }

    @Override
    public int yylex() throws ParseException {
        int token = 0;
        this.yytext.setLength(0);
        try {
            int c;
            token = -1;
            while (token < 0 && (c = this.read()) > 0) {
                if (c == 10 || c <= 32 || c == 127) continue;
                if (worddelims.indexOf(c) >= 0) {
                    token = c;
                    continue;
                }
                if (c == 34) {
                    boolean more = true;
                    while (more && (c = this.read()) > 0) {
                        if (c == 34) {
                            more = false;
                        } else if (c == 92 && (c = this.read()) < 0) {
                            more = false;
                        }
                        if (!more) continue;
                        this.yytext.append((char)c);
                    }
                    token = 259;
                    continue;
                }
                if (wordornumberchars1.indexOf(c) >= 0) {
                    int i;
                    boolean isnumber = false;
                    this.yytext.append((char)c);
                    while ((c = this.read()) > 0) {
                        if (wordornumbercharsn.indexOf(c) < 0) {
                            this.pushback(c);
                            break;
                        }
                        this.yytext.append((char)c);
                    }
                    this.removetrailingblanks();
                    try {
                        new Double(this.yytext.toString());
                        isnumber = true;
                    }
                    catch (NumberFormatException nfe) {
                        isnumber = false;
                    }
                    if (isnumber) {
                        token = 260;
                        continue;
                    }
                    token = 258;
                    int dotpoint = this.yytext.toString().indexOf(46);
                    if (dotpoint < 0) continue;
                    for (i = this.yytext.length() - 1; i >= 0; --i) {
                        this.pushback(this.yytext.charAt(i));
                    }
                    this.yytext.setLength(0);
                    if (dotpoint == 0) {
                        token = 46;
                        c = this.read();
                        this.yytext.append((char)c);
                        continue;
                    }
                    for (i = 0; i < dotpoint; ++i) {
                        c = this.read();
                        this.yytext.append((char)c);
                    }
                    continue;
                }
                token = c;
            }
            if (token < 0) {
                token = 0;
                this.lval = null;
            } else {
                String text = this.yytext.toString();
                if (token == 258) {
                    text = EscapeStrings.unescapeDAPIdentifier(text);
                }
                Object object = this.lval = text.length() == 0 ? (String)null : text;
            }
            if (this.parsestate.getDebugLevel() > 0) {
                this.dumptoken(token, (String)this.lval);
            }
            return token;
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    void dumptoken(int token, String lval) throws ParseException {
        switch (token) {
            case 259: {
                System.out.printf("TOKEN = |\"%s\"|%n", lval);
                break;
            }
            case 258: 
            case 260: {
                System.out.printf("TOKEN = |%s|%n", lval);
                break;
            }
            default: {
                System.out.printf("TOKEN = |%c|%n", Character.valueOf((char)token));
            }
        }
        System.err.flush();
    }

    static int tohex(int c) throws ParseException {
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        return -1;
    }

    @Override
    public Object getLVal() {
        return this.lval;
    }

    @Override
    public void yyerror(String s) {
        Ceparse.log.error("yyerror: constraint parse error:" + s + "; char " + this.charno);
        if (this.yytext.length() > 0) {
            Ceparse.log.error(" near |" + this.yytext + "|");
        }
        if (this.parsestate.getURL() != null) {
            Ceparse.log.error("\turl=" + this.parsestate.getURL());
        }
        Ceparse.log.error("\tconstraint=" + (this.constraint == null ? "none" : this.constraint));
    }

    public void lexerror(String msg) {
        StringBuilder nextline = new StringBuilder();
        try {
            int c;
            while ((c = this.read()) != -1 && c != 10) {
                nextline.append((char)c);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.printf("Lex error: %s; charno: %d: %s^%s%n", msg, this.charno, this.yytext, nextline);
    }

    void removetrailingblanks() {
        if (this.yytext.charAt(this.yytext.length() - 1) == ' ') {
            while (this.yytext.charAt(this.yytext.length() - 1) == ' ') {
                this.yytext.setLength(this.yytext.length() - 1);
            }
            this.pushback(32);
        }
    }
}

