/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.ThreddsMetadata;
import thredds.cataloggen.DatasetEnhancer;
import thredds.cataloggen.InvCrawlablePair;
import thredds.cataloggen.ProxyDatasetHandler;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.CrawlableDatasetLabeler;
import thredds.crawlabledataset.CrawlableDatasetSorter;
import ucar.nc2.util.URLnaming;

public class CollectionLevelScanner {
    private final String collectionPath;
    private String collectionName;
    private String collectionId = null;
    private final CrawlableDataset collectionLevel;
    private final CrawlableDataset catalogLevel;
    private final CrawlableDataset currentLevel;
    private final InvService service;
    private final CrawlableDatasetFilter filter;
    private CrawlableDatasetSorter sorter;
    private Map proxyDsHandlers;
    private CrawlableDatasetLabeler identifier;
    private CrawlableDatasetLabeler namer;
    private boolean doAddDataSize = false;
    private boolean addLastModified = true;
    private List childEnhancerList;
    private InvDatasetImpl topLevelMetadataContainer;
    private List catRefInfo;
    private List atomicDsInfo;
    private List proxyDsInfo;
    private InvCatalogImpl genCatalog;
    private int state;

    public CollectionLevelScanner(String collectionPath, CrawlableDataset collectionLevel, CrawlableDataset catalogLevel, CrawlableDataset currentLevel, CrawlableDatasetFilter filter, InvService service) {
        String string = this.collectionPath = collectionPath != null ? collectionPath : "";
        if (collectionLevel == null) {
            throw new IllegalArgumentException("The collection root must not be null.");
        }
        if (catalogLevel == null) {
            throw new IllegalArgumentException("The catalog root must not be null.");
        }
        if (service == null) {
            throw new IllegalArgumentException("The service must not be null.");
        }
        if (!catalogLevel.getPath().startsWith(collectionLevel.getPath())) {
            throw new IllegalArgumentException("The catalog root <" + catalogLevel.getPath() + "> must be under the collection root <" + collectionLevel.getPath() + ">.");
        }
        if (!collectionLevel.isCollection()) {
            throw new IllegalArgumentException("The collection root <" + collectionLevel.getPath() + "> must be a collection.");
        }
        if (!catalogLevel.isCollection()) {
            throw new IllegalArgumentException("The catalog root <" + catalogLevel.getPath() + "> must be a collection.");
        }
        this.collectionLevel = collectionLevel;
        this.catalogLevel = catalogLevel;
        if (currentLevel != null) {
            if (!currentLevel.isCollection()) {
                throw new IllegalArgumentException("The current root <" + currentLevel.getPath() + "> must be a collection.");
            }
            if (!currentLevel.getPath().startsWith(catalogLevel.getPath())) {
                throw new IllegalArgumentException("The current root <" + currentLevel.getPath() + "> must be under the catalog root <" + catalogLevel.getPath() + ">.");
            }
            this.currentLevel = currentLevel;
        } else {
            this.currentLevel = catalogLevel;
        }
        this.filter = filter;
        this.service = service;
        this.childEnhancerList = new ArrayList();
        this.catRefInfo = new ArrayList();
        this.atomicDsInfo = new ArrayList();
        this.proxyDsInfo = new ArrayList();
        this.collectionId = null;
        this.collectionName = null;
        this.state = 0;
    }

    public CollectionLevelScanner(CollectionLevelScanner cs) {
        this(cs.collectionPath, cs.collectionLevel, cs.catalogLevel, cs.currentLevel, cs.filter, cs.service);
        this.setSorter(cs.getSorter());
        this.setProxyDsHandlers(cs.getProxyDsHandlers());
        this.setCollectionId(cs.getCollectionId());
        this.setCollectionName(cs.getCollectionName());
        this.setIdentifier(cs.getIdentifier());
        this.setNamer(cs.getNamer());
        this.setDoAddDataSize(cs.getDoAddDataSize());
        this.childEnhancerList.add(cs.getChildEnhancerList());
    }

    public CrawlableDatasetSorter getSorter() {
        return this.sorter;
    }

    public void setSorter(CrawlableDatasetSorter sorter) {
        if (this.state != 0) {
            throw new IllegalStateException("No further setup allowed, scan in progress or completed.");
        }
        this.sorter = sorter;
    }

    public Map getProxyDsHandlers() {
        if (this.proxyDsHandlers.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.proxyDsHandlers);
    }

    public void setProxyDsHandlers(Map proxyDsHandlers) {
        if (this.state != 0) {
            throw new IllegalStateException("No further setup allowed, scan in progress or completed.");
        }
        this.proxyDsHandlers = proxyDsHandlers == null ? Collections.EMPTY_MAP : new HashMap(proxyDsHandlers);
    }

    public void setCollectionId(String collectionId) {
        if (this.state != 0) {
            throw new IllegalStateException("No further setup allowed, scan in progress or completed.");
        }
        this.collectionId = collectionId;
    }

    protected String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionName(String collectionName) {
        if (this.state != 0) {
            throw new IllegalStateException("No further setup allowed, scan in progress or completed.");
        }
        this.collectionName = collectionName;
    }

    protected String getCollectionName() {
        return this.collectionName;
    }

    public void setIdentifier(CrawlableDatasetLabeler identifier) {
        if (this.state != 0) {
            throw new IllegalStateException("No further setup allowed, scan in progress or completed.");
        }
        this.identifier = identifier;
    }

    protected CrawlableDatasetLabeler getIdentifier() {
        return this.identifier;
    }

    public void setNamer(CrawlableDatasetLabeler namer) {
        if (this.state != 0) {
            throw new IllegalStateException("No further setup allowed, scan in progress or completed.");
        }
        this.namer = namer;
    }

    protected CrawlableDatasetLabeler getNamer() {
        return this.namer;
    }

    public void setDoAddDataSize(boolean doAddDataSize) {
        if (this.state != 0) {
            throw new IllegalStateException("No further setup allowed, scan in progress or completed.");
        }
        this.doAddDataSize = doAddDataSize;
    }

    protected boolean getDoAddDataSize() {
        return this.doAddDataSize;
    }

    public void addChildEnhancer(DatasetEnhancer childEnhancer) {
        if (this.state != 0) {
            throw new IllegalStateException("No further setup allowed, scan in progress or completed.");
        }
        this.childEnhancerList.add(childEnhancer);
    }

    List getChildEnhancerList() {
        return Collections.unmodifiableList(this.childEnhancerList);
    }

    public void setTopLevelMetadataContainer(InvDatasetImpl topLevelMetadataContainer) {
        this.topLevelMetadataContainer = topLevelMetadataContainer;
    }

    public void scan() throws IOException {
        if (this.state == 1) {
            throw new IllegalStateException("Scan already underway.");
        }
        if (this.state >= 2) {
            throw new IllegalStateException("Scan has already been generated.");
        }
        this.state = 1;
        if (this.proxyDsHandlers == null) {
            this.proxyDsHandlers = Collections.EMPTY_MAP;
        }
        this.genCatalog = this.createSkeletonCatalog(this.currentLevel);
        InvDatasetImpl topInvDs = (InvDatasetImpl)this.genCatalog.getDatasets().get(0);
        List<CrawlableDataset> crDsList = this.currentLevel.listDatasets(this.filter);
        if (this.sorter != null) {
            this.sorter.sort(crDsList);
        }
        for (int i = 0; i < crDsList.size(); ++i) {
            CrawlableDataset curCrDs = crDsList.get(i);
            InvDatasetImpl curInvDs = this.createInvDatasetFromCrawlableDataset(curCrDs, topInvDs, null);
            InvCrawlablePair dsInfo = new InvCrawlablePair(curCrDs, curInvDs);
            if (curCrDs.isCollection()) {
                this.catRefInfo.add(dsInfo);
            } else {
                this.atomicDsInfo.add(dsInfo);
            }
            topInvDs.addDataset(curInvDs);
        }
        this.genCatalog.finish();
        if (this.atomicDsInfo.size() > 0) {
            boolean anyProxiesAdded = false;
            for (ProxyDatasetHandler curProxy : this.proxyDsHandlers.values()) {
                InvService proxyService = curProxy.getProxyDatasetService(this.currentLevel);
                if (proxyService == null) continue;
                CrawlableDataset crDsToAdd = curProxy.createProxyDataset(this.currentLevel);
                InvDatasetImpl invDsToAdd = this.createInvDatasetFromCrawlableDataset(crDsToAdd, topInvDs, proxyService);
                InvCrawlablePair dsInfo = new InvCrawlablePair(crDsToAdd, invDsToAdd);
                this.proxyDsInfo.add(dsInfo);
                int index = curProxy.getProxyDatasetLocation(this.currentLevel, topInvDs.getDatasets().size());
                topInvDs.addDataset(index, invDsToAdd);
                this.genCatalog.addService(proxyService);
                anyProxiesAdded = true;
            }
            if (anyProxiesAdded) {
                this.genCatalog.finish();
            }
        }
        this.addTopLevelMetadata(this.genCatalog, true);
        this.state = 2;
    }

    List getCatRefInfo() {
        if (this.state != 2) {
            throw new IllegalStateException("Scan has not been performed.");
        }
        return Collections.unmodifiableList(this.catRefInfo);
    }

    List getAtomicDsInfo() {
        if (this.state != 2) {
            throw new IllegalStateException("Scan has not been performed.");
        }
        return Collections.unmodifiableList(this.atomicDsInfo);
    }

    public InvCatalogImpl generateCatalog() throws IOException {
        if (this.state != 2) {
            throw new IllegalStateException("Scan has not been performed.");
        }
        return this.genCatalog;
    }

    public InvCatalogImpl generateProxyDsResolverCatalog(ProxyDatasetHandler pdh) {
        if (this.state != 2) {
            throw new IllegalStateException("Scan has not been performed.");
        }
        if (!this.proxyDsHandlers.containsValue(pdh)) {
            throw new IllegalArgumentException("Unknown ProxyDatasetHandler.");
        }
        InvCatalogImpl catalog = this.createSkeletonCatalog(this.currentLevel);
        InvDatasetImpl topDs = (InvDatasetImpl)catalog.getDatasets().get(0);
        InvCrawlablePair actualDsInfo = pdh.getActualDataset(this.atomicDsInfo);
        if (actualDsInfo == null) {
            return catalog;
        }
        InvDatasetImpl actualInvDs = (InvDatasetImpl)actualDsInfo.getInvDataset();
        actualInvDs.setName(pdh.getActualDatasetName(actualDsInfo, topDs.getName()));
        catalog.removeDataset(topDs);
        catalog.addDataset(actualInvDs);
        catalog.finish();
        this.addTopLevelMetadata(catalog, false);
        return catalog;
    }

    private void addTopLevelMetadata(InvCatalog catalog, boolean isRegularCatalog) {
        if (this.topLevelMetadataContainer == null) {
            return;
        }
        if (!this.catalogLevel.getPath().equals(this.currentLevel.getPath())) {
            return;
        }
        InvDatasetImpl topInvDs = catalog.getDataset();
        topInvDs.transferMetadata(this.topLevelMetadataContainer, true);
        for (InvAccess invAccess : this.topLevelMetadataContainer.getAccess()) {
            topInvDs.addAccess(invAccess);
            InvService s = invAccess.getService();
            ((InvCatalogImpl)catalog).addService(s);
        }
        boolean isCollectionLevel = this.catalogLevel.getPath().equals(this.collectionLevel.getPath());
        if (isCollectionLevel && isRegularCatalog) {
            topInvDs.setHarvest(this.topLevelMetadataContainer.isHarvest());
            topInvDs.setCollectionType(this.topLevelMetadataContainer.getCollectionType());
        }
        ((InvCatalogImpl)catalog).finish();
    }

    private InvCatalogImpl createSkeletonCatalog(CrawlableDataset topCrDs) {
        InvCatalogImpl catalog = new InvCatalogImpl(null, null, null);
        catalog.addService(this.service);
        String newName = null;
        if (this.namer != null) {
            newName = this.namer.getLabel(topCrDs);
        }
        if (newName == null && this.collectionLevel.getPath().equals(this.catalogLevel.getPath())) {
            newName = this.collectionName;
        }
        if (newName == null) {
            newName = this.getName(topCrDs);
        }
        InvDatasetImpl topDs = new InvDatasetImpl(null, newName, null, null, null);
        String newId = null;
        newId = this.identifier != null ? this.identifier.getLabel(topCrDs) : this.getID(topCrDs);
        if (newId != null) {
            topDs.setID(newId);
        }
        ThreddsMetadata tm = new ThreddsMetadata(false);
        tm.setServiceName(this.service.getName());
        InvMetadata md = new InvMetadata(topDs, null, "http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0", "", true, true, null, tm);
        ThreddsMetadata tm2 = new ThreddsMetadata(false);
        tm2.addMetadata(md);
        topDs.setLocalMetadata(tm2);
        catalog.addDataset(topDs);
        return catalog;
    }

    private InvDatasetImpl createInvDatasetFromCrawlableDataset(CrawlableDataset crawlableDs, InvDatasetImpl parentInvDs, InvService service) {
        InvDatasetImpl curInvDs;
        String newName = null;
        if (this.namer != null) {
            newName = this.namer.getLabel(crawlableDs);
        }
        if (newName == null) {
            newName = this.getName(crawlableDs);
        }
        if (crawlableDs.isCollection()) {
            curInvDs = new InvCatalogRef(parentInvDs, newName, this.getXlinkHref(crawlableDs));
        } else {
            Date lastModDate;
            curInvDs = new InvDatasetImpl(parentInvDs, newName, null, service != null ? service.getName() : null, this.getUrlPath(crawlableDs, service));
            if (this.doAddDataSize && crawlableDs.length() != -1L) {
                curInvDs.setDataSize(crawlableDs.length());
            }
            if (this.addLastModified && (lastModDate = crawlableDs.lastModified()) != null) {
                curInvDs.setLastModifiedDate(lastModDate);
            }
        }
        String newId = null;
        newId = this.identifier != null ? this.identifier.getLabel(crawlableDs) : this.getID(crawlableDs);
        if (newId != null) {
            curInvDs.setID(newId);
        }
        Iterator it2 = this.childEnhancerList.iterator();
        while (it2.hasNext()) {
            ((DatasetEnhancer)it2.next()).addMetadata(curInvDs, crawlableDs);
        }
        return curInvDs;
    }

    private String getName(CrawlableDataset dataset) {
        return dataset.getName();
    }

    private String getID(CrawlableDataset dataset) {
        if (dataset == null) {
            return null;
        }
        if (this.collectionId == null) {
            return null;
        }
        int i = this.collectionLevel.getPath().length();
        String id = dataset.getPath().substring(i);
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if (this.collectionId.equals("")) {
            if (id.equals("")) {
                return null;
            }
            return id;
        }
        if (id.equals("")) {
            return this.collectionId;
        }
        return this.collectionId + "/" + id;
    }

    private String getUrlPath(CrawlableDataset dataset, InvService service) {
        InvService serviceForThisDs;
        InvService invService = serviceForThisDs = service != null ? service : this.service;
        if (serviceForThisDs.getBase().equals("") && !serviceForThisDs.getServiceType().equals(ServiceType.COMPOUND)) {
            String urlPath = dataset.getPath().substring(this.catalogLevel.getPath().length());
            if (urlPath.startsWith("/")) {
                urlPath = urlPath.substring(1);
            }
            return urlPath;
        }
        if (serviceForThisDs.isRelativeBase()) {
            String relPath = dataset.getPath().substring(this.collectionLevel.getPath().length());
            if (relPath.startsWith("/")) {
                relPath = relPath.substring(1);
            }
            return (this.collectionPath.equals("") ? "" : this.collectionPath + "/") + relPath;
        }
        String relPath = dataset.getPath().substring(this.collectionLevel.getPath().length());
        if (relPath.startsWith("/")) {
            relPath = relPath.substring(1);
        }
        return relPath;
    }

    private String getXlinkHref(CrawlableDataset dataset) {
        String path = dataset.getPath().substring(this.catalogLevel.getPath().length());
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        path = path.endsWith("/") ? path + "catalog.xml" : path + "/catalog.xml";
        return URLnaming.escapePathForURL(path);
    }
}

