/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.StructureData;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.PointObsDatasetImpl;
import ucar.nc2.dt.point.RecordDatasetHelper;
import ucar.nc2.dt.point.UnidataObsDatasetHelper;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonRect;

public class UnidataPointObsDataset
extends PointObsDatasetImpl
implements TypedDatasetFactoryIF {
    private Variable latVar;
    private Variable lonVar;
    private Variable altVar;
    private Variable timeVar;
    private Variable timeNominalVar;
    private RecordDatasetHelper recordHelper;
    private ArrayList allData;

    public static boolean isValidFile(NetcdfFile ds) {
        if (!ds.findAttValueIgnoreCase(null, "cdm_data_type", "").equalsIgnoreCase(FeatureType.POINT.toString()) && !ds.findAttValueIgnoreCase(null, "cdm_datatype", "").equalsIgnoreCase(FeatureType.POINT.toString())) {
            return false;
        }
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equalsIgnoreCase("Unidata Observation Dataset v1.0")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return UnidataPointObsDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new UnidataPointObsDataset(ncd);
    }

    public UnidataPointObsDataset() {
    }

    public UnidataPointObsDataset(NetcdfDataset ds) throws IOException {
        super(ds);
        this.latVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Lat);
        this.lonVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Lon);
        this.timeVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Time);
        if (this.latVar == null) {
            throw new IllegalStateException("Missing latitude variable");
        }
        if (this.lonVar == null) {
            throw new IllegalStateException("Missing longitude coordinate variable");
        }
        if (this.timeVar == null) {
            throw new IllegalStateException("Missing time coordinate variable");
        }
        this.altVar = UnidataObsDatasetHelper.getCoordinate(ds, AxisType.Height);
        this.timeNominalVar = UnidataObsDatasetHelper.findVariable(ds, "record.time_nominal");
        String recDimName = ds.findAttValueIgnoreCase(null, "observationDimension", null);
        this.recordHelper = new RecordDatasetHelper(ds, this.timeVar.getShortName(), this.timeNominalVar == null ? null : this.timeNominalVar.getShortName(), this.dataVariables, recDimName, this.parseInfo);
        this.recordHelper.setLocationInfo(this.latVar.getShortName(), this.lonVar.getShortName(), this.altVar == null ? null : this.altVar.getShortName());
        this.recordHelper.setShortNames(this.latVar.getShortName(), this.lonVar.getShortName(), this.altVar == null ? null : this.altVar.getShortName(), this.timeVar.getShortName(), this.timeNominalVar == null ? null : this.timeNominalVar.getShortName());
        this.allData = this.recordHelper.readAllCreateObs(null);
        this.removeDataVariable(this.timeVar.getShortName());
        if (this.timeNominalVar != null) {
            this.removeDataVariable(this.timeNominalVar.getShortName());
        }
        this.removeDataVariable(this.latVar.getShortName());
        this.removeDataVariable(this.lonVar.getShortName());
        if (this.altVar != null) {
            this.removeDataVariable(this.altVar.getShortName());
        }
        this.timeUnit = this.recordHelper.timeUnit;
        try {
            this.startDate = UnidataObsDatasetHelper.getStartDate(ds);
            this.endDate = UnidataObsDatasetHelper.getEndDate(ds);
        }
        catch (IllegalArgumentException e) {
            this.parseInfo.append("Missing time_coverage_start or end attributes");
        }
        try {
            this.boundingBox = UnidataObsDatasetHelper.getBoundingBox(ds);
        }
        catch (IllegalArgumentException e) {
            this.parseInfo.append("Missing geospatial_lat(lon)_min(max) attributes");
        }
        this.setTimeUnits();
        this.title = ds.findAttValueIgnoreCase(null, "title", null);
        this.desc = ds.findAttValueIgnoreCase(null, "description", null);
    }

    @Override
    protected void setTimeUnits() {
        this.timeUnit = this.recordHelper.timeUnit;
    }

    @Override
    protected void setStartDate() {
        this.startDate = this.timeUnit.makeDate(this.recordHelper.minDate);
    }

    @Override
    protected void setEndDate() {
        this.endDate = this.timeUnit.makeDate(this.recordHelper.maxDate);
    }

    @Override
    protected void setBoundingBox() {
        this.boundingBox = this.recordHelper.boundingBox;
    }

    @Override
    public List getData(CancelTask cancel) throws IOException {
        return this.allData;
    }

    @Override
    public int getDataCount() {
        return (int)this.recordHelper.getRecordVar().getSize();
    }

    @Override
    public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return this.recordHelper.getData(this.allData, boundingBox, cancel);
    }

    @Override
    public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.recordHelper.getData(this.allData, boundingBox, startTime, endTime, cancel);
    }

    @Override
    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new PointDatatypeIterator(this.recordHelper.recordVar, bufferSize);
    }

    private class PointDatatypeIterator
    extends DatatypeIterator {
        @Override
        protected Object makeDatatypeWithData(int recnum, StructureData sdata) {
            RecordDatasetHelper recordDatasetHelper = UnidataPointObsDataset.this.recordHelper;
            recordDatasetHelper.getClass();
            return new RecordDatasetHelper.RecordPointObs(recordDatasetHelper, recnum, sdata);
        }

        PointDatatypeIterator(Structure struct, int bufferSize) {
            super(struct, bufferSize);
        }
    }
}

