/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.seadatanet;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.seadatanet.DivaAnalysisGetResponse;
import org.gcube.dataanalysis.seadatanet.DivaFilePostResponse;
import org.gcube.dataanalysis.seadatanet.DivaHTTPClient;
import org.hibernate.SessionFactory;

public class SeaDataNetConnector
extends StandardLocalExternalAlgorithm {
    LinkedHashMap<String, String> statResultMap = new LinkedHashMap();
    LinkedHashMap<String, StatisticalType> outputDivaMap = new LinkedHashMap();
    SessionFactory dbconnection;
    File outputfile;

    public void init() throws Exception {
    }

    public String getDescription() {
        return "A connector for the SeaDataNet infrastructure. This algorithms invokes the Data-Interpolating Variational Analysis (DIVA) SeaDataNet service to interpolate spatial data. The model uses GEBCO bathymetry data and requires an estimate of the maximum spatial span of the correlation between points and the signal-to-noise ratio, among the other parameters. It can interpolate up to 10,000 points randomly taken from the input table. As output, it produces a NetCDF file with a uniform grid of values. This powerful interpolation model is described in Troupin et al. 2012, 'Generation of analysis and consistent error \ufb01elds using the Data Interpolating Variational Analysis (Diva)', Ocean Modelling, 52-53, 90-101.";
    }

    protected void process() throws Exception {
        File neofile = null;
        File fileForDiva = null;
        try {
            try {
                String outpath = this.config.getPersistencePath();
                neofile = new File(outpath, "seadn_diva_" + UUID.randomUUID() + ".nc");
                AnalysisLogger.getLogger().debug((Object)"Input Parameters");
                AnalysisLogger.getLogger().debug((Object)("Input Table: " + this.config.getParam("InputTable")));
                AnalysisLogger.getLogger().debug((Object)("Input Long: " + this.config.getParam("Longitude")));
                AnalysisLogger.getLogger().debug((Object)("Input Lat: " + this.config.getParam("Latitude")));
                AnalysisLogger.getLogger().debug((Object)("Input Qt: " + this.config.getParam("Quantity")));
                AnalysisLogger.getLogger().debug((Object)("Longitude min X: " + this.config.getParam("LongitudeMinValue")));
                AnalysisLogger.getLogger().debug((Object)("Longitude max X: " + this.config.getParam("LongitudeMaxValue")));
                AnalysisLogger.getLogger().debug((Object)("Longitude resolution: " + this.config.getParam("LongitudeResolution")));
                AnalysisLogger.getLogger().debug((Object)("Latitude min Y: " + this.config.getParam("LatitudeMinValue")));
                AnalysisLogger.getLogger().debug((Object)("Latitude max Y: " + this.config.getParam("LatitudeMaxValue")));
                AnalysisLogger.getLogger().debug((Object)("Latitude resolution: " + this.config.getParam("LatitudeResolution")));
                AnalysisLogger.getLogger().debug((Object)("Correlation length: " + this.config.getParam("CorrelationLength")));
                AnalysisLogger.getLogger().debug((Object)("Signal noise value: " + this.config.getParam("SignalNoise")));
                AnalysisLogger.getLogger().debug((Object)("Depth Level: " + this.config.getParam("DepthLevel")));
                Double correlationVal = null;
                Double signalNoiseVal = null;
                Double longMinVal = null;
                Double longMaxVal = null;
                Double longResolutionVal = null;
                Double latMinVal = null;
                Double latMaxVal = null;
                Double latResolutionVal = null;
                Double depthLevelVal = null;
                AnalysisLogger.getLogger().debug((Object)"Checking parameters");
                try {
                    correlationVal = Double.parseDouble(this.config.getParam("CorrelationLength"));
                    if (correlationVal < 0.0) {
                        throw new Exception("Correlation span cannot be negative.");
                    }
                    signalNoiseVal = Double.parseDouble(this.config.getParam("SignalNoise"));
                    if (signalNoiseVal < 0.0) {
                        throw new Exception("Signal-to-noise ratio cannot be negative.");
                    }
                    longMinVal = Double.parseDouble(this.config.getParam("LongitudeMinValue"));
                    if (longMinVal < -180.0) {
                        throw new Exception("Longitudine minumum value is less than -180.");
                    }
                    longMaxVal = Double.parseDouble(this.config.getParam("LongitudeMaxValue"));
                    if (longMaxVal > 180.0) {
                        throw new Exception("Longitudine maximum value is more than 180.");
                    }
                    longResolutionVal = Double.parseDouble(this.config.getParam("LongitudeResolution"));
                    latMinVal = Double.parseDouble(this.config.getParam("LatitudeMinValue"));
                    if (latMinVal < -85.0) {
                        throw new Exception("Latitude minumum value is less than -85.");
                    }
                    latMaxVal = Double.parseDouble(this.config.getParam("LatitudeMaxValue"));
                    if (latMaxVal > 85.0) {
                        throw new Exception("Latitude maximum value is more than 85.");
                    }
                    latResolutionVal = Double.parseDouble(this.config.getParam("LatitudeResolution"));
                    depthLevelVal = Double.parseDouble(this.config.getParam("DepthLevel"));
                    if (depthLevelVal < 0.0) {
                        throw new Exception("Depth Level cannot be negative");
                    }
                }
                catch (NumberFormatException e) {
                    throw new Exception("Parameter values are incomplete");
                }
                AnalysisLogger.getLogger().debug((Object)"Parameters are OK");
                AnalysisLogger.getLogger().debug((Object)"Initializing DB connection");
                this.dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
                String query = "select " + this.config.getParam("Longitude") + "," + this.config.getParam("Latitude") + "," + this.config.getParam("Quantity") + " From " + this.getInputParameter("InputTable") + " ORDER BY RANDOM() limit 10000";
                this.status = 10.0f;
                AnalysisLogger.getLogger().debug((Object)("Query for extracting data from the DB: " + query));
                List dataList = DatabaseFactory.executeSQLQuery((String)query, (SessionFactory)this.dbconnection);
                int ndata = dataList.size();
                fileForDiva = new File(outpath, "file_for_diva_" + UUID.randomUUID() + ".txt");
                BufferedWriter fileWriterDiva = new BufferedWriter(new FileWriter(fileForDiva));
                AnalysisLogger.getLogger().debug((Object)("Writing input file in: " + fileForDiva.getAbsolutePath()));
                for (Object o : dataList) {
                    Object[] oarray = (Object[])o;
                    fileWriterDiva.write(" " + oarray[0] + " " + oarray[1] + " " + oarray[2] + "\n");
                }
                fileWriterDiva.close();
                AnalysisLogger.getLogger().debug((Object)("Sending data to DIVA: Uploading " + ndata + " records"));
                DivaFilePostResponse response = DivaHTTPClient.uploadFile(fileForDiva);
                AnalysisLogger.getLogger().debug((Object)("DIVA Server Response for the Upload:\n" + response.getSessionid()));
                this.status = 50.0f;
                AnalysisLogger.getLogger().debug((Object)"Requesting analysis to DIVA...");
                long t0 = System.currentTimeMillis();
                DivaAnalysisGetResponse respAnalysis = DivaHTTPClient.getAnalysis(response.getSessionid(), correlationVal, signalNoiseVal, longMinVal, longMaxVal, longResolutionVal, latMinVal, latMaxVal, latResolutionVal, depthLevelVal);
                long t1 = System.currentTimeMillis();
                AnalysisLogger.getLogger().debug((Object)("Analysis finished in " + (t1 - t0) + " ms"));
                this.status = 80.0f;
                this.statResultMap.put("Minimum value estimated by the model", "" + respAnalysis.getVmin());
                this.statResultMap.put("Maximum value estimated by the model", "" + respAnalysis.getVmax());
                this.statResultMap.put("Number of observations used", "" + respAnalysis.getStat_obs_count_used());
                this.statResultMap.put("A posteriori estimate of signal-to-noise ratio", "" + respAnalysis.getStat_posteriori_stn());
                AnalysisLogger.getLogger().debug((Object)("Map of results to be returned: " + this.statResultMap));
                AnalysisLogger.getLogger().debug((Object)("Downloading result file in " + neofile.getAbsolutePath()));
                DivaHTTPClient.downloadFileDiva(respAnalysis.getIdentifier(), neofile.getAbsolutePath());
                this.outputfile = neofile;
                AnalysisLogger.getLogger().debug((Object)"Downloading finished");
            }
            catch (Exception e) {
                if (neofile.exists()) {
                    neofile.delete();
                    AnalysisLogger.getLogger().debug((Object)("Output file " + neofile.getAbsolutePath() + " deleted!"));
                }
                throw e;
            }
        }
        finally {
            if (fileForDiva.exists()) {
                fileForDiva.delete();
                AnalysisLogger.getLogger().debug((Object)("Input file " + fileForDiva.getAbsolutePath() + " deleted!"));
            }
            AnalysisLogger.getLogger().debug((Object)"DIVA process finished");
        }
    }

    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, "InputTable", "Input tabular resource. Up to 10,000 points will be randomly taken from this table.");
        this.inputs.add(tinput);
        ColumnType p1 = new ColumnType("InputTable", "Longitude", "The column containing longitude decimal values", "longitude", false);
        ColumnType p2 = new ColumnType("InputTable", "Latitude", "The column containing latitude decimal values", "latitude", false);
        ColumnType p3 = new ColumnType("InputTable", "Quantity", "The column containing quantity values", "quantity", false);
        this.inputs.add(p1);
        this.inputs.add(p2);
        this.inputs.add(p3);
        PrimitiveType p4 = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, "LongitudeMinValue", "Minimum deg. value of the longitude range (min -180)", "-180");
        PrimitiveType p5 = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, "LongitudeMaxValue", "Maximum deg. value of the longitude range (max 180)", "180");
        PrimitiveType p6 = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, "LongitudeResolution", "Longitude resolution (minimum 0.1 - maximum 10)", "1");
        PrimitiveType p7 = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, "LatitudeMinValue", "Minimum deg value of Latitude Range (min -85)", "-85");
        PrimitiveType p8 = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, "LatitudeMaxValue", "Maximum value of Latitude Range (max 85)", "85");
        PrimitiveType p9 = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, "LatitudeResolution", "Latitude resolution (minimum 0.1 - maximum 10)", "1");
        PrimitiveType p10 = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, "CorrelationLength", "Correlation length (arc degrees)", "10.35");
        PrimitiveType p11 = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, "SignalNoise", "Signal to noise ratio", "1.08");
        PrimitiveType p12 = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, "DepthLevel", "Depth level (meters)", "0");
        this.inputs.add(p4);
        this.inputs.add(p5);
        this.inputs.add(p6);
        this.inputs.add(p7);
        this.inputs.add(p8);
        this.inputs.add(p9);
        this.inputs.add(p10);
        this.inputs.add(p11);
        this.inputs.add(p12);
        DatabaseType.addDefaultDBPars((List)this.inputs);
    }

    public void shutdown() {
        if (this.dbconnection != null) {
            this.dbconnection.close();
        }
    }

    public StatisticalType getOutput() {
        PrimitiveType file = new PrimitiveType(File.class.getName(), (Object)this.outputfile, PrimitiveTypes.FILE, "NetCDFOutputFile", "Output file in NetCDF format");
        for (String key : this.statResultMap.keySet()) {
            String value = this.statResultMap.get(key);
            PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)value, PrimitiveTypes.STRING, key, key);
            this.outputDivaMap.put(key, (StatisticalType)val);
        }
        this.outputDivaMap.put("Netcdf output file", (StatisticalType)file);
        PrimitiveType hashma = new PrimitiveType(HashMap.class.getName(), this.outputDivaMap, PrimitiveTypes.MAP, "Diva results", "Output of DIVA fit");
        return hashma;
    }
}

