/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import com.mongodb.util.JSON;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBSONObject
extends LinkedHashMap<String, Object>
implements BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;

    public BasicBSONObject() {
    }

    public BasicBSONObject(int size) {
        super(size);
    }

    public BasicBSONObject(String key, Object value) {
        this.put(key, value);
    }

    public BasicBSONObject(Map m) {
        super(m);
    }

    @Override
    public Map toMap() {
        return new LinkedHashMap<String, Object>(this);
    }

    @Override
    public Object removeField(String key) {
        return this.remove(key);
    }

    @Override
    public boolean containsField(String field) {
        return super.containsKey(field);
    }

    @Override
    @Deprecated
    public boolean containsKey(String key) {
        return this.containsField(key);
    }

    @Override
    public Object get(String key) {
        return super.get(key);
    }

    public int getInt(String key) {
        Object o = this.get(key);
        if (o == null) {
            throw new NullPointerException("no value for: " + key);
        }
        return BSON.toInt(o);
    }

    public int getInt(String key, int def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return BSON.toInt(foo);
    }

    public long getLong(String key) {
        Object foo = this.get(key);
        return ((Number)foo).longValue();
    }

    public double getDouble(String key) {
        Object foo = this.get(key);
        return ((Number)foo).doubleValue();
    }

    public String getString(String key) {
        Object foo = this.get(key);
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        if (foo instanceof Number) {
            return ((Number)foo).intValue() > 0;
        }
        if (foo instanceof Boolean) {
            return (Boolean)foo;
        }
        throw new IllegalArgumentException("can't coerce to bool:" + foo.getClass());
    }

    @Override
    public Object put(String key, Object val) {
        return super.put(key, val);
    }

    @Override
    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    public BasicBSONObject append(String key, Object val) {
        this.put(key, val);
        return this;
    }

    @Override
    public String toString() {
        return JSON.serialize(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BSONObject)) {
            return false;
        }
        BSONObject other = (BSONObject)o;
        if (!((Object)this.keySet()).equals(other.keySet())) {
            return false;
        }
        for (String key : this.keySet()) {
            Object a = this.get(key);
            Object b = other.get(key);
            if (a == null && b != null) {
                return false;
            }
            if (b == null) {
                if (a == null) continue;
                return false;
            }
            if (a instanceof Number && b instanceof Number) {
                if (((Number)a).doubleValue() == ((Number)b).doubleValue()) continue;
                return false;
            }
            if (a instanceof Pattern && b instanceof Pattern) {
                Pattern p1 = (Pattern)a;
                Pattern p2 = (Pattern)b;
                if (p1.pattern().equals(p2.pattern()) && p1.flags() == p2.flags()) continue;
                return false;
            }
            if (a.equals(b)) continue;
            return false;
        }
        return true;
    }
}

