/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.wrapper;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.ISClientConnector;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClient {
    private String clientID;
    private String typeAccess;
    private String memoryType;
    private String serviceClass;
    private String serviceName;
    private String owner;
    private String server;
    private String scopeString;
    private String currentScope;
    private String RRScope;
    private String backendType;
    private static final Logger logger = LoggerFactory.getLogger(StorageClient.class);
    private static final String DEFAULT_SERVICE_CLASS = "ExternalApplication";
    private static final String DEFAULT_SERVICE_NAME = "Default";
    private static final String DEFAULT_BACKEND_TYPE = "MongoDB";

    @Deprecated
    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope) {
        this.currentScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        this.typeAccess = accessType.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, boolean forceScope) {
        if (forceScope) {
            this.currentScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope);
            this.scopeString = ScopeProvider.instance.get();
        } else {
            this.RRScope = scope;
            this.scopeString = ScopeProvider.instance.get();
        }
        String id = owner;
        this.owner = owner;
        this.typeAccess = accessType.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType) {
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        this.typeAccess = accessType.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String owner, AccessType accessType, MemoryType memory) {
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        this.typeAccess = accessType.toString();
        this.memoryType = memory.toString();
        this.serviceClass = DEFAULT_SERVICE_CLASS;
        this.serviceName = DEFAULT_SERVICE_NAME;
        this.setClientId(this.serviceClass, this.serviceName, id);
    }

    @Deprecated
    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, String server) {
        this.currentScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        this.typeAccess = accessType.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, String server, AccessType accessType) {
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        this.typeAccess = accessType.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        this.setClientId(serviceClass, serviceName, id);
    }

    @Deprecated
    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, MemoryType memory) {
        this.currentScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        this.typeAccess = accessType.toString();
        this.memoryType = memory.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, MemoryType memory) {
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        this.typeAccess = accessType.toString();
        this.memoryType = memory.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.setClientId(serviceClass, serviceName, id);
    }

    @Deprecated
    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, String scope, String server, MemoryType memory) {
        this.currentScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        this.typeAccess = accessType.toString();
        this.memoryType = memory.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        this.setClientId(serviceClass, serviceName, id);
    }

    public StorageClient(String serviceClass, String serviceName, String owner, AccessType accessType, MemoryType memory, String server) {
        String id = owner;
        this.owner = owner;
        this.scopeString = ScopeProvider.instance.get();
        this.typeAccess = accessType.toString();
        this.memoryType = memory.toString();
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.server = server;
        this.setClientId(serviceClass, serviceName, id);
    }

    public IClient getClient() {
        String[] newServer = null;
        if (this.server == null) {
            logger.debug("server not set. Try to query IS in scope: " + this.scopeString);
            String[] serverFounded = this.checkVarEnvMongo();
            if (serverFounded == null) {
                ISClientConnector isclient = new ISClientConnector();
                serverFounded = isclient.getServer("RuntimeResource", this.RRScope);
                this.backendType = isclient.getBackendType(this.RRScope);
            } else {
                this.backendType = this.checkVarEnvBackendType();
                if (this.backendType == null) {
                    this.backendType = DEFAULT_BACKEND_TYPE;
                }
            }
            newServer = serverFounded;
        } else {
            String[] serverPassed;
            logger.debug("server founded: " + this.server);
            newServer = serverPassed = new String[]{this.server};
            if (this.backendType == null) {
                this.backendType = DEFAULT_BACKEND_TYPE;
            }
        }
        if (newServer == null) {
            throw new IllegalStateException("Resource not found on Information System");
        }
        String environment = this.scopeString.substring(this.scopeString.lastIndexOf("/"));
        if (this.memoryType != null && this.memoryType.toString().equalsIgnoreCase("VOLATILE")) {
            environment = "VOLATILE" + this.scopeString;
        }
        environment = environment + this.clientID;
        ServiceEngine engine = new ServiceEngine(newServer, environment, this.typeAccess, this.owner);
        engine.setServiceClass(this.serviceClass);
        engine.setServiceName(this.serviceName);
        engine.setGcubeAccessType(this.typeAccess.toLowerCase());
        engine.setBackendType(this.backendType);
        if (this.memoryType != null) {
            engine.setGcubeMemoryType(this.memoryType.toLowerCase());
        }
        engine.setGcubeScope(ScopeProvider.instance.get());
        engine.setOwnerGcube(this.owner);
        if (this.currentScope != null) {
            ScopeProvider.instance.set(this.currentScope);
        }
        return engine;
    }

    private void setClientId(String serviceClass, String serviceName, String id) {
        if (this.typeAccess.equalsIgnoreCase("public")) {
            this.clientID = "";
        } else if (this.typeAccess.equalsIgnoreCase("private")) {
            this.clientID = "/home/" + serviceClass + "/" + serviceName + "/" + id;
        } else if (this.typeAccess.equalsIgnoreCase("shared")) {
            this.clientID = "/home/" + serviceClass + "/" + serviceName;
        } else {
            throw new IllegalArgumentException("type is not correctly: public, private or shared");
        }
    }

    @Deprecated
    private String patchV1(String env) {
        String newEnvironment = env;
        if (this.typeAccess.equalsIgnoreCase("public")) {
            newEnvironment = env + "/" + "home" + "/" + "null" + "/";
        }
        return newEnvironment;
    }

    private String[] checkVarEnvMongo() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String server = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_MONGO_SERVER")) continue;
            server = env.get(key);
        }
        if (server != null) {
            String[] servers = new String[]{server};
            return servers;
        }
        return null;
    }

    private String checkVarEnvBackendType() {
        Map<String, String> env = System.getenv();
        TreeSet<String> keys = new TreeSet<String>(env.keySet());
        Iterator<String> iter = keys.iterator();
        String type = null;
        while (iter.hasNext()) {
            String key = iter.next();
            if (!key.equalsIgnoreCase("STORAGE_MANAGER_BACKEND_TYPE")) continue;
            type = env.get(key);
        }
        if (type != null) {
            return type;
        }
        return null;
    }
}

