/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.model.protocol.smp;

import java.net.URL;
import org.bson.types.ObjectId;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPConnection;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnectionById;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnectionOld;
import org.gcube.contentmanager.storageclient.protocol.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPURLConnectionFactory {
    static Logger logger = LoggerFactory.getLogger(SMPURLConnectionFactory.class);

    public static SMPConnection getSmp(URL url) {
        String urlString = url.toString();
        if (SMPURLConnectionFactory.isNewNewType(urlString)) {
            logger.info("detected new smp format " + url);
            return new SMPURLConnectionById(url);
        }
        logger.info("detected old smp format " + url);
        return new SMPURLConnectionOld(url);
    }

    private static boolean isNewType(String urlString) {
        String remoteIdentifier = SMPURLConnectionFactory.retrieveRemoteIdentifier(urlString);
        return ObjectId.isValid(remoteIdentifier);
    }

    private static boolean isNewNewType(String urlString) {
        String[] urlParam = urlString.split("/");
        String infraHost = urlParam[2];
        String infra = Utils.getInfraFromResolverHost(infraHost);
        String rootScope = "/" + infra;
        ScopeBean scope = new ScopeBean(rootScope);
        if (scope.is(ScopeBean.Type.INFRASTRUCTURE)) {
            return Utils.validationScope2(rootScope);
        }
        return false;
    }

    private static boolean isOldType(String urlString) {
        return false;
    }

    private static String retrieveRemoteIdentifier(String urlString) {
        String[] urlParam = urlString.split("\\?");
        return SMPURLConnectionFactory.extractLocation(urlParam[0]);
    }

    private static String extractLocation(String url) {
        String location = null;
        String[] loc = url.split("//");
        String[] params = loc[1].split("/");
        location = params[1];
        return location;
    }

    private static String extractInfrastructure(String url) {
        String rootScope = null;
        String[] loc = url.split("//");
        rootScope = loc[1];
        return rootScope;
    }
}

