/*
 * Decompiled with CFR 0.152.
 */
package flexjson;

import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonNumber
extends Number {
    private String input;

    public JsonNumber(String input) {
        this.input = input;
    }

    public int intValue() {
        return this.toInteger();
    }

    public long longValue() {
        return this.toLong();
    }

    public float floatValue() {
        return this.toFloat().floatValue();
    }

    public double doubleValue() {
        return this.toDouble();
    }

    public BigInteger toBigInteger() {
        if (this.isHex()) {
            return new BigInteger(this.input.substring(2), 16);
        }
        if (this.isOctal()) {
            return new BigInteger(this.input.substring(1), 8);
        }
        return new BigInteger(this.input);
    }

    public Double toDouble() {
        return Double.parseDouble(this.input);
    }

    public Short toShort() {
        if (this.isHex()) {
            return Short.parseShort(this.input.substring(2), 16);
        }
        if (this.isOctal()) {
            return Short.parseShort(this.input.substring(1), 8);
        }
        return Short.parseShort(this.input);
    }

    public Integer toInteger() {
        if (this.isHex()) {
            return Integer.parseInt(this.input.substring(2), 16);
        }
        if (this.isOctal()) {
            return Integer.parseInt(this.input.substring(1), 8);
        }
        return Integer.parseInt(this.input);
    }

    public Float toFloat() {
        return Float.valueOf(Float.parseFloat(this.input));
    }

    public Long toLong() {
        if (this.isHex()) {
            return Long.parseLong(this.input.substring(2), 16);
        }
        if (this.isOctal()) {
            return Long.parseLong(this.input.substring(1), 8);
        }
        return Long.parseLong(this.input);
    }

    public Byte toByte() {
        if (this.isHex()) {
            return Byte.parseByte(this.input.substring(2), 16);
        }
        if (this.isOctal()) {
            return Byte.parseByte(this.input.substring(1), 8);
        }
        return Byte.parseByte(this.input);
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.input);
    }

    private boolean isHex() {
        return this.input.startsWith("0x");
    }

    private boolean isOctal() {
        return this.input.length() > 1 && this.input.charAt(0) == '0' && Character.isDigit(this.input.charAt(1));
    }

    public boolean isDecimal() {
        return this.input.contains(".");
    }
}

