/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public abstract class CompoundExpression
extends Expression {
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;
    protected Expression firstChild;
    protected Expression secondChild;
    protected ExpressionBuilder builder;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CompoundExpression expression = (CompoundExpression)object;
        return (this.operator == expression.operator || this.operator != null && this.operator.equals(expression.operator)) && (this.firstChild == expression.firstChild || this.firstChild != null && this.firstChild.equals(expression.firstChild)) && (this.secondChild == expression.secondChild || this.secondChild != null && this.secondChild.equals(expression.secondChild));
    }

    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.operator != null) {
            hashCode += this.operator.hashCode();
        }
        if (this.firstChild != null) {
            hashCode += this.firstChild.hashCode();
        }
        if (this.secondChild != null) {
            hashCode += this.secondChild.hashCode();
        }
        return hashCode;
    }

    public DatabaseTable aliasForTable(DatabaseTable table) {
        DatabaseTable alias = null;
        if (this.firstChild != null) {
            alias = this.firstChild.aliasForTable(table);
        }
        if (alias == null && this.secondChild != null) {
            alias = this.secondChild.aliasForTable(table);
        }
        return alias;
    }

    public Expression asOf(AsOfClause clause) {
        final AsOfClause finalClause = clause;
        ExpressionIterator iterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                if (each.isDataExpression()) {
                    each.asOf(finalClause);
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        iterator.iterateOn(this);
        return this;
    }

    public Expression create(Expression base, Object singleArgument, ExpressionOperator operator) {
        this.setFirstChild(base);
        Expression argument = Expression.from(singleArgument, base);
        this.setSecondChild(argument);
        this.setOperator(operator);
        return this;
    }

    public Expression create(Expression base, Vector arguments, ExpressionOperator operator) {
        this.setFirstChild(base);
        if (!arguments.isEmpty()) {
            this.setSecondChild((Expression)arguments.firstElement());
        }
        this.setOperator(operator);
        return this;
    }

    public String descriptionOfNodeType() {
        return "Compound Expression";
    }

    public ExpressionBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = this.firstChild.getBuilder();
            if (this.builder == null) {
                this.builder = this.secondChild.getBuilder();
            }
        }
        return this.builder;
    }

    public Expression getFirstChild() {
        return this.firstChild;
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform platform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(platform);
        }
        return this.platformOperator;
    }

    public Expression getSecondChild() {
        return this.secondChild;
    }

    public void initializePlatformOperator(DatabasePlatform platform) {
        if (this.operator.isComplete()) {
            this.platformOperator = this.operator;
            return;
        }
        this.platformOperator = platform.getOperator(this.operator.getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.operator.toString());
        }
    }

    public boolean isCompoundExpression() {
        return true;
    }

    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        if (this.firstChild != null) {
            this.firstChild.iterateOn(iterator);
        }
        if (this.secondChild != null) {
            this.secondChild.iterateOn(iterator);
        }
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        ExpressionBuilder builder;
        this.validateNode();
        if (this.firstChild != null) {
            builder = this.firstChild.getBuilder();
            if (builder != null) {
                builder.setSession(normalizer.getSession().getRootSession(null));
            }
            this.setFirstChild(this.firstChild.normalize(normalizer));
        }
        if (this.secondChild != null) {
            builder = this.secondChild.getBuilder();
            if (builder != null) {
                builder.setSession(normalizer.getSession().getRootSession(null));
            }
            this.setSecondChild(this.secondChild.normalize(normalizer));
        }
        if (this.firstChild == null) {
            return this.secondChild;
        }
        if (this.secondChild == null) {
            return this.firstChild;
        }
        return this;
    }

    public void validateNode() {
        if (this.firstChild != null && (this.firstChild.isDataExpression() || this.firstChild.isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
        if (this.secondChild != null && (this.secondChild.isDataExpression() || this.secondChild.isConstantExpression())) {
            throw QueryException.invalidExpression(this);
        }
    }

    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.firstChild != null) {
            this.setFirstChild(this.firstChild.copiedVersionFrom(alreadyDone));
        }
        if (this.secondChild != null) {
            this.setSecondChild(this.secondChild.copiedVersionFrom(alreadyDone));
        }
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        printer.printString("(");
        realOperator.printDuo(this.firstChild, this.secondChild, printer);
        printer.printString(")");
    }

    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printJavaDuo(this.firstChild, this.secondChild, printer);
    }

    public Expression rebuildOn(Expression newBase) {
        NonSynchronizedVector arguments;
        Expression first = this.firstChild.rebuildOn(newBase);
        if (this.secondChild == null) {
            arguments = NonSynchronizedVector.newInstance(0);
        } else {
            arguments = NonSynchronizedVector.newInstance(1);
            ((Vector)arguments).add(this.secondChild.rebuildOn(newBase));
        }
        return first.performOperator(this.operator, arguments);
    }

    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
        this.firstChild.resetPlaceHolderBuilder(queryBuilder);
        if (this.secondChild != null) {
            this.secondChild.resetPlaceHolderBuilder(queryBuilder);
        }
    }

    protected void setFirstChild(Expression firstChild) {
        this.firstChild = firstChild;
        this.builder = null;
    }

    public void setOperator(ExpressionOperator newOperator) {
        this.operator = newOperator;
    }

    protected void setSecondChild(Expression secondChild) {
        this.secondChild = secondChild;
        this.builder = null;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        NonSynchronizedVector arguments;
        if (this.secondChild == null) {
            arguments = NonSynchronizedVector.newInstance(0);
        } else {
            arguments = NonSynchronizedVector.newInstance(1);
            ((Vector)arguments).addElement(this.secondChild.twistedForBaseAndContext(newBase, context));
        }
        Expression first = this.firstChild.twistedForBaseAndContext(newBase, context);
        return first.performOperator(this.operator, arguments);
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.operator.toString());
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.firstChild != null) {
            this.firstChild.toString(writer, indent);
        }
        if (this.secondChild != null) {
            this.secondChild.toString(writer, indent);
        }
    }

    public Expression shallowClone() {
        CompoundExpression clone = (CompoundExpression)super.shallowClone();
        clone.builder = null;
        return clone;
    }
}

