/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.GroupByNode;
import org.eclipse.persistence.internal.jpa.parsing.MajorNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class HavingNode
extends MajorNode {
    private Node having = null;

    public void validate(ParseTreeContext context, GroupByNode groupbyNode) {
        if (this.having != null) {
            this.having.validate(context);
            if (groupbyNode != null && !groupbyNode.isValidHavingExpr(this.having)) {
                throw JPQLException.invalidHavingExpression(context.getQueryInfo(), this.having.getLine(), this.having.getColumn(), this.having.getAsString(), groupbyNode.getAsString());
            }
        }
    }

    public void addHavingToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            Expression havingExpression = this.getHaving().generateExpression(context);
            ((ReportQuery)theQuery).setHavingExpression(havingExpression);
        }
    }

    public Node getHaving() {
        return this.having;
    }

    public void setHaving(Node having) {
        this.having = having;
    }
}

