/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.BinaryOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;

public class MemberOfNode
extends BinaryOperatorNode {
    private boolean notIndicated = false;
    private Expression leftExpression = null;

    public void makeNodeOneToMany(Node theNode) {
        Node currentNode = theNode;
        while (true) {
            if (!currentNode.hasRight()) {
                ((AttributeNode)currentNode).setRequiresCollectionAttribute(true);
                return;
            }
            currentNode = currentNode.getRight();
        }
    }

    public void validate(ParseTreeContext context) {
        super.validate(context);
        Node left = this.getLeft();
        if (left.isVariableNode() && ((VariableNode)left).isAlias(context)) {
            context.usedVariable(((VariableNode)left).getCanonicalVariableName());
        }
        left.validateParameter(context, this.right.getType());
        TypeHelper typeHelper = context.getTypeHelper();
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext context) {
        if (this.getRight().isParameterNode()) {
            this.makeNodeOneToMany(this.getLeft());
        } else {
            this.makeNodeOneToMany(this.getRight());
        }
        if (this.notIndicated()) {
            Expression resultFromRight = null;
            context.setMemberOfNode(this);
            this.setLeftExpression(this.getLeft().generateExpression(context));
            resultFromRight = this.getRight().generateExpression(context);
            context.setMemberOfNode(null);
            this.setLeftExpression(null);
            return resultFromRight;
        }
        return this.getRight().generateExpression(context).equal(this.getLeft().generateExpression(context));
    }

    public void indicateNot() {
        this.notIndicated = true;
    }

    public boolean notIndicated() {
        return this.notIndicated;
    }

    public void setLeftExpression(Expression newLeftExpression) {
        this.leftExpression = newLeftExpression;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }
}

