/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.parsing.EqualsAssignmentNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.MajorNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.queries.UpdateAllQuery;

public class SetNode
extends MajorNode {
    private List assignmentNodes = new Vector();

    public void addUpdatesToQuery(UpdateAllQuery theQuery, GenerationContext context) {
        for (EqualsAssignmentNode node : this.assignmentNodes) {
            Expression leftExpression = this.getExpressionForNode(node.getLeft(), theQuery.getReferenceClass(), context);
            Expression rightExpression = this.getExpressionForNode(node.getRight(), theQuery.getReferenceClass(), context);
            theQuery.addUpdate(leftExpression, rightExpression);
        }
    }

    public Node qualifyAttributeAccess(ParseTreeContext context) {
        for (Node item : this.assignmentNodes) {
            item.qualifyAttributeAccess(context);
        }
        return this;
    }

    public void validate(ParseTreeContext context) {
        for (Node item : this.assignmentNodes) {
            item.validate(context);
        }
    }

    protected Expression getExpressionForNode(Node node, Class referenceClass, GenerationContext context) {
        Expression expression = null;
        if (node.isAttributeNode()) {
            String classVariable = context.getParseTreeContext().getVariableNameForClass(referenceClass, context);
            expression = context.expressionFor(classVariable);
            if (expression == null) {
                expression = new ExpressionBuilder();
                context.addExpression(expression, classVariable);
            }
            expression = node.addToExpression(expression, context);
        } else {
            expression = node.generateExpression(context);
        }
        return expression;
    }

    public void setAssignmentNodes(List nodes) {
        this.assignmentNodes = nodes;
    }
}

