/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import java.util.HashMap;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.CodeAdapter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.Type;

public class CheckCodeAdapter
extends CodeAdapter {
    private boolean end;
    private HashMap labels = new HashMap();
    private static final int[] TYPE;

    static {
        int[] nArray = new int[202];
        nArray[16] = 1;
        nArray[17] = 1;
        nArray[18] = 7;
        nArray[19] = -1;
        nArray[20] = -1;
        nArray[21] = 2;
        nArray[22] = 2;
        nArray[23] = 2;
        nArray[24] = 2;
        nArray[25] = 2;
        nArray[26] = -1;
        nArray[27] = -1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[30] = -1;
        nArray[31] = -1;
        nArray[32] = -1;
        nArray[33] = -1;
        nArray[34] = -1;
        nArray[35] = -1;
        nArray[36] = -1;
        nArray[37] = -1;
        nArray[38] = -1;
        nArray[39] = -1;
        nArray[40] = -1;
        nArray[41] = -1;
        nArray[42] = -1;
        nArray[43] = -1;
        nArray[44] = -1;
        nArray[45] = -1;
        nArray[54] = 2;
        nArray[55] = 2;
        nArray[56] = 2;
        nArray[57] = 2;
        nArray[58] = 2;
        nArray[59] = -1;
        nArray[60] = -1;
        nArray[61] = -1;
        nArray[62] = -1;
        nArray[63] = -1;
        nArray[64] = -1;
        nArray[65] = -1;
        nArray[66] = -1;
        nArray[67] = -1;
        nArray[68] = -1;
        nArray[69] = -1;
        nArray[70] = -1;
        nArray[71] = -1;
        nArray[72] = -1;
        nArray[73] = -1;
        nArray[74] = -1;
        nArray[75] = -1;
        nArray[76] = -1;
        nArray[77] = -1;
        nArray[78] = -1;
        nArray[132] = 8;
        nArray[153] = 6;
        nArray[154] = 6;
        nArray[155] = 6;
        nArray[156] = 6;
        nArray[157] = 6;
        nArray[158] = 6;
        nArray[159] = 6;
        nArray[160] = 6;
        nArray[161] = 6;
        nArray[162] = 6;
        nArray[163] = 6;
        nArray[164] = 6;
        nArray[165] = 6;
        nArray[166] = 6;
        nArray[167] = 6;
        nArray[168] = 6;
        nArray[169] = 2;
        nArray[170] = 9;
        nArray[171] = 10;
        nArray[178] = 4;
        nArray[179] = 4;
        nArray[180] = 4;
        nArray[181] = 4;
        nArray[182] = 5;
        nArray[183] = 5;
        nArray[184] = 5;
        nArray[185] = 5;
        nArray[186] = -1;
        nArray[187] = 3;
        nArray[188] = 1;
        nArray[189] = 3;
        nArray[192] = 3;
        nArray[193] = 3;
        nArray[196] = -1;
        nArray[197] = 11;
        nArray[198] = 6;
        nArray[199] = 6;
        nArray[200] = -1;
        nArray[201] = -1;
        TYPE = nArray;
    }

    public CheckCodeAdapter(CodeVisitor cv) {
        super(cv);
    }

    public void visitInsn(int opcode) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 0);
        this.cv.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 1);
        switch (opcode) {
            case 16: {
                CheckCodeAdapter.checkSignedByte(operand, "Invalid operand");
                break;
            }
            case 17: {
                CheckCodeAdapter.checkSignedShort(operand, "Invalid operand");
                break;
            }
            default: {
                if (operand >= 4 && operand <= 11) break;
                throw new IllegalArgumentException("Invalid operand (must be an array type code T_...): " + operand);
            }
        }
        this.cv.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 2);
        CheckCodeAdapter.checkUnsignedShort(var, "Invalid variable index");
        this.cv.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 3);
        if (desc != null && desc.length() > 0 && desc.charAt(0) == '[') {
            CheckCodeAdapter.checkDesc(desc, false);
        } else {
            CheckCodeAdapter.checkInternalName(desc, "type");
        }
        if (opcode == 187 && desc.charAt(0) == '[') {
            throw new IllegalArgumentException("NEW cannot be used to create arrays: " + desc);
        }
        this.cv.visitTypeInsn(opcode, desc);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 4);
        CheckCodeAdapter.checkInternalName(owner, "owner");
        CheckCodeAdapter.checkIdentifier(name, "name");
        CheckCodeAdapter.checkDesc(desc, false);
        this.cv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 5);
        CheckCodeAdapter.checkInternalName(owner, "owner");
        CheckCodeAdapter.checkMethodIdentifier(name, "name");
        CheckCodeAdapter.checkMethodDesc(desc);
        this.cv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.checkEnd();
        CheckCodeAdapter.checkOpcode(opcode, 6);
        this.checkLabel(label, false, "label");
        this.cv.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.checkEnd();
        this.checkLabel(label, false, "label");
        if (this.labels.get(label) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labels.put(label, new Integer(this.labels.size()));
        this.cv.visitLabel(label);
    }

    public void visitLdcInsn(Object cst) {
        this.checkEnd();
        if (!(cst instanceof Type)) {
            CheckCodeAdapter.checkConstant(cst);
        }
        this.cv.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.checkEnd();
        CheckCodeAdapter.checkUnsignedShort(var, "Invalid variable index");
        CheckCodeAdapter.checkSignedShort(increment, "Invalid increment");
        this.cv.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.checkEnd();
        if (max < min) {
            throw new IllegalArgumentException("Max = " + max + " must be greater than or equal to min = " + min);
        }
        this.checkLabel(dflt, false, "default label");
        if (labels == null || labels.length != max - min + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        int i = 0;
        while (i < labels.length) {
            this.checkLabel(labels[i], false, "label at index " + i);
            ++i;
        }
        this.cv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.checkEnd();
        this.checkLabel(dflt, false, "default label");
        if (keys == null || labels == null || keys.length != labels.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        int i = 0;
        while (i < labels.length) {
            this.checkLabel(labels[i], false, "label at index " + i);
            ++i;
        }
        this.cv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.checkEnd();
        CheckCodeAdapter.checkDesc(desc, false);
        if (desc.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid descriptor (must be an array type descriptor): " + desc);
        }
        if (dims < 1) {
            throw new IllegalArgumentException("Invalid dimensions (must be greater than 0): " + dims);
        }
        if (dims > desc.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException("Invalid dimensions (must not be greater than dims(desc)): " + dims);
        }
        this.cv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.checkLabel(start, true, "start label");
        this.checkLabel(end, true, "end label");
        this.checkLabel(handler, true, "handler label");
        if (type != null) {
            CheckCodeAdapter.checkInternalName(type, "type");
        }
        int s = (Integer)this.labels.get(start);
        int e = (Integer)this.labels.get(end);
        if (e <= s) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        this.cv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.checkEnd();
        this.end = true;
        CheckCodeAdapter.checkUnsignedShort(maxStack, "Invalid max stack");
        CheckCodeAdapter.checkUnsignedShort(maxLocals, "Invalid max locals");
        this.cv.visitMaxs(maxStack, maxLocals);
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        CheckCodeAdapter.checkIdentifier(name, "name");
        CheckCodeAdapter.checkDesc(desc, false);
        this.checkLabel(start, true, "start label");
        this.checkLabel(end, true, "end label");
        CheckCodeAdapter.checkUnsignedShort(index, "Invalid variable index");
        int s = (Integer)this.labels.get(start);
        int e = (Integer)this.labels.get(end);
        if (e <= s) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        this.cv.visitLocalVariable(name, desc, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        CheckCodeAdapter.checkUnsignedShort(line, "Invalid line number");
        this.checkLabel(start, true, "start label");
        this.cv.visitLineNumber(line, start);
    }

    public void visitAttribute(Attribute attr) {
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
    }

    void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    static void checkOpcode(int opcode, int type) {
        if (opcode < 0 || opcode > 199 || TYPE[opcode] != type) {
            throw new IllegalArgumentException("Invalid opcode: " + opcode);
        }
    }

    static void checkSignedByte(int value, String msg) {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException(String.valueOf(msg) + " (must be a signed byte): " + value);
        }
    }

    static void checkSignedShort(int value, String msg) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException(String.valueOf(msg) + " (must be a signed short): " + value);
        }
    }

    static void checkUnsignedShort(int value, String msg) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException(String.valueOf(msg) + " (must be an unsigned short): " + value);
        }
    }

    static void checkConstant(Object cst) {
        if (!(cst instanceof Integer || cst instanceof Float || cst instanceof Long || cst instanceof Double || cst instanceof String)) {
            throw new IllegalArgumentException("Invalid constant: " + cst);
        }
    }

    static void checkIdentifier(String name, String msg) {
        CheckCodeAdapter.checkIdentifier(name, 0, -1, msg);
    }

    static void checkIdentifier(String name, int start, int end, String msg) {
        if (name == null || (end == -1 ? name.length() <= start : end <= start)) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        if (!Character.isJavaIdentifierStart(name.charAt(start))) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a valid Java identifier): " + name);
        }
        int max = end == -1 ? name.length() : end;
        int i = start + 1;
        while (i < max) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                throw new IllegalArgumentException("Invalid " + msg + " (must be a valid Java identifier): " + name);
            }
            ++i;
        }
    }

    static void checkMethodIdentifier(String name, String msg) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        if (name.equals("<init>") || name.equals("<clinit>")) {
            return;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + name);
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                throw new IllegalArgumentException("Invalid " + msg + " (must be '<init>' or '<clinit>' or a valid Java identifier): " + name);
            }
            ++i;
        }
    }

    static void checkInternalName(String name, String msg) {
        CheckCodeAdapter.checkInternalName(name, 0, -1, msg);
    }

    static void checkInternalName(String name, int start, int end, String msg) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        int max = end == -1 ? name.length() : end;
        try {
            int slash;
            int begin = start;
            do {
                if ((slash = name.indexOf(47, begin + 1)) == -1 || slash > max) {
                    slash = max;
                }
                CheckCodeAdapter.checkIdentifier(name, begin, slash, null);
                begin = slash + 1;
            } while (slash != max);
        }
        catch (IllegalArgumentException _) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a fully qualified class name in internal form): " + name);
        }
    }

    static void checkDesc(String desc, boolean canBeVoid) {
        int end = CheckCodeAdapter.checkDesc(desc, 0, canBeVoid);
        if (end != desc.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
    }

    static int checkDesc(String desc, int start, boolean canBeVoid) {
        if (desc == null || start >= desc.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (desc.charAt(start)) {
            case 'V': {
                if (canBeVoid) {
                    return start + 1;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return start + 1;
            }
            case '[': {
                int index = start + 1;
                while (index < desc.length() && desc.charAt(index) == '[') {
                    ++index;
                }
                if (index < desc.length()) {
                    return CheckCodeAdapter.checkDesc(desc, index, false);
                }
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            }
            case 'L': {
                int index = desc.indexOf(59, start);
                if (index == -1 || index - start < 2) {
                    throw new IllegalArgumentException("Invalid descriptor: " + desc);
                }
                try {
                    CheckCodeAdapter.checkInternalName(desc, start + 1, index, null);
                }
                catch (IllegalArgumentException _) {
                    throw new IllegalArgumentException("Invalid descriptor: " + desc);
                }
                return index + 1;
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + desc);
    }

    static void checkMethodDesc(String desc) {
        if (desc == null || desc.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (desc.charAt(0) != '(' || desc.length() < 3) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
        int start = 1;
        if (desc.charAt(start) != ')') {
            do {
                if (desc.charAt(start) != 'V') continue;
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            } while ((start = CheckCodeAdapter.checkDesc(desc, start, false)) < desc.length() && desc.charAt(start) != ')');
        }
        if ((start = CheckCodeAdapter.checkDesc(desc, start + 1, true)) != desc.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
    }

    void checkLabel(Label label, boolean checkVisited, String msg) {
        if (label == null) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null)");
        }
        if (checkVisited && this.labels.get(label) == null) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be visited first)");
        }
    }
}

