/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.AbstractIdentityMap;
import org.eclipse.persistence.internal.oxm.QNameInheritancePolicy;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDescriptor
extends ClassDescriptor {
    private NamespaceResolver namespaceResolver;
    private XMLSchemaReference schemaReference;
    private boolean shouldPreserveDocument = false;
    private XMLField defaultRootElementField;
    private boolean sequencedObject = false;
    private boolean isWrapper = false;
    private boolean resultAlwaysXMLRoot = false;

    public XMLDescriptor() {
        this.tables = NonSynchronizedVector.newInstance(3);
        this.mappings = NonSynchronizedVector.newInstance();
        this.primaryKeyFields = new ArrayList(2);
        this.fields = NonSynchronizedVector.newInstance();
        this.allFields = NonSynchronizedVector.newInstance();
        this.constraintDependencies = NonSynchronizedVector.newInstance(2);
        this.multipleTableForeignKeys = new HashMap(5);
        this.queryKeys = new HashMap(5);
        this.initializationStage = 0;
        this.interfaceInitializationStage = 0;
        this.shouldAlwaysRefreshCache = false;
        this.shouldOnlyRefreshCacheIfNewerVersion = false;
        this.shouldDisableCacheHits = false;
        this.identityMapSize = 100;
        this.remoteIdentityMapSize = -1;
        this.identityMapClass = AbstractIdentityMap.getDefaultIdentityMapClass();
        this.remoteIdentityMapClass = null;
        this.descriptorType = 0;
        this.shouldAlwaysRefreshCacheOnRemote = false;
        this.shouldDisableCacheHitsOnRemote = false;
        this.shouldOrderMappings = true;
        this.shouldBeReadOnly = false;
        this.shouldAlwaysConformResultsInUnitOfWork = false;
        this.shouldAcquireCascadedLocks = false;
        this.hasSimplePrimaryKey = false;
        this.isIsolated = false;
        this.objectBuilder = new TreeObjectBuilder(this);
        this.cascadeLockingPolicies = NonSynchronizedVector.newInstance();
        this.shouldOrderMappings = false;
        this.descriptorIsAggregate();
    }

    public String getDefaultRootElement() {
        if (this.getTables().isEmpty()) {
            return null;
        }
        return this.getTables().firstElement().getName();
    }

    public boolean shouldPreserveDocument() {
        return this.shouldPreserveDocument;
    }

    public void setShouldPreserveDocument(boolean shouldPreserveDocument) {
        this.shouldPreserveDocument = shouldPreserveDocument;
    }

    public void addRootElement(String rootElementName) {
        if (rootElementName != null && !this.getTableNames().contains(rootElementName)) {
            this.addTableName(rootElementName);
        }
    }

    public void setDefaultRootElement(String newDefaultRootElement) {
        if (this.setDefaultRootElementField(newDefaultRootElement)) {
            int index = this.getTableNames().indexOf(newDefaultRootElement);
            if (index == 0) {
                return;
            }
            if (index >= 0) {
                this.getTables().remove(index);
                this.getTables().add(0, new DatabaseTable(newDefaultRootElement));
            } else {
                this.getTables().add(0, new DatabaseTable(newDefaultRootElement));
            }
        }
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public NamespaceResolver getNonNullNamespaceResolver() {
        if (this.namespaceResolver == null) {
            this.namespaceResolver = new NamespaceResolver();
        }
        return this.namespaceResolver;
    }

    @Override
    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            this.setInheritancePolicy(new QNameInheritancePolicy(this));
        }
        return this.inheritancePolicy;
    }

    public void setNamespaceResolver(NamespaceResolver newNamespaceResolver) {
        this.namespaceResolver = newNamespaceResolver;
    }

    public XMLSchemaReference getSchemaReference() {
        return this.schemaReference;
    }

    public void setSchemaReference(XMLSchemaReference newSchemaReference) {
        this.schemaReference = newSchemaReference;
    }

    @Override
    protected void validateMappingType(DatabaseMapping mapping) {
        if (!mapping.isXMLMapping()) {
            throw DescriptorException.invalidMappingType(mapping);
        }
    }

    @Override
    public AbstractRecord buildNestedRowFromFieldValue(Object fieldValue) {
        if (fieldValue instanceof XMLRecord) {
            return (XMLRecord)fieldValue;
        }
        if (!(fieldValue instanceof Vector)) {
            return this.getObjectBuilder().createRecord(null);
        }
        Vector nestedRows = (Vector)fieldValue;
        if (nestedRows.isEmpty()) {
            return this.getObjectBuilder().createRecord(null);
        }
        if (!(nestedRows.firstElement() instanceof AbstractRecord)) {
            return this.getObjectBuilder().createRecord(null);
        }
        return (XMLRecord)nestedRows.firstElement();
    }

    @Override
    public Vector buildNestedRowsFromFieldValue(Object fieldValue, AbstractSession session) {
        if (!(fieldValue instanceof Vector)) {
            return new Vector(0);
        }
        return (Vector)fieldValue;
    }

    @Override
    public DatabaseMapping addDirectMapping(String attributeName, String xpathString) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setAttributeName(attributeName);
        mapping.setXPath(xpathString);
        return this.addMapping(mapping);
    }

    @Override
    public DatabaseMapping addDirectMapping(String attributeName, String getMethodName, String setMethodName, String xpathString) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setAttributeName(attributeName);
        mapping.setSetMethodName(setMethodName);
        mapping.setGetMethodName(getMethodName);
        mapping.setXPath(xpathString);
        return this.addMapping(mapping);
    }

    @Override
    public void addPrimaryKeyFieldName(String fieldName) {
        super.addPrimaryKeyField(new XMLField(fieldName));
    }

    @Override
    public void addPrimaryKeyField(DatabaseField field) {
        if (!(field instanceof XMLField)) {
            String fieldName = field.getName();
            field = new XMLField(fieldName);
        }
        super.addPrimaryKeyField(field);
    }

    @Override
    public void setPrimaryKeyFields(List<DatabaseField> thePrimaryKeyFields) {
        ArrayList<DatabaseField> xmlFields = new ArrayList<DatabaseField>(thePrimaryKeyFields.size());
        for (DatabaseField field : thePrimaryKeyFields) {
            if (!(field instanceof XMLField)) {
                String fieldName = field.getName();
                field = new XMLField(fieldName);
            }
            xmlFields.add(field);
        }
        super.setPrimaryKeyFields(xmlFields);
    }

    @Override
    public Vector buildDirectValuesFromFieldValue(Object fieldValue) throws DatabaseException {
        if (!(fieldValue instanceof Vector)) {
            Vector<Object> fieldValues = new Vector<Object>(1);
            fieldValues.add(fieldValue);
            return fieldValues;
        }
        return (Vector)fieldValue;
    }

    @Override
    public Object buildFieldValueFromDirectValues(Vector directValues, String elementDataTypeName, AbstractSession session) throws DatabaseException {
        return directValues;
    }

    @Override
    public Object buildFieldValueFromNestedRows(Vector nestedRows, String structureName, AbstractSession session) throws DatabaseException {
        return nestedRows;
    }

    @Override
    public DatabaseField buildField(String fieldName) {
        XMLField xmlField = new XMLField(fieldName);
        xmlField.setNamespaceResolver(this.getNamespaceResolver());
        return xmlField;
    }

    @Override
    public DatabaseField buildField(DatabaseField field) {
        try {
            XMLField xmlField = (XMLField)field;
            xmlField.setNamespaceResolver(this.getNamespaceResolver());
            xmlField.initialize();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return super.buildField(field);
    }

    @Override
    public void initializeAggregateInheritancePolicy(AbstractSession session) {
    }

    @Override
    public void setTableNames(Vector tableNames) {
        if (null != tableNames && tableNames.size() > 0) {
            this.setDefaultRootElementField((String)tableNames.get(0));
        }
        super.setTableNames(tableNames);
    }

    @Override
    public void setTables(Vector<DatabaseTable> theTables) {
        if (null != theTables && theTables.size() > 0) {
            this.setDefaultRootElementField(theTables.get(0).getName());
        }
        super.setTables(theTables);
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        if (this.isInitialized(1)) {
            return;
        }
        this.setInitializationStage(1);
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            try {
                DatabaseMapping mapping = mappingsEnum.nextElement();
                mapping.preInitialize(session);
            }
            catch (DescriptorException exception) {
                session.getIntegrityChecker().handleError(exception);
            }
        }
        this.validateBeforeInitialization(session);
        this.preInitializeInheritancePolicy(session);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().preInitialize(session);
        } else {
            this.setInternalDefaultTable();
        }
        this.verifyTableQualifiers(session.getDatasourcePlatform());
        this.initializeProperties(session);
        if (this.hasInterfacePolicy()) {
            this.preInterfaceInitialization(session);
        }
    }

    @Override
    public void postInitialize(AbstractSession session) throws DescriptorException {
        int index;
        if (this.isInitialized(3) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(3);
        if (this.hasInheritance()) {
            Enumeration childEnum = this.getInheritancePolicy().getChildDescriptors().elements();
            while (childEnum.hasMoreElements()) {
                ((ClassDescriptor)childEnum.nextElement()).postInitialize(session);
            }
        }
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsEnum.nextElement();
            mapping.postInitialize(session);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().postInitialize(session);
        }
        for (index = this.getPrimaryKeyFields().size() - 1; index >= 0; --index) {
            DatabaseField primaryKeyField = this.getPrimaryKeyFields().get(index);
            int fieldIndex = this.getFields().indexOf(primaryKeyField);
            if (fieldIndex == -1) continue;
            primaryKeyField = this.getFields().get(fieldIndex);
            this.getPrimaryKeyFields().set(index, primaryKeyField);
        }
        for (index = 0; index < this.getFields().size(); ++index) {
            DatabaseMapping mapping;
            DatabaseField field = this.getFields().elementAt(index);
            if (field.getType() == null && (mapping = this.getObjectBuilder().getMappingForField(field)) != null) {
                field.setType(mapping.getFieldClassification(field));
            }
            field.setIndex(index);
        }
        this.validateAfterInitialization(session);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.hasInheritance()) {
            ((QNameInheritancePolicy)this.getInheritancePolicy()).setNamespaceResolver(this.getNamespaceResolver());
        }
        if (null != this.defaultRootElementField) {
            this.defaultRootElementField.setNamespaceResolver(this.namespaceResolver);
            this.defaultRootElementField.initialize();
        }
        int primaryKeyFieldsSize = this.primaryKeyFields.size();
        for (int x = 0; x < primaryKeyFieldsSize; ++x) {
            XMLField pkField = (XMLField)this.primaryKeyFields.get(x);
            pkField.setNamespaceResolver(this.namespaceResolver);
            pkField.initialize();
        }
        if (this.shouldBeReadOnly() && !session.getDefaultReadOnlyClasses().contains(this.getJavaClass())) {
            session.getDefaultReadOnlyClasses().add(this.getJavaClass());
        }
        if (this.isInitialized(2) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(2);
        if (this.isChildDescriptor()) {
            this.getInheritancePolicy().getParentDescriptor().initialize(session);
        }
        Enumeration<DatabaseMapping> mappingsEnum = this.getMappings().elements();
        while (mappingsEnum.hasMoreElements()) {
            DatabaseMapping mapping = mappingsEnum.nextElement();
            this.validateMappingType(mapping);
            mapping.initialize(session);
            Helper.addAllUniqueToVector(this.getFields(), mapping.getFields());
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().initialize(session);
        }
        this.setAllFields((Vector)this.getFields().clone());
        this.getObjectBuilder().initialize(session);
        if (this.hasInterfacePolicy()) {
            this.interfaceInitialization(session);
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().initialize(session);
        }
        this.getEventManager().initialize(session);
        this.getCopyPolicy().initialize(session);
        this.getInstantiationPolicy().initialize(session);
        if (this.getSchemaReference() != null) {
            this.getSchemaReference().initialize(session);
        }
    }

    @Override
    public boolean requiresInitialization() {
        return !this.isDescriptorForInterface();
    }

    @Override
    protected DatabaseTable extractDefaultTable() {
        return new DatabaseTable();
    }

    public Object wrapObjectInXMLRoot(UnmarshalRecord unmarshalRecord, boolean forceWrap) {
        String elementName = unmarshalRecord.getRootElementName();
        int colonIndex = elementName.indexOf(58);
        String elementLocalName = elementName;
        String elementPrefix = null;
        if (colonIndex != -1) {
            elementLocalName = elementName.substring(colonIndex + 1);
            elementPrefix = elementName.substring(0, colonIndex);
        }
        String elementNamespaceUri = unmarshalRecord.getRootElementNamespaceUri();
        if (forceWrap || this.shouldWrapObject(unmarshalRecord.getCurrentObject(), elementNamespaceUri, elementLocalName, elementPrefix)) {
            XMLRoot xmlRoot = new XMLRoot();
            xmlRoot.setLocalName(elementLocalName);
            xmlRoot.setNamespaceURI(elementNamespaceUri);
            xmlRoot.setObject(unmarshalRecord.getCurrentObject());
            xmlRoot.setEncoding(unmarshalRecord.getEncoding());
            xmlRoot.setVersion(unmarshalRecord.getVersion());
            xmlRoot.setSchemaLocation(unmarshalRecord.getSchemaLocation());
            xmlRoot.setNoNamespaceSchemaLocation(unmarshalRecord.getNoNamespaceSchemaLocation());
            return xmlRoot;
        }
        return unmarshalRecord.getCurrentObject();
    }

    public Object wrapObjectInXMLRoot(Object object, String elementNamespaceUri, String elementLocalName, String elementPrefix, boolean forceWrap) {
        if (forceWrap || this.shouldWrapObject(object, elementNamespaceUri, elementLocalName, elementPrefix)) {
            XMLRoot xmlRoot = new XMLRoot();
            xmlRoot.setLocalName(elementLocalName);
            xmlRoot.setNamespaceURI(elementNamespaceUri);
            xmlRoot.setObject(object);
            return xmlRoot;
        }
        return object;
    }

    public Object wrapObjectInXMLRoot(Object object, String elementNamespaceUri, String elementLocalName, String elementPrefix, String encoding, String version, boolean forceWrap) {
        if (forceWrap || this.shouldWrapObject(object, elementNamespaceUri, elementLocalName, elementPrefix)) {
            XMLRoot xmlRoot = new XMLRoot();
            xmlRoot.setLocalName(elementLocalName);
            xmlRoot.setNamespaceURI(elementNamespaceUri);
            xmlRoot.setObject(object);
            xmlRoot.setEncoding(encoding);
            xmlRoot.setVersion(version);
            return xmlRoot;
        }
        return object;
    }

    public boolean shouldWrapObject(Object object, String elementNamespaceUri, String elementLocalName, String elementPrefix) {
        if (this.resultAlwaysXMLRoot) {
            return true;
        }
        XMLField defaultRootField = this.getDefaultRootElementField();
        if (defaultRootField != null) {
            String defaultRootName = defaultRootField.getXPathFragment().getLocalName();
            String defaultRootNamespaceUri = defaultRootField.getXPathFragment().getNamespaceURI();
            if ((defaultRootNamespaceUri == null && elementNamespaceUri == null || defaultRootNamespaceUri == null && elementNamespaceUri.length() == 0 || elementNamespaceUri == null && defaultRootNamespaceUri.length() == 0 || defaultRootNamespaceUri != null && elementNamespaceUri != null && defaultRootNamespaceUri.equals(elementNamespaceUri)) && defaultRootName.equals(elementLocalName)) {
                return false;
            }
        }
        return true;
    }

    public XMLField getDefaultRootElementField() {
        return this.defaultRootElementField;
    }

    private boolean setDefaultRootElementField(String newDefaultRootElement) {
        if (null == newDefaultRootElement || 0 == newDefaultRootElement.length()) {
            this.setDefaultRootElementField((XMLField)null);
            return false;
        }
        this.setDefaultRootElementField(new XMLField(newDefaultRootElement));
        return true;
    }

    public void setDefaultRootElementField(XMLField xmlField) {
        this.defaultRootElementField = xmlField;
    }

    public QName getDefaultRootElementType() {
        if (this.defaultRootElementField != null) {
            return this.defaultRootElementField.getLeafElementType();
        }
        return null;
    }

    public void setDefaultRootElementType(QName type) {
        if (this.defaultRootElementField != null) {
            this.defaultRootElementField.setLeafElementType(type);
        }
    }

    public boolean isSequencedObject() {
        return this.sequencedObject;
    }

    public void setSequencedObject(boolean isSequenced) {
        this.sequencedObject = isSequenced;
    }

    public boolean isWrapper() {
        return this.isWrapper;
    }

    public void setIsWrapper(boolean value) {
        this.isWrapper = value;
    }

    public boolean isResultAlwaysXMLRoot() {
        return this.resultAlwaysXMLRoot;
    }

    public void setResultAlwaysXMLRoot(boolean resultAlwaysXMLRoot) {
        this.resultAlwaysXMLRoot = resultAlwaysXMLRoot;
    }

    @Override
    public DatabaseField getTypedField(DatabaseField field) {
        DatabaseMapping selfMapping;
        XMLField foundField = (XMLField)super.getTypedField(field);
        if (null != foundField) {
            return foundField;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(field.getName(), "/");
        DatabaseField typedField = this.getTypedField(stringTokenizer);
        if (null == typedField && null != (selfMapping = this.objectBuilder.getMappingForField(new XMLField(".")))) {
            return selfMapping.getReferenceDescriptor().getTypedField(field);
        }
        return typedField;
    }

    protected DatabaseField getTypedField(StringTokenizer stringTokenizer) {
        String xPath = "";
        XMLField xmlField = new XMLField();
        xmlField.setNamespaceResolver(this.namespaceResolver);
        while (stringTokenizer.hasMoreElements()) {
            String nextToken = stringTokenizer.nextToken();
            xmlField.setXPath(xPath + nextToken);
            xmlField.initialize();
            DatabaseMapping mapping = this.objectBuilder.getMappingForField(xmlField);
            if (null == mapping) {
                XPathFragment xPathFragment = new XPathFragment(nextToken);
                if (xPathFragment.getIndexValue() > 0) {
                    xmlField.setXPath(xPath + nextToken.substring(0, nextToken.indexOf(91)));
                    xmlField.initialize();
                    mapping = this.objectBuilder.getMappingForField(xmlField);
                    if (null != mapping && mapping.isCollectionMapping() && mapping.getContainerPolicy().isListPolicy()) {
                        if (stringTokenizer.hasMoreElements()) {
                            return ((XMLDescriptor)mapping.getReferenceDescriptor()).getTypedField(stringTokenizer);
                        }
                        return mapping.getField();
                    }
                }
            } else {
                if (stringTokenizer.hasMoreElements()) {
                    return ((XMLDescriptor)mapping.getReferenceDescriptor()).getTypedField(stringTokenizer);
                }
                return mapping.getField();
            }
            xPath = xPath + nextToken + "/";
        }
        return null;
    }
}

