/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import java.io.IOException;
import javax.servlet.ServletException;
import junit.framework.TestCase;
import org.tuckey.web.MockChain;
import org.tuckey.web.MockRequest;
import org.tuckey.web.MockRequestDispatcher;
import org.tuckey.web.MockResponse;
import org.tuckey.web.filters.urlrewrite.RewrittenUrl;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class RewrittenUrlTest
extends TestCase {
    MockResponse response;
    MockRequest request;
    MockChain chain;

    public void setUp() {
        Log.setLevel("DEBUG");
        this.response = new MockResponse();
        this.request = new MockRequest();
        this.chain = new MockChain();
    }

    public void testPermanentRedir() throws IOException, ServletException {
        RewrittenUrl rewrittenUrl = new RewrittenUrl("/hi");
        rewrittenUrl.setPermanentRedirect(true);
        rewrittenUrl.doRewrite(this.request, this.response, this.chain);
        RewrittenUrlTest.assertEquals((String)"/hi", (String)this.response.getHeader("Location"));
        RewrittenUrlTest.assertEquals((int)301, (int)this.response.getStatus());
    }

    public void testTempRedir() throws IOException, ServletException {
        RewrittenUrl rewrittenUrl = new RewrittenUrl("/hi");
        rewrittenUrl.setTemporaryRedirect(true);
        rewrittenUrl.doRewrite(this.request, this.response, this.chain);
        RewrittenUrlTest.assertEquals((String)"/hi", (String)this.response.getHeader("Location"));
        RewrittenUrlTest.assertEquals((int)302, (int)this.response.getStatus());
    }

    public void testForward() throws IOException, ServletException {
        RewrittenUrl rewrittenUrl = new RewrittenUrl("/hi");
        rewrittenUrl.setForward(true);
        rewrittenUrl.doRewrite(this.request, this.response, this.chain);
        RewrittenUrlTest.assertEquals((String)"/hi", (String)MockRequestDispatcher.getCurrent().getUrl());
        RewrittenUrlTest.assertTrue((boolean)MockRequestDispatcher.getCurrent().isForwarded());
    }

    public void testRedir() throws IOException, ServletException {
        RewrittenUrl rewrittenUrl = new RewrittenUrl("/hi");
        rewrittenUrl.setRedirect(true);
        rewrittenUrl.doRewrite(this.request, this.response, this.chain);
        RewrittenUrlTest.assertEquals((String)"/hi", (String)this.response.getRedirectedUrl());
    }

    public void testRedirEncoded() throws IOException, ServletException {
        RewrittenUrl rewrittenUrl = new RewrittenUrl("/hi");
        rewrittenUrl.setRedirect(true);
        rewrittenUrl.setEncode(true);
        rewrittenUrl.doRewrite(this.request, this.response, this.chain);
        RewrittenUrlTest.assertEquals((String)"/hi;mockencoded=test", (String)this.response.getRedirectedUrl());
    }

    public void testPreIncl() throws IOException, ServletException {
        RewrittenUrl rewrittenUrl = new RewrittenUrl("/hi");
        rewrittenUrl.setPreInclude(true);
        rewrittenUrl.setEncode(true);
        rewrittenUrl.doRewrite(this.request, this.response, this.chain);
        RewrittenUrlTest.assertTrue((MockRequestDispatcher.getCurrent().isIncluded() && this.chain.isDoFilterRun() ? 1 : 0) != 0);
    }

    public void testPostIncl() throws IOException, ServletException {
        RewrittenUrl rewrittenUrl = new RewrittenUrl("/hi");
        rewrittenUrl.setPostInclude(true);
        rewrittenUrl.setEncode(true);
        rewrittenUrl.doRewrite(this.request, this.response, this.chain);
        RewrittenUrlTest.assertTrue((MockRequestDispatcher.getCurrent().isIncluded() && this.chain.isDoFilterRun() ? 1 : 0) != 0);
    }
}

