/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jdo.query;

import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.jdo.annotations.NotPersistent;
import javax.jdo.annotations.PersistenceCapable;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;
import org.datanucleus.api.jdo.query.BooleanExpressionImpl;
import org.datanucleus.api.jdo.query.ByteExpressionImpl;
import org.datanucleus.api.jdo.query.CharacterExpressionImpl;
import org.datanucleus.api.jdo.query.CollectionExpressionImpl;
import org.datanucleus.api.jdo.query.DateExpressionImpl;
import org.datanucleus.api.jdo.query.DateTimeExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionType;
import org.datanucleus.api.jdo.query.JDOTypesafeQuery;
import org.datanucleus.api.jdo.query.ListExpressionImpl;
import org.datanucleus.api.jdo.query.MapExpressionImpl;
import org.datanucleus.api.jdo.query.NumericExpressionImpl;
import org.datanucleus.api.jdo.query.ObjectExpressionImpl;
import org.datanucleus.api.jdo.query.PersistableExpressionImpl;
import org.datanucleus.api.jdo.query.StringExpressionImpl;
import org.datanucleus.api.jdo.query.TimeExpressionImpl;
import org.datanucleus.query.typesafe.BooleanExpression;
import org.datanucleus.query.typesafe.ByteExpression;
import org.datanucleus.query.typesafe.CharacterExpression;
import org.datanucleus.query.typesafe.CollectionExpression;
import org.datanucleus.query.typesafe.DateExpression;
import org.datanucleus.query.typesafe.DateTimeExpression;
import org.datanucleus.query.typesafe.ListExpression;
import org.datanucleus.query.typesafe.MapExpression;
import org.datanucleus.query.typesafe.NumericExpression;
import org.datanucleus.query.typesafe.ObjectExpression;
import org.datanucleus.query.typesafe.PersistableExpression;
import org.datanucleus.query.typesafe.StringExpression;
import org.datanucleus.query.typesafe.TimeExpression;
import org.datanucleus.util.AnnotationProcessorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"javax.jdo.annotations.PersistenceCapable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JDOQueryProcessor
extends AbstractProcessor {
    public static final String OPTION_MODE = "queryMode";
    private static final int MODE_FIELD = 1;
    private static final int MODE_PROPERTY = 2;
    public int queryMode = 1;
    public int fieldDepth = 5;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String queryMode = processingEnv.getOptions().get(OPTION_MODE);
        if (queryMode != null && queryMode.equalsIgnoreCase("FIELD")) {
            this.queryMode = 1;
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        Set<? extends Element> elements = roundEnv.getRootElements();
        for (Element element : elements) {
            if (!(element instanceof TypeElement)) continue;
            this.processClass((TypeElement)element);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClass(TypeElement el) {
        if (el == null || !JDOQueryProcessor.isJDOAnnotated(el)) {
            return;
        }
        Elements elementUtils = this.processingEnv.getElementUtils();
        String className = elementUtils.getBinaryName(el).toString();
        String pkgName = className.substring(0, className.lastIndexOf(46));
        String classSimpleName = className.substring(className.lastIndexOf(46) + 1);
        String classSimpleNameNew = JDOTypesafeQuery.getQueryClassNameForClassName((String)classSimpleName);
        String classNameNew = pkgName + "." + classSimpleNameNew;
        System.out.println("DataNucleus : JDO Query - " + className + " -> " + classNameNew);
        TypeElement superEl = this.getPersistentSupertype(el);
        try {
            JavaFileObject javaFile = this.processingEnv.getFiler().createSourceFile(classNameNew, new Element[0]);
            Writer w = javaFile.openWriter();
            try {
                String implClassName;
                String memberName;
                TypeMirror type;
                w.append("package " + pkgName + ";\n");
                w.append("\n");
                String typesafeCls = PersistableExpression.class.getName();
                String typesafePkg = typesafeCls.substring(0, typesafeCls.lastIndexOf(46));
                w.append("import " + typesafePkg + ".*;\n");
                String typesafeImplCls = PersistableExpressionImpl.class.getName();
                String typesafeImplPkg = typesafeImplCls.substring(0, typesafeImplCls.lastIndexOf(46));
                w.append("import " + typesafeImplPkg + ".*;\n");
                w.append("\n");
                w.append("public class " + classSimpleNameNew);
                if (superEl != null) {
                    String superClassName = elementUtils.getBinaryName(superEl).toString();
                    w.append(" extends ").append(superClassName.substring(0, superClassName.lastIndexOf(46) + 1));
                    w.append(JDOTypesafeQuery.getQueryClassNameForClassName((String)superClassName.substring(superClassName.lastIndexOf(46) + 1)));
                } else {
                    w.append(" extends ").append(PersistableExpressionImpl.class.getName());
                    w.append("<" + classSimpleName + ">");
                    w.append(" implements ").append(PersistableExpression.class.getSimpleName() + "<" + classSimpleName + ">");
                }
                w.append("\n");
                w.append("{\n");
                String indent = "    ";
                w.append(indent).append("public static final ").append(classSimpleNameNew).append(" jdoCandidate");
                w.append(" = candidate(\"this\");\n");
                w.append("\n");
                w.append(indent).append("public static " + classSimpleNameNew + " candidate(String name)\n");
                w.append(indent).append("{\n");
                w.append(indent).append(indent).append("return new ").append(classSimpleNameNew);
                w.append("(null, name, " + this.fieldDepth + ");\n");
                w.append(indent).append("}\n");
                w.append("\n");
                w.append(indent).append("public static " + classSimpleNameNew + " candidate()\n");
                w.append(indent).append("{\n");
                w.append(indent).append(indent).append("return jdoCandidate;\n");
                w.append(indent).append("}\n");
                w.append("\n");
                w.append(indent).append("public static " + classSimpleNameNew + " parameter(String name)\n");
                w.append(indent).append("{\n");
                w.append(indent).append(indent).append("return new ").append(classSimpleNameNew);
                w.append("(" + classSimpleName + ".class, name, ExpressionType.PARAMETER);\n");
                w.append(indent).append("}\n");
                w.append("\n");
                w.append(indent).append("public static " + classSimpleNameNew + " variable(String name)\n");
                w.append(indent).append("{\n");
                w.append(indent).append(indent).append("return new ").append(classSimpleNameNew);
                w.append("(" + classSimpleName + ".class, name, ExpressionType.VARIABLE);\n");
                w.append(indent).append("}\n");
                w.append("\n");
                List<? extends Element> members = this.getPersistentMembers(el);
                if (members != null) {
                    for (Element element : members) {
                        if (element.getKind() != ElementKind.FIELD && (element.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)((ExecutableElement)element)))) continue;
                        type = AnnotationProcessorUtils.getDeclaredType((Element)element);
                        memberName = AnnotationProcessorUtils.getMemberName((Element)element);
                        String intfName = this.getExpressionInterfaceNameForType(type);
                        if (this.queryMode == 1) {
                            w.append(indent).append("public final ").append(intfName);
                            w.append(" ").append(memberName).append(";\n");
                            continue;
                        }
                        w.append(indent).append("private ").append(intfName);
                        w.append(" ").append(memberName).append(";\n");
                    }
                }
                w.append("\n");
                w.append(indent).append("public " + classSimpleNameNew).append("(");
                w.append(PersistableExpression.class.getSimpleName() + " parent, String name, int depth)\n");
                w.append(indent).append("{\n");
                if (superEl != null) {
                    w.append(indent).append("    super(parent, name, depth);\n");
                } else {
                    w.append(indent).append("    super(parent, name);\n");
                }
                if (this.queryMode == 1 && members != null) {
                    for (Element element : members) {
                        if (element.getKind() != ElementKind.FIELD && (element.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)((ExecutableElement)element)))) continue;
                        type = AnnotationProcessorUtils.getDeclaredType((Element)element);
                        memberName = AnnotationProcessorUtils.getMemberName((Element)element);
                        implClassName = this.getExpressionImplClassNameForType(type);
                        if (this.isPersistableType(type)) {
                            w.append(indent).append(indent).append("if (depth > 0)\n");
                            w.append(indent).append(indent).append("{\n");
                            w.append(indent).append(indent).append(indent).append("this.").append(memberName);
                            w.append(" = new ").append(implClassName).append("(this, \"" + memberName + "\", depth-1);\n");
                            w.append(indent).append(indent).append("}\n");
                            w.append(indent).append(indent).append("else\n");
                            w.append(indent).append(indent).append("{\n");
                            w.append(indent).append(indent).append(indent).append("this.").append(memberName);
                            w.append(" = null;\n");
                            w.append(indent).append(indent).append("}\n");
                            continue;
                        }
                        w.append(indent).append(indent).append("this.").append(memberName);
                        w.append(" = new ").append(implClassName).append("(this, \"" + memberName + "\");\n");
                    }
                }
                w.append(indent).append("}\n");
                w.append("\n");
                w.append(indent).append("public " + classSimpleNameNew).append("(");
                w.append(Class.class.getSimpleName() + " type, String name, " + ExpressionType.class.getName() + " exprType)\n");
                w.append(indent).append("{\n");
                w.append(indent).append("    super(type, name, exprType);\n");
                if (this.queryMode == 1 && members != null) {
                    for (Element element : members) {
                        if (element.getKind() != ElementKind.FIELD && (element.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)((ExecutableElement)element)))) continue;
                        type = AnnotationProcessorUtils.getDeclaredType((Element)element);
                        memberName = AnnotationProcessorUtils.getMemberName((Element)element);
                        implClassName = this.getExpressionImplClassNameForType(type);
                        if (this.isPersistableType(type)) {
                            w.append(indent).append(indent).append("this.").append(memberName);
                            w.append(" = new ").append(implClassName).append("(this, \"" + memberName + "\", " + this.fieldDepth + ");\n");
                            continue;
                        }
                        w.append(indent).append(indent).append("this.").append(memberName);
                        w.append(" = new ").append(implClassName).append("(this, \"" + memberName + "\");\n");
                    }
                }
                w.append(indent).append("}\n");
                if (this.queryMode == 2 && members != null) {
                    for (Element element : members) {
                        if (element.getKind() != ElementKind.FIELD && (element.getKind() != ElementKind.METHOD || !AnnotationProcessorUtils.isJavaBeanGetter((ExecutableElement)((ExecutableElement)element)))) continue;
                        type = AnnotationProcessorUtils.getDeclaredType((Element)element);
                        memberName = AnnotationProcessorUtils.getMemberName((Element)element);
                        implClassName = this.getExpressionImplClassNameForType(type);
                        String intfName = this.getExpressionInterfaceNameForType(type);
                        w.append("\n");
                        w.append(indent).append("public ").append(intfName).append(" ");
                        w.append(memberName).append("()\n");
                        w.append(indent).append("{\n");
                        w.append(indent).append(indent).append("if (this.").append(memberName).append(" == null)\n");
                        w.append(indent).append(indent).append("{\n");
                        w.append(indent).append(indent).append(indent).append("this." + memberName);
                        w.append(" = new ").append(implClassName).append("(this, \"" + memberName + "\");\n");
                        w.append(indent).append(indent).append("}\n");
                        w.append(indent).append(indent).append("return this.").append(memberName).append(";\n");
                        w.append(indent).append("}\n");
                    }
                }
                w.append("}\n");
                w.flush();
            }
            finally {
                w.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getExpressionInterfaceNameForType(TypeMirror type) {
        if (type.getKind() == TypeKind.BOOLEAN) {
            return BooleanExpression.class.getSimpleName();
        }
        if (type.getKind() == TypeKind.BYTE) {
            return ByteExpression.class.getSimpleName();
        }
        if (type.getKind() == TypeKind.CHAR) {
            return CharacterExpression.class.getSimpleName();
        }
        if (type.getKind() == TypeKind.DOUBLE) {
            return NumericExpression.class.getSimpleName() + "<Double>";
        }
        if (type.getKind() == TypeKind.FLOAT) {
            return NumericExpression.class.getSimpleName() + "<Float>";
        }
        if (type.getKind() == TypeKind.INT) {
            return NumericExpression.class.getSimpleName() + "<Integer>";
        }
        if (type.getKind() == TypeKind.LONG) {
            return NumericExpression.class.getSimpleName() + "<Long>";
        }
        if (type.getKind() == TypeKind.SHORT) {
            return NumericExpression.class.getSimpleName() + "<Short>";
        }
        if (((Object)type).toString().equals(String.class.getName())) {
            return StringExpression.class.getSimpleName();
        }
        if (((Object)type).toString().equals(java.util.Date.class.getName())) {
            return DateTimeExpression.class.getSimpleName();
        }
        if (((Object)type).toString().equals(Date.class.getName())) {
            return DateExpression.class.getSimpleName();
        }
        if (((Object)type).toString().equals(Time.class.getName())) {
            return TimeExpression.class.getSimpleName();
        }
        String typeName = AnnotationProcessorUtils.getDeclaredTypeName((ProcessingEnvironment)this.processingEnv, (TypeMirror)type, (boolean)true);
        AnnotationProcessorUtils.TypeCategory cat = AnnotationProcessorUtils.getTypeCategoryForTypeMirror((String)typeName);
        if (cat == AnnotationProcessorUtils.TypeCategory.MAP) {
            return MapExpression.class.getSimpleName();
        }
        if (cat == AnnotationProcessorUtils.TypeCategory.LIST) {
            return ListExpression.class.getSimpleName();
        }
        if (cat == AnnotationProcessorUtils.TypeCategory.COLLECTION || cat == AnnotationProcessorUtils.TypeCategory.SET) {
            return CollectionExpression.class.getSimpleName();
        }
        TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(type);
        if (typeElement != null && JDOQueryProcessor.isJDOAnnotated(typeElement)) {
            return typeName.substring(0, typeName.lastIndexOf(46) + 1) + JDOTypesafeQuery.getQueryClassNameForClassName((String)typeName.substring(typeName.lastIndexOf(46) + 1));
        }
        return ObjectExpression.class.getSimpleName() + "<" + ((Object)type).toString() + ">";
    }

    private String getExpressionImplClassNameForType(TypeMirror type) {
        if (type.getKind() == TypeKind.BOOLEAN) {
            return BooleanExpressionImpl.class.getSimpleName();
        }
        if (type.getKind() == TypeKind.BYTE) {
            return ByteExpressionImpl.class.getSimpleName();
        }
        if (type.getKind() == TypeKind.CHAR) {
            return CharacterExpressionImpl.class.getSimpleName();
        }
        if (type.getKind() == TypeKind.DOUBLE) {
            return NumericExpressionImpl.class.getSimpleName() + "<Double>";
        }
        if (type.getKind() == TypeKind.FLOAT) {
            return NumericExpressionImpl.class.getSimpleName() + "<Float>";
        }
        if (type.getKind() == TypeKind.INT) {
            return NumericExpressionImpl.class.getSimpleName() + "<Integer>";
        }
        if (type.getKind() == TypeKind.LONG) {
            return NumericExpressionImpl.class.getSimpleName() + "<Long>";
        }
        if (type.getKind() == TypeKind.SHORT) {
            return NumericExpressionImpl.class.getSimpleName() + "<Short>";
        }
        if (((Object)type).toString().equals(String.class.getName())) {
            return StringExpressionImpl.class.getSimpleName();
        }
        if (((Object)type).toString().equals(java.util.Date.class.getName())) {
            return DateTimeExpressionImpl.class.getSimpleName();
        }
        if (((Object)type).toString().equals(Date.class.getName())) {
            return DateExpressionImpl.class.getSimpleName();
        }
        if (((Object)type).toString().equals(Time.class.getName())) {
            return TimeExpressionImpl.class.getSimpleName();
        }
        String typeName = AnnotationProcessorUtils.getDeclaredTypeName((ProcessingEnvironment)this.processingEnv, (TypeMirror)type, (boolean)true);
        AnnotationProcessorUtils.TypeCategory cat = AnnotationProcessorUtils.getTypeCategoryForTypeMirror((String)typeName);
        if (cat == AnnotationProcessorUtils.TypeCategory.MAP) {
            return MapExpressionImpl.class.getSimpleName();
        }
        if (cat == AnnotationProcessorUtils.TypeCategory.LIST) {
            return ListExpressionImpl.class.getSimpleName();
        }
        if (cat == AnnotationProcessorUtils.TypeCategory.COLLECTION || cat == AnnotationProcessorUtils.TypeCategory.SET) {
            return CollectionExpressionImpl.class.getSimpleName();
        }
        TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(type);
        if (typeElement != null && JDOQueryProcessor.isJDOAnnotated(typeElement)) {
            return typeName.substring(0, typeName.lastIndexOf(46) + 1) + JDOTypesafeQuery.getQueryClassNameForClassName((String)typeName.substring(typeName.lastIndexOf(46) + 1));
        }
        return ObjectExpressionImpl.class.getSimpleName() + "<" + ((Object)type).toString() + ">";
    }

    private boolean isPersistableType(TypeMirror type) {
        TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(type);
        return typeElement != null && JDOQueryProcessor.isJDOAnnotated(typeElement);
    }

    private List<? extends Element> getPersistentMembers(TypeElement el) {
        List members = AnnotationProcessorUtils.getFieldMembers((TypeElement)el);
        if (members != null) {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                Element member = (Element)iter.next();
                boolean persistent = true;
                List<? extends AnnotationMirror> annots = member.getAnnotationMirrors();
                if (annots != null) {
                    for (AnnotationMirror annotationMirror : annots) {
                        if (!annotationMirror.getAnnotationType().toString().equals(NotPersistent.class.getName())) continue;
                        persistent = false;
                        break;
                    }
                }
                if (persistent) continue;
                iter.remove();
            }
        }
        return members;
    }

    public TypeElement getPersistentSupertype(TypeElement element) {
        TypeMirror superType = element.getSuperclass();
        if (superType == null || element != null && "java.lang.Object".equals(element.toString())) {
            return null;
        }
        TypeElement superElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(superType);
        if (superElement == null || JDOQueryProcessor.isJDOAnnotated(superElement)) {
            return superElement;
        }
        return this.getPersistentSupertype(superElement);
    }

    public static boolean isJDOAnnotated(TypeElement el) {
        return el.getAnnotation(PersistenceCapable.class) != null;
    }
}

