/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.gcubesearchlibrary;

import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.BadRequestException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.CollectionsRetrievalFailureException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.InternalServerErrorException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.NotFoundException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.PropertiesFileRetrievalException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.SearchFailureException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.SearchStatusFailureException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.ServletURLRetrievalException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.UnauthorizedException;
import gr.uoa.di.madgik.gcubesearchlibrary.exceptions.XMLParsingException;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.CollectionBean;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.CriterionBean;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.ResultBean;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.SearchStatusBean;
import gr.uoa.di.madgik.gcubesearchlibrary.model.beans.ServletURLBean;
import gr.uoa.di.madgik.gcubesearchlibrary.parsers.XMLParser;
import gr.uoa.di.madgik.gcubesearchlibrary.utils.FileUtils;
import gr.uoa.di.madgik.gcubesearchlibrary.utils.RequestHandler;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;

public class SearchHandler {
    public static HashMap<String, List<CollectionBean>> getCollections(ServletURLBean servletURL, String username, String sessionID) throws PropertiesFileRetrievalException, ServletURLRetrievalException, UnauthorizedException, NotFoundException, BadRequestException, XMLParsingException, CollectionsRetrievalFailureException {
        try {
            sessionID = sessionID.trim();
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String irServlet = FileUtils.getPropertyValue("config.properties", "ir_servlet");
            String file = "/" + irServlet + "/" + "ShowCollections" + ";" + "jsessionid" + "=" + sessionID + "?" + "responseType" + "=" + "xml" + "&" + "username" + "=" + username;
            URL url = new URL(protocol, host, new Integer(port), file);
            String response = RequestHandler.submitGetRequest(url, sessionID);
            return XMLParser.parseCollectionsResponse(response);
        }
        catch (NumberFormatException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (InternalServerErrorException e) {
            throw new CollectionsRetrievalFailureException("Failed to retrieve the available collections. An internal server error occurred");
        }
    }

    public static SearchStatusBean getSearchStatus(ServletURLBean servletURL, List<String> selectedCollectionsIDs, String username, String sessionID) throws PropertiesFileRetrievalException, UnauthorizedException, NotFoundException, BadRequestException, XMLParsingException, ServletURLRetrievalException, SearchStatusFailureException {
        sessionID = sessionID.trim();
        if (selectedCollectionsIDs != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("{\"SelectedCollections\":[");
            for (String collectionID : selectedCollectionsIDs) {
                sb.append("\"");
                sb.append(collectionID);
                sb.append("\",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]}");
            try {
                String protocol = null;
                String host = null;
                String port = null;
                if (servletURL != null) {
                    protocol = servletURL.getProtocol();
                    host = servletURL.getHost();
                    port = servletURL.getPort();
                } else {
                    protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                    host = FileUtils.getPropertyValue("config.properties", "host");
                    port = FileUtils.getPropertyValue("config.properties", "port");
                }
                String irServlet = FileUtils.getPropertyValue("config.properties", "ir_servlet");
                String file = "/" + irServlet + "/" + "CollectionInfos" + ";" + "jsessionid" + "=" + sessionID + "?" + "responseType" + "=" + "xml" + "&" + "selectedCollections" + "=" + sb.toString() + "&" + "username" + "=" + username;
                URL url = new URL(protocol, host, new Integer(port), file);
                String response = RequestHandler.submitGetRequest(url, sessionID);
                return XMLParser.parseCollectionInfoResponse(response);
            }
            catch (NumberFormatException e) {
                throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
            }
            catch (IOException e) {
                throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
            }
            catch (InternalServerErrorException e) {
                throw new SearchStatusFailureException("Failed to get the search status for the selected collections. An internal server error occurred");
            }
        }
        return null;
    }

    public static List<ResultBean> submitFullTextSearch(ServletURLBean servletURL, String searchTerm, List<String> selectedCollectionsIDs, String username, String sessionID, Integer numOfResults) throws SearchFailureException, ServletURLRetrievalException, XMLParsingException, PropertiesFileRetrievalException, UnauthorizedException, NotFoundException, BadRequestException {
        sessionID = sessionID.trim();
        if (selectedCollectionsIDs != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("{\"SelectedCollections\":[");
            for (String collectionID : selectedCollectionsIDs) {
                sb.append("\"");
                sb.append(collectionID);
                sb.append("\",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]}");
            try {
                String protocol = null;
                String host = null;
                String port = null;
                if (servletURL != null) {
                    protocol = servletURL.getProtocol();
                    host = servletURL.getHost();
                    port = servletURL.getPort();
                } else {
                    protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                    host = FileUtils.getPropertyValue("config.properties", "host");
                    port = FileUtils.getPropertyValue("config.properties", "port");
                }
                String irServlet = FileUtils.getPropertyValue("config.properties", "ir_servlet");
                String file = "/" + irServlet + "/" + "Search" + ";" + "jsessionid" + "=" + sessionID + "?" + "responseType" + "=" + "xml" + "&" + "searchType" + "=" + "simple" + "&" + "searchTerms" + "=" + URLEncoder.encode(searchTerm, "UTF-8") + "&" + "selectedCollections" + "=" + sb.toString() + "&" + "username" + "=" + username + "&" + "allFields=true";
                String resNum = null;
                if (numOfResults != null) {
                    file = file + "&count=" + numOfResults.toString();
                } else {
                    resNum = FileUtils.getPropertyValue("config.properties", "results_number");
                    if (resNum != null) {
                        file = file + "&count=" + resNum;
                    }
                }
                URL url = new URL(protocol, host, new Integer(port), file);
                String response = RequestHandler.submitGetRequest(url, sessionID);
                return XMLParser.parseSearchResults(response);
            }
            catch (NumberFormatException e) {
                throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
            }
            catch (IOException e) {
                throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
            }
            catch (InternalServerErrorException e) {
                throw new SearchFailureException("Search submission failed. An internal server error occurred");
            }
        }
        return null;
    }

    public static List<ResultBean> submitSimpleSearchForTesting(ServletURLBean servletURL, String searchTerm, Integer numOfResults) throws SearchFailureException, ServletURLRetrievalException, XMLParsingException, PropertiesFileRetrievalException, UnauthorizedException, NotFoundException, BadRequestException {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"SelectedCollections\":[");
        sb.append("\"");
        sb.append("c5b83790-f35f-11dd-9a37-9b05ac676cca");
        sb.append("\"");
        sb.append("]}");
        try {
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String irServlet = FileUtils.getPropertyValue("config.properties", "ir_servlet");
            String file = "/" + irServlet + "/" + "Search" + "?" + "responseType" + "=" + "xml" + "&" + "searchType" + "=" + "simple" + "&" + "searchTerms" + "=" + searchTerm + "&" + "selectedCollections" + "=" + sb.toString();
            String resNum = null;
            if (numOfResults != null) {
                file = file + "&count=" + numOfResults.toString();
            } else {
                resNum = FileUtils.getPropertyValue("config.properties", "results_number");
                if (resNum != null) {
                    file = file + "&count=" + resNum;
                }
            }
            URL url = new URL(protocol, host, new Integer(port), file);
            String response = RequestHandler.submitGetRequest(url, null);
            return XMLParser.parseSearchResults(response);
        }
        catch (NumberFormatException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (InternalServerErrorException e) {
            throw new SearchFailureException("Search submission failed. An internal server error occurred");
        }
    }

    public static List<ResultBean> submitGenericSearch(ServletURLBean servletURL, String searchTerm, Integer numOfResults) throws SearchFailureException, ServletURLRetrievalException, XMLParsingException, PropertiesFileRetrievalException, UnauthorizedException, NotFoundException, BadRequestException {
        try {
            String protocol = null;
            String host = null;
            String port = null;
            if (servletURL != null) {
                protocol = servletURL.getProtocol();
                host = servletURL.getHost();
                port = servletURL.getPort();
            } else {
                protocol = FileUtils.getPropertyValue("config.properties", "protocol");
                host = FileUtils.getPropertyValue("config.properties", "host");
                port = FileUtils.getPropertyValue("config.properties", "port");
            }
            String irServlet = FileUtils.getPropertyValue("config.properties", "ir_servlet");
            String file = "/" + irServlet + "/" + "GenericSearch" + "?" + "responseType" + "=" + "xml" + "&" + "searchTerms" + "=" + URLEncoder.encode(searchTerm, "UTF-8") + "&" + "allFields=true";
            String resNum = null;
            if (numOfResults != null) {
                file = file + "&count=" + numOfResults.toString();
            } else {
                resNum = FileUtils.getPropertyValue("config.properties", "results_number");
                if (resNum != null) {
                    file = file + "&count=" + resNum;
                }
            }
            URL url = new URL(protocol, host, new Integer(port), file);
            String response = RequestHandler.submitGetRequest(url, null);
            return XMLParser.parseSearchResults(response);
        }
        catch (NumberFormatException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (IOException e) {
            throw new ServletURLRetrievalException(e.getMessage(), e.getCause());
        }
        catch (InternalServerErrorException e) {
            throw new SearchFailureException("Search submission failed. An internal server error occurred");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<ResultBean> submitAdvancedSearch(ServletURLBean servletURL, List<CriterionBean> criteria, List<String> selectedCollectionsIDs, String username, String sessionID, Integer numOfResults) throws SearchFailureException, ServletURLRetrievalException, PropertiesFileRetrievalException, UnauthorizedException, NotFoundException, BadRequestException, XMLParsingException {
        sessionID = sessionID.trim();
        if (selectedCollectionsIDs != null) {
            StringBuilder collectionsSb = new StringBuilder();
            collectionsSb.append("{\"SelectedCollections\":[");
            for (String string : selectedCollectionsIDs) {
                collectionsSb.append("\"");
                collectionsSb.append(string);
                collectionsSb.append("\",");
            }
            collectionsSb.deleteCharAt(collectionsSb.length() - 1);
            collectionsSb.append("]}");
            StringBuilder criteriaSb = new StringBuilder();
            criteriaSb.append("[");
            for (CriterionBean c : criteria) {
                criteriaSb.append("{\"id\":\"");
                criteriaSb.append(c.getId());
                criteriaSb.append("\",\"value\":\"");
                criteriaSb.append(c.getValue());
                criteriaSb.append("\"},");
            }
            criteriaSb.deleteCharAt(criteriaSb.length() - 1);
            criteriaSb.append("]");
            try {
                void var8_13;
                Object var8_10 = null;
                String host = null;
                String port = null;
                if (servletURL != null) {
                    String string = servletURL.getProtocol();
                    host = servletURL.getHost();
                    port = servletURL.getPort();
                } else {
                    String string = FileUtils.getPropertyValue("config.properties", "protocol");
                    host = FileUtils.getPropertyValue("config.properties", "host");
                    port = FileUtils.getPropertyValue("config.properties", "port");
                }
                String irServlet = FileUtils.getPropertyValue("config.properties", "ir_servlet");
                String file = "/" + irServlet + "/" + "Search" + ";" + "jsessionid" + "=" + sessionID + "?" + "responseType" + "=" + "xml" + "&" + "searchType" + "=" + "advanced" + "&" + "criteria" + "=" + URLEncoder.encode(criteriaSb.toString(), "UTF-8") + "&" + "selectedCollections" + "=" + collectionsSb.toString() + "&" + "language" + "=" + "en" + "&" + "username" + "=" + username + "&" + "allFields=true";
                String resNum = null;
                if (numOfResults != null) {
                    file = file + "&count=" + numOfResults.toString();
                } else {
                    resNum = FileUtils.getPropertyValue("config.properties", "results_number");
                    if (resNum != null) {
                        file = file + "&count=" + resNum;
                    }
                }
                URL url = new URL((String)var8_13, host, new Integer(port), file);
                String response = RequestHandler.submitGetRequest(url, sessionID);
                return XMLParser.parseSearchResults(response);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ServletURLRetrievalException(numberFormatException.getMessage(), numberFormatException.getCause());
            }
            catch (IOException iOException) {
                throw new ServletURLRetrievalException(iOException.getMessage(), iOException.getCause());
            }
            catch (InternalServerErrorException internalServerErrorException) {
                throw new SearchFailureException("Search submission failed. An internal server error occurred");
            }
        }
        return null;
    }
}

