/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import jodd.bean.BeanUtil;
import jodd.db.oom.DbOomException;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.util.ArraysUtil;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;

public class JoinHintResolver {
    public Object[] join(Object[] data, String hints) {
        if (hints == null) {
            return data;
        }
        return this.join(data, StringUtil.splitc(hints, ','));
    }

    public Object[] join(Object[] data, String[] hints) {
        if (hints == null) {
            return data;
        }
        HashMap<String, Object> context = new HashMap<String, Object>(hints.length);
        for (int i = 0; i < hints.length; ++i) {
            hints[i] = hints[i].trim();
            String hint = hints[i];
            if (hint.indexOf(46) != -1) continue;
            context.put(hint, data[i]);
        }
        if (context.size() == data.length) {
            return data;
        }
        Object[] result = new Object[context.size()];
        int count = 0;
        for (int i = 0; i < hints.length; ++i) {
            String hint = hints[i];
            int ndx = hint.indexOf(46);
            if (ndx != -1) {
                String key = hint.substring(0, ndx);
                Object value = context.get(key);
                if (value == null) {
                    throw new DbOomException("Hint key not found:" + key);
                }
                String hintPropertyName = hint.substring(ndx + 1);
                Class hintPropertyType = BeanUtil.getPropertyType(value, hintPropertyName);
                if (hintPropertyType == null) continue;
                ClassDescriptor cd = ClassIntrospector.lookup(hintPropertyType);
                if (cd.isCollection()) {
                    try {
                        Collection collection = (Collection)BeanUtil.getDeclaredProperty(value, hintPropertyName);
                        if (collection == null) {
                            collection = (Collection)ReflectUtil.newInstance(hintPropertyType);
                            BeanUtil.setDeclaredPropertySilent(value, hintPropertyName, collection);
                        }
                        collection.add(data[i]);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new DbOomException(ex);
                    }
                }
                if (cd.isArray()) {
                    try {
                        Object[] array = (Object[])BeanUtil.getDeclaredProperty(value, hintPropertyName);
                        if (array == null) {
                            array = (Object[])Array.newInstance(hintPropertyType.getComponentType(), 1);
                            BeanUtil.setDeclaredPropertySilent(value, hintPropertyName, array);
                            array[0] = data[i];
                            continue;
                        }
                        Object[] newArray = ArraysUtil.append(array, data[i]);
                        if (newArray == array) continue;
                        BeanUtil.setDeclaredPropertySilent(value, hintPropertyName, newArray);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new DbOomException(ex);
                    }
                }
                BeanUtil.setDeclaredPropertySilent(value, hintPropertyName, data[i]);
                continue;
            }
            result[count] = data[i];
            ++count;
        }
        return result;
    }
}

