/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jodd.JoddMail;
import jodd.mail.Email;
import jodd.mail.EmailAttachment;
import jodd.mail.EmailMessage;
import jodd.mail.MailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMailSession {
    private static final String ALTERNATIVE = "alternative";
    private static final String RELATED = "related";
    private static final String CHARSET = ";charset=";
    private static final String INLINE = "inline";
    protected final Session mailSession;
    protected final Transport mailTransport;

    public SendMailSession(Session session, Transport transport) {
        this.mailSession = session;
        this.mailTransport = transport;
    }

    public void open() {
        try {
            this.mailTransport.connect();
        }
        catch (MessagingException msex) {
            throw new MailException("Unable to connect", msex);
        }
    }

    public void sendMail(Email mail) {
        Message msg;
        try {
            msg = this.createMessage(mail, this.mailSession);
        }
        catch (MessagingException mex) {
            throw new MailException("Unable to prepare email message: " + mail, mex);
        }
        try {
            this.mailTransport.sendMessage(msg, msg.getAllRecipients());
        }
        catch (MessagingException mex) {
            throw new MailException("Unable to send email message: " + mail, mex);
        }
    }

    public void close() {
        try {
            this.mailTransport.close();
        }
        catch (MessagingException mex) {
            throw new MailException("Unable to close session", mex);
        }
    }

    protected Message createMessage(Email email, Session session) throws MessagingException {
        int i;
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(email.getFrom()));
        int totalTo = email.getTo().length;
        InternetAddress[] address = new InternetAddress[totalTo];
        for (int i2 = 0; i2 < totalTo; ++i2) {
            address[i2] = new InternetAddress(email.getTo()[i2]);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])address);
        if (email.getReplyTo() != null) {
            int totalReplyTo = email.getReplyTo().length;
            address = new InternetAddress[totalReplyTo];
            for (i = 0; i < totalReplyTo; ++i) {
                address[i] = new InternetAddress(email.getReplyTo()[i]);
            }
            msg.setReplyTo((Address[])address);
        }
        if (email.getCc() != null) {
            int totalCc = email.getCc().length;
            address = new InternetAddress[totalCc];
            for (i = 0; i < totalCc; ++i) {
                address[i] = new InternetAddress(email.getCc()[i]);
            }
            msg.setRecipients(Message.RecipientType.CC, (Address[])address);
        }
        if (email.getBcc() != null) {
            int totalBcc = email.getBcc().length;
            address = new InternetAddress[totalBcc];
            for (i = 0; i < totalBcc; ++i) {
                address[i] = new InternetAddress(email.getBcc()[i]);
            }
            msg.setRecipients(Message.RecipientType.BCC, (Address[])address);
        }
        msg.setSubject(email.getSubject());
        Date date = email.getSentDate();
        if (date == null) {
            date = new Date();
        }
        msg.setSentDate(date);
        Map<String, String> headers = email.getAllHeaders();
        if (headers != null) {
            for (Map.Entry<String, String> stringStringEntry : headers.entrySet()) {
                String value = stringStringEntry.getValue();
                msg.setHeader(stringStringEntry.getKey(), value);
            }
        }
        LinkedList<EmailMessage> messages = email.getAllMessages();
        LinkedList<EmailAttachment> attachments = email.getAttachments();
        int totalMessages = messages.size();
        if (attachments == null && totalMessages == 1) {
            EmailMessage emailMessage = messages.get(0);
            msg.setContent((Object)emailMessage.getContent(), emailMessage.getMimeType() + CHARSET + emailMessage.getEncoding());
        } else {
            MimeMultipart multipart;
            MimeMultipart msgMultipart = multipart = new MimeMultipart();
            if (totalMessages > 1) {
                MimeBodyPart bodyPart = new MimeBodyPart();
                msgMultipart = new MimeMultipart(ALTERNATIVE);
                bodyPart.setContent((Multipart)msgMultipart);
                multipart.addBodyPart((BodyPart)bodyPart);
            }
            for (EmailMessage emailMessage : messages) {
                LinkedList<EmailAttachment> embeddedAttachments = this.filterEmbeddedAttachments(attachments, emailMessage);
                MimeBodyPart bodyPart = new MimeBodyPart();
                if (embeddedAttachments == null) {
                    bodyPart.setContent((Object)emailMessage.getContent(), emailMessage.getMimeType() + CHARSET + emailMessage.getEncoding());
                } else {
                    MimeMultipart relatedMultipart = new MimeMultipart(RELATED);
                    MimeBodyPart messageData = new MimeBodyPart();
                    messageData.setContent((Object)emailMessage.getContent(), emailMessage.getMimeType() + CHARSET + emailMessage.getEncoding());
                    relatedMultipart.addBodyPart((BodyPart)messageData);
                    for (EmailAttachment att : embeddedAttachments) {
                        MimeBodyPart attBodyPart = this.createAttachmentBodyPart(att);
                        relatedMultipart.addBodyPart((BodyPart)attBodyPart);
                    }
                    bodyPart.setContent((Multipart)relatedMultipart);
                }
                msgMultipart.addBodyPart((BodyPart)bodyPart);
            }
            if (attachments != null) {
                for (EmailAttachment att : attachments) {
                    MimeBodyPart attBodyPart = this.createAttachmentBodyPart(att);
                    multipart.addBodyPart((BodyPart)attBodyPart);
                }
            }
            msg.setContent((Multipart)multipart);
        }
        return msg;
    }

    protected MimeBodyPart createAttachmentBodyPart(EmailAttachment attachment) throws MessagingException {
        MimeBodyPart attBodyPart = new MimeBodyPart();
        String attachmentName = attachment.getEncodedName();
        if (attachmentName != null) {
            attBodyPart.setFileName(attachmentName);
        }
        attBodyPart.setDataHandler(new DataHandler(attachment.getDataSource()));
        if (attachment.isInline()) {
            attBodyPart.setContentID("<" + attachment.getContentId() + ">");
            attBodyPart.setDisposition(INLINE);
        }
        return attBodyPart;
    }

    protected LinkedList<EmailAttachment> filterEmbeddedAttachments(LinkedList<EmailAttachment> attachments, EmailMessage emailMessage) {
        if (attachments == null) {
            return null;
        }
        LinkedList<EmailAttachment> embeddedAttachments = null;
        Iterator iterator = attachments.iterator();
        while (iterator.hasNext()) {
            EmailAttachment emailAttachment = (EmailAttachment)iterator.next();
            if (!emailAttachment.isEmbeddedInto(emailMessage)) continue;
            if (embeddedAttachments == null) {
                embeddedAttachments = new LinkedList<EmailAttachment>();
            }
            embeddedAttachments.add(emailAttachment);
            iterator.remove();
        }
        return embeddedAttachments;
    }

    static {
        JoddMail.mailSystem.defineJavaMailSystemProperties();
    }
}

