/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.criteria.CriteriaQueryImpl;
import org.hibernate.ejb.criteria.ExpressionImplementor;
import org.hibernate.ejb.criteria.OrderImpl;
import org.hibernate.ejb.criteria.PathImplementor;
import org.hibernate.ejb.criteria.expression.BinaryArithmeticOperation;
import org.hibernate.ejb.criteria.expression.CoalesceExpression;
import org.hibernate.ejb.criteria.expression.CompoundSelectionImpl;
import org.hibernate.ejb.criteria.expression.ConcatExpression;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.expression.NullLiteralExpression;
import org.hibernate.ejb.criteria.expression.NullifExpression;
import org.hibernate.ejb.criteria.expression.ParameterExpressionImpl;
import org.hibernate.ejb.criteria.expression.SearchedCaseExpression;
import org.hibernate.ejb.criteria.expression.SimpleCaseExpression;
import org.hibernate.ejb.criteria.expression.SizeOfCollectionExpression;
import org.hibernate.ejb.criteria.expression.SubqueryComparisonModifierExpression;
import org.hibernate.ejb.criteria.expression.UnaryArithmeticOperation;
import org.hibernate.ejb.criteria.expression.function.AbsFunction;
import org.hibernate.ejb.criteria.expression.function.AggregationFunction;
import org.hibernate.ejb.criteria.expression.function.BasicFunctionExpression;
import org.hibernate.ejb.criteria.expression.function.CurrentDateFunction;
import org.hibernate.ejb.criteria.expression.function.CurrentTimeFunction;
import org.hibernate.ejb.criteria.expression.function.CurrentTimestampFunction;
import org.hibernate.ejb.criteria.expression.function.LengthFunction;
import org.hibernate.ejb.criteria.expression.function.LocateFunction;
import org.hibernate.ejb.criteria.expression.function.LowerFunction;
import org.hibernate.ejb.criteria.expression.function.ParameterizedFunctionExpression;
import org.hibernate.ejb.criteria.expression.function.SqrtFunction;
import org.hibernate.ejb.criteria.expression.function.SubstringFunction;
import org.hibernate.ejb.criteria.expression.function.TrimFunction;
import org.hibernate.ejb.criteria.expression.function.UpperFunction;
import org.hibernate.ejb.criteria.path.PluralAttributePath;
import org.hibernate.ejb.criteria.predicate.BetweenPredicate;
import org.hibernate.ejb.criteria.predicate.BooleanAssertionPredicate;
import org.hibernate.ejb.criteria.predicate.BooleanExpressionPredicate;
import org.hibernate.ejb.criteria.predicate.BooleanStaticAssertionPredicate;
import org.hibernate.ejb.criteria.predicate.ComparisonPredicate;
import org.hibernate.ejb.criteria.predicate.CompoundPredicate;
import org.hibernate.ejb.criteria.predicate.ExistsPredicate;
import org.hibernate.ejb.criteria.predicate.InPredicate;
import org.hibernate.ejb.criteria.predicate.IsEmptyPredicate;
import org.hibernate.ejb.criteria.predicate.LikePredicate;
import org.hibernate.ejb.criteria.predicate.MemberOfPredicate;
import org.hibernate.ejb.criteria.predicate.NullnessPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaBuilderImpl
implements CriteriaBuilder,
Serializable {
    private final EntityManagerFactoryImpl entityManagerFactory;

    public CriteriaBuilderImpl(EntityManagerFactoryImpl entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public EntityManagerFactoryImpl getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this, Object.class);
    }

    public <T> CriteriaQuery<T> createQuery(Class<T> resultClass) {
        return new CriteriaQueryImpl<T>(this, resultClass);
    }

    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this, Tuple.class);
    }

    void checkMultiselect(List<Selection<?>> selections) {
        for (Selection<?> selection : selections) {
            if (!selection.isCompoundSelection()) continue;
            if (selection.getJavaType().isArray()) {
                throw new IllegalArgumentException("multiselect selections cannot contain compound array-valued elements");
            }
            if (!Tuple.class.isAssignableFrom(selection.getJavaType())) continue;
            throw new IllegalArgumentException("multiselect selections cannot contain compound tuple-valued elements");
        }
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return this.tuple(Arrays.asList(selections));
    }

    public CompoundSelection<Tuple> tuple(List<Selection<?>> selections) {
        this.checkMultiselect(selections);
        return new CompoundSelectionImpl<Tuple>(this, Tuple.class, selections);
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return this.array(Arrays.asList(selections));
    }

    public CompoundSelection<Object[]> array(List<Selection<?>> selections) {
        return this.array(Object[].class, selections);
    }

    public <Y> CompoundSelection<Y> array(Class<Y> type, List<Selection<?>> selections) {
        this.checkMultiselect(selections);
        return new CompoundSelectionImpl<Y>(this, type, selections);
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> result, Selection<?> ... selections) {
        return this.construct(result, Arrays.asList(selections));
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> result, List<Selection<?>> selections) {
        this.checkMultiselect(selections);
        return new CompoundSelectionImpl<Y>(this, result, selections);
    }

    public Order asc(Expression<?> x) {
        return new OrderImpl(x, true);
    }

    public Order desc(Expression<?> x) {
        return new OrderImpl(x, false);
    }

    public Predicate wrap(Expression<Boolean> expression) {
        if (Predicate.class.isInstance(expression)) {
            return (Predicate)expression;
        }
        if (PathImplementor.class.isInstance(expression)) {
            return new BooleanAssertionPredicate(this, expression, Boolean.TRUE);
        }
        return new BooleanExpressionPredicate(this, expression);
    }

    public Predicate not(Expression<Boolean> expression) {
        return this.wrap(expression).not();
    }

    public Predicate and(Expression<Boolean> x, Expression<Boolean> y) {
        return new CompoundPredicate(this, Predicate.BooleanOperator.AND, x, y);
    }

    public Predicate or(Expression<Boolean> x, Expression<Boolean> y) {
        return new CompoundPredicate(this, Predicate.BooleanOperator.OR, x, y);
    }

    public Predicate and(Predicate ... restrictions) {
        return new CompoundPredicate(this, Predicate.BooleanOperator.AND, (Expression<Boolean>[])restrictions);
    }

    public Predicate or(Predicate ... restrictions) {
        return new CompoundPredicate(this, Predicate.BooleanOperator.OR, (Expression<Boolean>[])restrictions);
    }

    public Predicate conjunction() {
        return new CompoundPredicate(this, Predicate.BooleanOperator.AND);
    }

    public Predicate disjunction() {
        return new CompoundPredicate(this, Predicate.BooleanOperator.OR);
    }

    public Predicate isTrue(Expression<Boolean> expression) {
        if (CompoundPredicate.class.isInstance(expression)) {
            CompoundPredicate predicate = (CompoundPredicate)expression;
            if (predicate.getExpressions().size() == 0) {
                return new BooleanStaticAssertionPredicate(this, predicate.getOperator() == Predicate.BooleanOperator.AND);
            }
            return predicate;
        }
        if (Predicate.class.isInstance(expression)) {
            return (Predicate)expression;
        }
        return new BooleanAssertionPredicate(this, expression, Boolean.TRUE);
    }

    public Predicate isFalse(Expression<Boolean> expression) {
        if (CompoundPredicate.class.isInstance(expression)) {
            CompoundPredicate predicate = (CompoundPredicate)expression;
            if (predicate.getExpressions().size() == 0) {
                return new BooleanStaticAssertionPredicate(this, predicate.getOperator() == Predicate.BooleanOperator.OR);
            }
            predicate.not();
            return predicate;
        }
        if (Predicate.class.isInstance(expression)) {
            Predicate predicate = (Predicate)expression;
            predicate.not();
            return predicate;
        }
        return new BooleanAssertionPredicate(this, expression, Boolean.FALSE);
    }

    public Predicate isNull(Expression<?> x) {
        return new NullnessPredicate(this, x);
    }

    public Predicate isNotNull(Expression<?> x) {
        return this.isNull(x).not();
    }

    public Predicate equal(Expression<?> x, Expression<?> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.EQUAL, x, y);
    }

    public Predicate notEqual(Expression<?> x, Expression<?> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.NOT_EQUAL, x, y);
    }

    public Predicate equal(Expression<?> x, Object y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.EQUAL, x, y);
    }

    public Predicate notEqual(Expression<?> x, Object y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.NOT_EQUAL, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN_OR_EQUAL, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN_OR_EQUAL, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN_OR_EQUAL, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN_OR_EQUAL, x, y);
    }

    public Predicate gt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN, x, y);
    }

    public Predicate lt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN, x, y);
    }

    public Predicate ge(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN_OR_EQUAL, x, y);
    }

    public Predicate le(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN_OR_EQUAL, x, y);
    }

    public Predicate gt(Expression<? extends Number> x, Number y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN, x, y);
    }

    public Predicate lt(Expression<? extends Number> x, Number y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN, x, y);
    }

    public Predicate ge(Expression<? extends Number> x, Number y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN_OR_EQUAL, x, y);
    }

    public Predicate le(Expression<? extends Number> x, Number y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN_OR_EQUAL, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> expression, Y lowerBound, Y upperBound) {
        return new BetweenPredicate<Y>(this, expression, lowerBound, upperBound);
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> expression, Expression<? extends Y> lowerBound, Expression<? extends Y> upperBound) {
        return new BetweenPredicate<Y>(this, expression, lowerBound, upperBound);
    }

    public <T> CriteriaBuilder.In<T> in(Expression<? extends T> expression) {
        return new InPredicate<T>(this, expression);
    }

    public <T> CriteriaBuilder.In<T> in(Expression<? extends T> expression, Expression<? extends T> ... values) {
        return new InPredicate<T>(this, expression, values);
    }

    public <T> CriteriaBuilder.In<T> in(Expression<? extends T> expression, T ... values) {
        return new InPredicate<T>(this, expression, values);
    }

    public <T> CriteriaBuilder.In<T> in(Expression<? extends T> expression, Collection<T> values) {
        return new InPredicate<T>(this, expression, values);
    }

    public Predicate like(Expression<String> matchExpression, Expression<String> pattern) {
        return new LikePredicate(this, matchExpression, pattern);
    }

    public Predicate like(Expression<String> matchExpression, Expression<String> pattern, Expression<Character> escapeCharacter) {
        return new LikePredicate(this, matchExpression, pattern, escapeCharacter);
    }

    public Predicate like(Expression<String> matchExpression, Expression<String> pattern, char escapeCharacter) {
        return new LikePredicate(this, matchExpression, pattern, escapeCharacter);
    }

    public Predicate like(Expression<String> matchExpression, String pattern) {
        return new LikePredicate(this, matchExpression, pattern);
    }

    public Predicate like(Expression<String> matchExpression, String pattern, Expression<Character> escapeCharacter) {
        return new LikePredicate(this, matchExpression, pattern, escapeCharacter);
    }

    public Predicate like(Expression<String> matchExpression, String pattern, char escapeCharacter) {
        return new LikePredicate(this, matchExpression, pattern, escapeCharacter);
    }

    public Predicate notLike(Expression<String> matchExpression, Expression<String> pattern) {
        return this.like(matchExpression, pattern).not();
    }

    public Predicate notLike(Expression<String> matchExpression, Expression<String> pattern, Expression<Character> escapeCharacter) {
        return this.like(matchExpression, pattern, escapeCharacter).not();
    }

    public Predicate notLike(Expression<String> matchExpression, Expression<String> pattern, char escapeCharacter) {
        return this.like(matchExpression, pattern, escapeCharacter).not();
    }

    public Predicate notLike(Expression<String> matchExpression, String pattern) {
        return this.like(matchExpression, pattern).not();
    }

    public Predicate notLike(Expression<String> matchExpression, String pattern, Expression<Character> escapeCharacter) {
        return this.like(matchExpression, pattern, escapeCharacter).not();
    }

    public Predicate notLike(Expression<String> matchExpression, String pattern, char escapeCharacter) {
        return this.like(matchExpression, pattern, escapeCharacter).not();
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass) {
        return new ParameterExpressionImpl<T>(this, paramClass);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<T>(this, paramClass, name);
    }

    public <T> Expression<T> literal(T value) {
        if (value == null) {
            throw new IllegalArgumentException("literal value cannot be null");
        }
        return new LiteralExpression<T>(this, value);
    }

    public <T> Expression<T> nullLiteral(Class<T> resultClass) {
        return new NullLiteralExpression<T>(this, resultClass);
    }

    public <N extends Number> Expression<Double> avg(Expression<N> x) {
        return new AggregationFunction.AVG(this, x);
    }

    public <N extends Number> Expression<N> sum(Expression<N> x) {
        return new AggregationFunction.SUM<N>(this, x);
    }

    public Expression<Long> sumAsLong(Expression<Integer> x) {
        return new AggregationFunction.SUM<Long>(this, x, Long.class);
    }

    public Expression<Double> sumAsDouble(Expression<Float> x) {
        return new AggregationFunction.SUM<Double>(this, x, Double.class);
    }

    public <N extends Number> Expression<N> max(Expression<N> x) {
        return new AggregationFunction.MAX<N>(this, x);
    }

    public <N extends Number> Expression<N> min(Expression<N> x) {
        return new AggregationFunction.MIN<N>(this, x);
    }

    public <X extends Comparable<? super X>> Expression<X> greatest(Expression<X> x) {
        return new AggregationFunction.GREATEST<X>(this, x);
    }

    public <X extends Comparable<? super X>> Expression<X> least(Expression<X> x) {
        return new AggregationFunction.LEAST<X>(this, x);
    }

    public Expression<Long> count(Expression<?> x) {
        return new AggregationFunction.COUNT(this, x, false);
    }

    public Expression<Long> countDistinct(Expression<?> x) {
        return new AggregationFunction.COUNT(this, x, true);
    }

    public <T> Expression<T> function(String name, Class<T> returnType, Expression<?> ... arguments) {
        return new ParameterizedFunctionExpression<T>(this, returnType, name, arguments);
    }

    public <T> Expression<T> function(String name, Class<T> returnType) {
        return new BasicFunctionExpression<T>(this, returnType, name);
    }

    public <N extends Number> Expression<N> abs(Expression<N> expression) {
        return new AbsFunction(this, expression);
    }

    public Expression<Double> sqrt(Expression<? extends Number> expression) {
        return new SqrtFunction(this, expression);
    }

    public Expression<Date> currentDate() {
        return new CurrentDateFunction(this);
    }

    public Expression<Timestamp> currentTimestamp() {
        return new CurrentTimestampFunction(this);
    }

    public Expression<Time> currentTime() {
        return new CurrentTimeFunction(this);
    }

    public Expression<String> substring(Expression<String> value, Expression<Integer> start) {
        return new SubstringFunction(this, value, start);
    }

    public Expression<String> substring(Expression<String> value, int start) {
        return new SubstringFunction(this, value, start);
    }

    public Expression<String> substring(Expression<String> value, Expression<Integer> start, Expression<Integer> length) {
        return new SubstringFunction(this, value, start, length);
    }

    public Expression<String> substring(Expression<String> value, int start, int length) {
        return new SubstringFunction(this, value, start, length);
    }

    public Expression<String> trim(Expression<String> trimSource) {
        return new TrimFunction(this, trimSource);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec trimspec, Expression<String> trimSource) {
        return new TrimFunction(this, trimspec, trimSource);
    }

    public Expression<String> trim(Expression<Character> trimCharacter, Expression<String> trimSource) {
        return new TrimFunction(this, trimCharacter, trimSource);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec trimspec, Expression<Character> trimCharacter, Expression<String> trimSource) {
        return new TrimFunction(this, trimspec, trimCharacter, trimSource);
    }

    public Expression<String> trim(char trimCharacter, Expression<String> trimSource) {
        return new TrimFunction(this, trimCharacter, trimSource);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec trimspec, char trimCharacter, Expression<String> trimSource) {
        return new TrimFunction(this, trimspec, trimCharacter, trimSource);
    }

    public Expression<String> lower(Expression<String> value) {
        return new LowerFunction(this, value);
    }

    public Expression<String> upper(Expression<String> value) {
        return new UpperFunction(this, value);
    }

    public Expression<Integer> length(Expression<String> value) {
        return new LengthFunction(this, value);
    }

    public Expression<Integer> locate(Expression<String> string, Expression<String> pattern) {
        return new LocateFunction(this, pattern, string);
    }

    public Expression<Integer> locate(Expression<String> string, Expression<String> pattern, Expression<Integer> start) {
        return new LocateFunction(this, pattern, string, start);
    }

    public Expression<Integer> locate(Expression<String> string, String pattern) {
        return new LocateFunction(this, pattern, string);
    }

    public Expression<Integer> locate(Expression<String> string, String pattern, int start) {
        return new LocateFunction(this, pattern, string, start);
    }

    public <N extends Number> Expression<N> neg(Expression<N> expression) {
        return new UnaryArithmeticOperation<N>(this, UnaryArithmeticOperation.Operation.UNARY_MINUS, expression);
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> expression1, Expression<? extends N> expression2) {
        if (expression1 == null || expression2 == null) {
            throw new IllegalArgumentException("arguments to sum() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(expression1.getJavaType(), expression2.getJavaType());
        return new BinaryArithmeticOperation<N>(this, resultType, BinaryArithmeticOperation.Operation.ADD, expression1, expression2);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> expression1, Expression<? extends N> expression2) {
        if (expression1 == null || expression2 == null) {
            throw new IllegalArgumentException("arguments to prod() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(expression1.getJavaType(), expression2.getJavaType());
        return new BinaryArithmeticOperation<N>(this, resultType, BinaryArithmeticOperation.Operation.MULTIPLY, expression1, expression2);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> expression1, Expression<? extends N> expression2) {
        if (expression1 == null || expression2 == null) {
            throw new IllegalArgumentException("arguments to diff() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(expression1.getJavaType(), expression2.getJavaType());
        return new BinaryArithmeticOperation<N>(this, resultType, BinaryArithmeticOperation.Operation.SUBTRACT, expression1, expression2);
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> expression, N n) {
        if (expression == null || n == null) {
            throw new IllegalArgumentException("arguments to sum() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(expression.getJavaType(), n.getClass());
        return new BinaryArithmeticOperation<N>(this, resultType, BinaryArithmeticOperation.Operation.ADD, expression, n);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> expression, N n) {
        if (expression == null || n == null) {
            throw new IllegalArgumentException("arguments to prod() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(expression.getJavaType(), n.getClass());
        return new BinaryArithmeticOperation<N>(this, resultType, BinaryArithmeticOperation.Operation.MULTIPLY, expression, n);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> expression, N n) {
        if (expression == null || n == null) {
            throw new IllegalArgumentException("arguments to diff() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(expression.getJavaType(), n.getClass());
        return new BinaryArithmeticOperation<N>(this, resultType, BinaryArithmeticOperation.Operation.SUBTRACT, expression, n);
    }

    public <N extends Number> Expression<N> sum(N n, Expression<? extends N> expression) {
        if (expression == null || n == null) {
            throw new IllegalArgumentException("arguments to sum() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(n.getClass(), expression.getJavaType());
        return new BinaryArithmeticOperation<N>(this, resultType, BinaryArithmeticOperation.Operation.ADD, n, expression);
    }

    public <N extends Number> Expression<N> prod(N n, Expression<? extends N> expression) {
        if (n == null || expression == null) {
            throw new IllegalArgumentException("arguments to prod() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(n.getClass(), expression.getJavaType());
        return new BinaryArithmeticOperation<N>(this, resultType, BinaryArithmeticOperation.Operation.MULTIPLY, n, expression);
    }

    public <N extends Number> Expression<N> diff(N n, Expression<? extends N> expression) {
        if (n == null || expression == null) {
            throw new IllegalArgumentException("arguments to diff() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(n.getClass(), expression.getJavaType());
        return new BinaryArithmeticOperation<N>(this, resultType, BinaryArithmeticOperation.Operation.SUBTRACT, n, expression);
    }

    public Expression<Number> quot(Expression<? extends Number> expression1, Expression<? extends Number> expression2) {
        if (expression1 == null || expression2 == null) {
            throw new IllegalArgumentException("arguments to quot() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(expression1.getJavaType(), expression2.getJavaType(), true);
        return new BinaryArithmeticOperation<Number>(this, resultType, BinaryArithmeticOperation.Operation.DIVIDE, (Number)expression1, (Expression<Number>)expression2);
    }

    public Expression<Number> quot(Expression<? extends Number> expression, Number number) {
        if (expression == null || number == null) {
            throw new IllegalArgumentException("arguments to quot() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(expression.getJavaType(), number.getClass(), true);
        return new BinaryArithmeticOperation<Number>(this, resultType, BinaryArithmeticOperation.Operation.DIVIDE, expression, number);
    }

    public Expression<Number> quot(Number number, Expression<? extends Number> expression) {
        if (expression == null || number == null) {
            throw new IllegalArgumentException("arguments to quot() cannot be null");
        }
        Class<Number> resultType = BinaryArithmeticOperation.determineResultType(number.getClass(), expression.getJavaType(), true);
        return new BinaryArithmeticOperation<Number>(this, resultType, BinaryArithmeticOperation.Operation.DIVIDE, number, expression);
    }

    public Expression<Integer> mod(Expression<Integer> expression1, Expression<Integer> expression2) {
        if (expression1 == null || expression2 == null) {
            throw new IllegalArgumentException("arguments to mod() cannot be null");
        }
        return new BinaryArithmeticOperation<Integer>(this, Integer.class, BinaryArithmeticOperation.Operation.MOD, (Integer)expression1, expression2);
    }

    public Expression<Integer> mod(Expression<Integer> expression, Integer integer) {
        if (expression == null || integer == null) {
            throw new IllegalArgumentException("arguments to mod() cannot be null");
        }
        return new BinaryArithmeticOperation<Integer>(this, Integer.class, BinaryArithmeticOperation.Operation.MOD, expression, integer);
    }

    public Expression<Integer> mod(Integer integer, Expression<Integer> expression) {
        if (integer == null || expression == null) {
            throw new IllegalArgumentException("arguments to mod() cannot be null");
        }
        return new BinaryArithmeticOperation<Integer>(this, Integer.class, BinaryArithmeticOperation.Operation.MOD, integer, expression);
    }

    public ExpressionImplementor<Long> toLong(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asLong();
    }

    public ExpressionImplementor<Integer> toInteger(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asInteger();
    }

    public ExpressionImplementor<Float> toFloat(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asFloat();
    }

    public ExpressionImplementor<Double> toDouble(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asDouble();
    }

    public ExpressionImplementor<BigDecimal> toBigDecimal(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asBigDecimal();
    }

    public ExpressionImplementor<BigInteger> toBigInteger(Expression<? extends Number> expression) {
        return ((ExpressionImplementor)expression).asBigInteger();
    }

    public ExpressionImplementor<String> toString(Expression<Character> characterExpression) {
        return ((ExpressionImplementor)characterExpression).asString();
    }

    public Predicate exists(Subquery<?> subquery) {
        return new ExistsPredicate(this, subquery);
    }

    public <Y> Expression<Y> all(Subquery<Y> subquery) {
        return new SubqueryComparisonModifierExpression<Y>(this, subquery.getJavaType(), subquery, SubqueryComparisonModifierExpression.Modifier.ALL);
    }

    public <Y> Expression<Y> some(Subquery<Y> subquery) {
        return new SubqueryComparisonModifierExpression<Y>(this, subquery.getJavaType(), subquery, SubqueryComparisonModifierExpression.Modifier.SOME);
    }

    public <Y> Expression<Y> any(Subquery<Y> subquery) {
        return new SubqueryComparisonModifierExpression<Y>(this, subquery.getJavaType(), subquery, SubqueryComparisonModifierExpression.Modifier.ANY);
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> exp1, Expression<? extends Y> exp2) {
        return this.coalesce((Class<Y>)null, exp1, (Y)exp2);
    }

    public <Y> Expression<Y> coalesce(Class<Y> type, Expression<? extends Y> exp1, Expression<? extends Y> exp2) {
        return new CoalesceExpression<Y>(this, type).value(exp1).value(exp2);
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> exp1, Y exp2) {
        return this.coalesce((Class)null, exp1, exp2);
    }

    public <Y> Expression<Y> coalesce(Class<Y> type, Expression<? extends Y> exp1, Y exp2) {
        return new CoalesceExpression<Y>(this, type).value(exp1).value(exp2);
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        return this.coalesce(null);
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce(Class<T> type) {
        return new CoalesceExpression<T>(this, type);
    }

    public Expression<String> concat(Expression<String> string1, Expression<String> string2) {
        return new ConcatExpression(this, string1, string2);
    }

    public Expression<String> concat(Expression<String> string1, String string2) {
        return new ConcatExpression(this, string1, string2);
    }

    public Expression<String> concat(String string1, Expression<String> string2) {
        return new ConcatExpression(this, string1, string2);
    }

    public <Y> Expression<Y> nullif(Expression<Y> exp1, Expression<?> exp2) {
        return this.nullif(null, exp1, (Y)exp2);
    }

    public <Y> Expression<Y> nullif(Class<Y> type, Expression<Y> exp1, Expression<?> exp2) {
        return new NullifExpression<Y>(this, type, exp1, exp2);
    }

    public <Y> Expression<Y> nullif(Expression<Y> exp1, Y exp2) {
        return this.nullif(null, exp1, exp2);
    }

    public <Y> Expression<Y> nullif(Class<Y> type, Expression<Y> exp1, Y exp2) {
        return new NullifExpression<Y>(this, type, exp1, exp2);
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(Expression<? extends C> expression) {
        return this.selectCase(null, expression);
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(Class<R> type, Expression<? extends C> expression) {
        return new SimpleCaseExpression<C, R>(this, type, expression);
    }

    public <R> CriteriaBuilder.Case<R> selectCase() {
        return this.selectCase((Class)null);
    }

    public <R> CriteriaBuilder.Case<R> selectCase(Class<R> type) {
        return new SearchedCaseExpression<R>(this, type);
    }

    public <C extends Collection<?>> Expression<Integer> size(C c) {
        int size = c == null ? 0 : c.size();
        return new LiteralExpression<Integer>(this, Integer.class, size);
    }

    public <C extends Collection<?>> Expression<Integer> size(Expression<C> exp) {
        if (LiteralExpression.class.isInstance(exp)) {
            return this.size((Collection)((LiteralExpression)exp).getLiteral());
        }
        if (PluralAttributePath.class.isInstance(exp)) {
            return new SizeOfCollectionExpression(this, (PluralAttributePath)exp);
        }
        throw new IllegalArgumentException("unknown collection expression type [" + exp.getClass().getName() + "]");
    }

    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        return new LiteralExpression<Collection<V>>(this, map.values());
    }

    public <K, M extends Map<K, ?>> Expression<Set<K>> keys(M map) {
        return new LiteralExpression<Set<K>>(this, map.keySet());
    }

    public <C extends Collection<?>> Predicate isEmpty(Expression<C> collectionExpression) {
        if (PluralAttributePath.class.isInstance(collectionExpression)) {
            return new IsEmptyPredicate(this, (PluralAttributePath)collectionExpression);
        }
        throw new IllegalArgumentException("unknown collection expression type [" + collectionExpression.getClass().getName() + "]");
    }

    public <C extends Collection<?>> Predicate isNotEmpty(Expression<C> collectionExpression) {
        return this.isEmpty(collectionExpression).not();
    }

    public <E, C extends Collection<E>> Predicate isMember(E e, Expression<C> collectionExpression) {
        if (!PluralAttributePath.class.isInstance(collectionExpression)) {
            throw new IllegalArgumentException("unknown collection expression type [" + collectionExpression.getClass().getName() + "]");
        }
        return new MemberOfPredicate(this, e, (PluralAttributePath)collectionExpression);
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E e, Expression<C> cExpression) {
        return this.isMember(e, cExpression).not();
    }

    public <E, C extends Collection<E>> Predicate isMember(Expression<E> elementExpression, Expression<C> collectionExpression) {
        if (!PluralAttributePath.class.isInstance(collectionExpression)) {
            throw new IllegalArgumentException("unknown collection expression type [" + collectionExpression.getClass().getName() + "]");
        }
        return new MemberOfPredicate(this, elementExpression, (PluralAttributePath)collectionExpression);
    }

    public <E, C extends Collection<E>> Predicate isNotMember(Expression<E> eExpression, Expression<C> cExpression) {
        return this.isMember(eExpression, cExpression).not();
    }
}

