/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.core.nodes;

import java.util.ArrayList;
import org.apache.lucene.messages.Message;
import org.apache.lucene.messages.MessageImpl;
import org.apache.lucene.queryParser.core.QueryNodeError;
import org.apache.lucene.queryParser.core.messages.QueryParserMessages;
import org.apache.lucene.queryParser.core.nodes.BooleanQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNodeImpl;
import org.apache.lucene.queryParser.core.parser.EscapeQuerySyntax;

public class ModifierQueryNode
extends QueryNodeImpl {
    private static final long serialVersionUID = -391209837953928169L;
    private Modifier modifier = Modifier.MOD_NONE;

    public ModifierQueryNode(QueryNode query, Modifier mod) {
        if (query == null) {
            throw new QueryNodeError((Message)new MessageImpl(QueryParserMessages.PARAMETER_VALUE_NOT_SUPPORTED, new Object[]{"query", "null"}));
        }
        this.allocate();
        this.setLeaf(false);
        this.add(query);
        this.modifier = mod;
    }

    public QueryNode getChild() {
        return this.getChildren().get(0);
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public String toString() {
        return "<modifier operation='" + this.modifier.toString() + "'>" + "\n" + ((Object)this.getChild()).toString() + "\n</modifier>";
    }

    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        if (this.getChild() == null) {
            return "";
        }
        String leftParenthensis = "";
        String rightParenthensis = "";
        if (this.getChild() != null && this.getChild() instanceof ModifierQueryNode) {
            leftParenthensis = "(";
            rightParenthensis = ")";
        }
        if (this.getChild() instanceof BooleanQueryNode) {
            return this.modifier.toLargeString() + leftParenthensis + this.getChild().toQueryString(escapeSyntaxParser) + rightParenthensis;
        }
        return this.modifier.toDigitString() + leftParenthensis + this.getChild().toQueryString(escapeSyntaxParser) + rightParenthensis;
    }

    public QueryNode cloneTree() throws CloneNotSupportedException {
        ModifierQueryNode clone = (ModifierQueryNode)super.cloneTree();
        clone.modifier = this.modifier;
        return clone;
    }

    public void setChild(QueryNode child) {
        ArrayList<QueryNode> list = new ArrayList<QueryNode>();
        list.add(child);
        this.set(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Modifier {
        MOD_NONE,
        MOD_NOT,
        MOD_REQ;


        public String toString() {
            switch (this) {
                case MOD_NONE: {
                    return "MOD_NONE";
                }
                case MOD_NOT: {
                    return "MOD_NOT";
                }
                case MOD_REQ: {
                    return "MOD_REQ";
                }
            }
            return "MOD_DEFAULT";
        }

        public String toDigitString() {
            switch (this) {
                case MOD_NONE: {
                    return "";
                }
                case MOD_NOT: {
                    return "-";
                }
                case MOD_REQ: {
                    return "+";
                }
            }
            return "";
        }

        public String toLargeString() {
            switch (this) {
                case MOD_NONE: {
                    return "";
                }
                case MOD_NOT: {
                    return "NOT ";
                }
                case MOD_REQ: {
                    return "+";
                }
            }
            return "";
        }
    }
}

