/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard;

import java.text.Collator;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.QueryParserHelper;
import org.apache.lucene.queryParser.standard.builders.StandardQueryTreeBuilder;
import org.apache.lucene.queryParser.standard.config.AllowLeadingWildcardAttribute;
import org.apache.lucene.queryParser.standard.config.AnalyzerAttribute;
import org.apache.lucene.queryParser.standard.config.DateResolutionAttribute;
import org.apache.lucene.queryParser.standard.config.DefaultOperatorAttribute;
import org.apache.lucene.queryParser.standard.config.DefaultPhraseSlopAttribute;
import org.apache.lucene.queryParser.standard.config.FieldBoostMapAttribute;
import org.apache.lucene.queryParser.standard.config.FieldDateResolutionMapAttribute;
import org.apache.lucene.queryParser.standard.config.FuzzyAttribute;
import org.apache.lucene.queryParser.standard.config.FuzzyConfig;
import org.apache.lucene.queryParser.standard.config.LocaleAttribute;
import org.apache.lucene.queryParser.standard.config.LowercaseExpandedTermsAttribute;
import org.apache.lucene.queryParser.standard.config.MultiFieldAttribute;
import org.apache.lucene.queryParser.standard.config.MultiTermRewriteMethodAttribute;
import org.apache.lucene.queryParser.standard.config.NumericConfig;
import org.apache.lucene.queryParser.standard.config.PositionIncrementsAttribute;
import org.apache.lucene.queryParser.standard.config.RangeCollatorAttribute;
import org.apache.lucene.queryParser.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryParser.standard.parser.StandardSyntaxParser;
import org.apache.lucene.queryParser.standard.processors.StandardQueryNodeProcessorPipeline;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardQueryParser
extends QueryParserHelper {
    public StandardQueryParser() {
        super(new StandardQueryConfigHandler(), new StandardSyntaxParser(), new StandardQueryNodeProcessorPipeline(null), new StandardQueryTreeBuilder());
    }

    public StandardQueryParser(Analyzer analyzer) {
        this();
        this.setAnalyzer(analyzer);
    }

    public String toString() {
        return "<StandardQueryParser config=\"" + (Object)((Object)this.getQueryConfigHandler()) + "\"/>";
    }

    public Query parse(String query, String defaultField) throws QueryNodeException {
        return (Query)super.parse(query, defaultField);
    }

    public StandardQueryConfigHandler.Operator getDefaultOperator() {
        return this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.DEFAULT_OPERATOR);
    }

    public void setRangeCollator(Collator collator) {
        RangeCollatorAttribute attr = (RangeCollatorAttribute)this.getQueryConfigHandler().getAttribute(RangeCollatorAttribute.class);
        attr.setDateResolution(collator);
    }

    public Collator getRangeCollator() {
        return this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.RANGE_COLLATOR);
    }

    @Deprecated
    public void setDefaultOperator(DefaultOperatorAttribute.Operator operator) {
        DefaultOperatorAttribute attr = (DefaultOperatorAttribute)this.getQueryConfigHandler().getAttribute(DefaultOperatorAttribute.class);
        attr.setOperator(operator);
    }

    public void setDefaultOperator(StandardQueryConfigHandler.Operator operator) {
        DefaultOperatorAttribute.Operator attrOperator = operator == StandardQueryConfigHandler.Operator.AND ? DefaultOperatorAttribute.Operator.AND : DefaultOperatorAttribute.Operator.OR;
        this.setDefaultOperator(attrOperator);
    }

    public void setLowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
        LowercaseExpandedTermsAttribute attr = (LowercaseExpandedTermsAttribute)this.getQueryConfigHandler().getAttribute(LowercaseExpandedTermsAttribute.class);
        attr.setLowercaseExpandedTerms(lowercaseExpandedTerms);
    }

    public boolean getLowercaseExpandedTerms() {
        Boolean lowercaseExpandedTerms = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.LOWERCASE_EXPANDED_TERMS);
        if (lowercaseExpandedTerms == null) {
            return true;
        }
        return lowercaseExpandedTerms;
    }

    public void setAllowLeadingWildcard(boolean allowLeadingWildcard) {
        AllowLeadingWildcardAttribute attr = (AllowLeadingWildcardAttribute)this.getQueryConfigHandler().getAttribute(AllowLeadingWildcardAttribute.class);
        attr.setAllowLeadingWildcard(allowLeadingWildcard);
    }

    public void setEnablePositionIncrements(boolean enabled) {
        PositionIncrementsAttribute attr = (PositionIncrementsAttribute)this.getQueryConfigHandler().getAttribute(PositionIncrementsAttribute.class);
        attr.setPositionIncrementsEnabled(enabled);
    }

    public boolean getEnablePositionIncrements() {
        Boolean enablePositionsIncrements = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ENABLE_POSITION_INCREMENTS);
        if (enablePositionsIncrements == null) {
            return false;
        }
        return enablePositionsIncrements;
    }

    public void setMultiTermRewriteMethod(MultiTermQuery.RewriteMethod method) {
        MultiTermRewriteMethodAttribute attr = (MultiTermRewriteMethodAttribute)this.getQueryConfigHandler().getAttribute(MultiTermRewriteMethodAttribute.class);
        attr.setMultiTermRewriteMethod(method);
    }

    public MultiTermQuery.RewriteMethod getMultiTermRewriteMethod() {
        return this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.MULTI_TERM_REWRITE_METHOD);
    }

    public void setMultiFields(CharSequence[] fields) {
        if (fields == null) {
            fields = new CharSequence[]{};
        }
        MultiFieldAttribute attr = this.getQueryConfigHandler().addAttribute(MultiFieldAttribute.class);
        attr.setFields(fields);
    }

    public void getMultiFields(CharSequence[] fields) {
        this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.MULTI_FIELDS);
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        FuzzyAttribute attr = this.getQueryConfigHandler().addAttribute(FuzzyAttribute.class);
        attr.setPrefixLength(fuzzyPrefixLength);
    }

    public void setNumericConfigMap(Map<String, NumericConfig> numericConfigMap) {
        this.getQueryConfigHandler().set(StandardQueryConfigHandler.ConfigurationKeys.NUMERIC_CONFIG_MAP, numericConfigMap);
    }

    public Map<String, NumericConfig> getNumericConfigMap() {
        return this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.NUMERIC_CONFIG_MAP);
    }

    public void setLocale(Locale locale) {
        LocaleAttribute attr = this.getQueryConfigHandler().addAttribute(LocaleAttribute.class);
        attr.setLocale(locale);
    }

    public Locale getLocale() {
        return this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.LOCALE);
    }

    @Deprecated
    public void setDefaultPhraseSlop(int defaultPhraseSlop) {
        this.setPhraseSlop(defaultPhraseSlop);
    }

    public void setPhraseSlop(int defaultPhraseSlop) {
        DefaultPhraseSlopAttribute attr = this.getQueryConfigHandler().addAttribute(DefaultPhraseSlopAttribute.class);
        attr.setDefaultPhraseSlop(defaultPhraseSlop);
    }

    public void setAnalyzer(Analyzer analyzer) {
        AnalyzerAttribute attr = (AnalyzerAttribute)this.getQueryConfigHandler().getAttribute(AnalyzerAttribute.class);
        attr.setAnalyzer(analyzer);
    }

    public Analyzer getAnalyzer() {
        return this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ANALYZER);
    }

    public boolean getAllowLeadingWildcard() {
        Boolean allowLeadingWildcard = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ALLOW_LEADING_WILDCARD);
        if (allowLeadingWildcard == null) {
            return false;
        }
        return allowLeadingWildcard;
    }

    public float getFuzzyMinSim() {
        FuzzyConfig fuzzyConfig = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.FUZZY_CONFIG);
        if (fuzzyConfig == null) {
            return 0.5f;
        }
        return fuzzyConfig.getMinSimilarity();
    }

    public int getFuzzyPrefixLength() {
        FuzzyConfig fuzzyConfig = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.FUZZY_CONFIG);
        if (fuzzyConfig == null) {
            return 0;
        }
        return fuzzyConfig.getPrefixLength();
    }

    public int getPhraseSlop() {
        Integer phraseSlop = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.PHRASE_SLOP);
        if (phraseSlop == null) {
            return 0;
        }
        return phraseSlop;
    }

    public void setFuzzyMinSim(float fuzzyMinSim) {
        FuzzyAttribute attr = this.getQueryConfigHandler().addAttribute(FuzzyAttribute.class);
        attr.setFuzzyMinSimilarity(fuzzyMinSim);
    }

    public void setFieldsBoost(Map<String, Float> boosts) {
        FieldBoostMapAttribute attr = this.getQueryConfigHandler().addAttribute(FieldBoostMapAttribute.class);
        attr.setFieldBoostMap(boosts);
    }

    public Map<String, Float> getFieldsBoost() {
        return this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.FIELD_BOOST_MAP);
    }

    public void setDateResolution(DateTools.Resolution dateResolution) {
        DateResolutionAttribute attr = this.getQueryConfigHandler().addAttribute(DateResolutionAttribute.class);
        attr.setDateResolution(dateResolution);
    }

    public DateTools.Resolution getDateResolution() {
        return this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.DATE_RESOLUTION);
    }

    @Deprecated
    public void setDateResolution(Map<CharSequence, DateTools.Resolution> dateRes) {
        this.setDateResolutionMap(dateRes);
    }

    public Map<CharSequence, DateTools.Resolution> getDateResolutionMap() {
        return this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.FIELD_DATE_RESOLUTION_MAP);
    }

    public void setDateResolutionMap(Map<CharSequence, DateTools.Resolution> dateRes) {
        FieldDateResolutionMapAttribute attr = this.getQueryConfigHandler().addAttribute(FieldDateResolutionMapAttribute.class);
        attr.setFieldDateResolutionMap(dateRes);
    }
}

