/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.nodes;

import java.util.List;
import org.apache.lucene.queryParser.core.nodes.FieldableNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNodeImpl;
import org.apache.lucene.queryParser.core.parser.EscapeQuerySyntax;

public class MultiPhraseQueryNode
extends QueryNodeImpl
implements FieldableNode {
    private static final long serialVersionUID = -2138501723963320158L;

    public MultiPhraseQueryNode() {
        this.setLeaf(false);
        this.allocate();
    }

    public String toString() {
        if (this.getChildren() == null || this.getChildren().size() == 0) {
            return "<multiPhrase/>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<multiPhrase>");
        for (QueryNode child : this.getChildren()) {
            sb.append("\n");
            sb.append(((Object)child).toString());
        }
        sb.append("\n</multiPhrase>");
        return sb.toString();
    }

    public CharSequence toQueryString(EscapeQuerySyntax escapeSyntaxParser) {
        if (this.getChildren() == null || this.getChildren().size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String filler = "";
        for (QueryNode child : this.getChildren()) {
            sb.append(filler).append(child.toQueryString(escapeSyntaxParser));
            filler = ",";
        }
        return "[MTP[" + sb.toString() + "]]";
    }

    public QueryNode cloneTree() throws CloneNotSupportedException {
        MultiPhraseQueryNode clone = (MultiPhraseQueryNode)super.cloneTree();
        return clone;
    }

    public CharSequence getField() {
        List<QueryNode> children = this.getChildren();
        if (children == null || children.size() == 0) {
            return null;
        }
        return ((FieldableNode)children.get(0)).getField();
    }

    public void setField(CharSequence fieldName) {
        List<QueryNode> children = this.getChildren();
        if (children != null) {
            for (QueryNode child : children) {
                if (!(child instanceof FieldableNode)) continue;
                ((FieldableNode)child).setField(fieldName);
            }
        }
    }
}

