/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;
import org.gcube.contentmanagement.blobstorage.service.impl.RemoteResource;
import org.gcube.contentmanagement.blobstorage.service.impl.Resource;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;

public class LocalResource
extends Resource {
    public LocalResource(MyFile file, ServiceEngine engine) {
        super(file, engine);
    }

    public RemoteResource LFile(String path) {
        if (this.getMyFile() != null) {
            this.getMyFile().setLocalPath(path);
        } else {
            this.setMyFile(this.setGenericProperties("", "", path, "local"));
            this.getMyFile().setLocalPath(path);
        }
        this.getMyFile().setLocalResource(OperationDefinition.LOCAL_RESOURCE.PATH);
        return new RemoteResource(this.getMyFile(), this.getEngine());
    }

    public RemoteResource LFile(InputStream is) {
        if (this.getMyFile() != null) {
            this.getMyFile().setInputStream(is);
        } else {
            this.setMyFile(new MyFile(this.engine.getGcubeMemoryType()));
            this.getMyFile().setInputStream(is);
        }
        this.getMyFile().setLocalResource(OperationDefinition.LOCAL_RESOURCE.INPUT_STREAM);
        return new RemoteResource(this.getMyFile(), this.getEngine());
    }

    public RemoteResource LFile(OutputStream os) {
        if (this.getMyFile() != null) {
            this.getMyFile().setOutputStream(os);
        } else {
            this.setMyFile(new MyFile(this.engine.getGcubeMemoryType()));
            this.getMyFile().setOutputStream(os);
        }
        this.getMyFile().setLocalResource(OperationDefinition.LOCAL_RESOURCE.OUTPUT_STREAM);
        return new RemoteResource(this.getMyFile(), this.getEngine());
    }

    public InputStream RFileAsInputStream(String path) {
        this.file = this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setRemotePath(path);
        this.file.setOwner(this.engine.owner);
        this.file.setType("input");
        this.file.setLocalResource(OperationDefinition.LOCAL_RESOURCE.VOID);
        this.file.setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH_FOR_INPUT_STREAM);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        this.retrieveRemoteObject(this.engine.primaryBackend);
        if (this.file.getInputStream() != null) {
            InputStream is = this.file.getInputStream();
            this.file.setInputStream(null);
            return is;
        }
        this.retrieveRemoteObject(this.engine.volatileBackend);
        InputStream is = this.file.getInputStream();
        this.file.setInputStream(null);
        return is;
    }

    @Deprecated
    public InputStream RFileAStream(String path) {
        this.file = this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setRemotePath(path);
        this.file.setOwner(this.engine.owner);
        this.file.setType("input");
        this.file.setLocalResource(OperationDefinition.LOCAL_RESOURCE.VOID);
        this.file.setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH_FOR_INPUT_STREAM);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        this.retrieveRemoteObject(this.engine.primaryBackend);
        if (this.file.getInputStream() != null) {
            InputStream is = this.file.getInputStream();
            this.file.setInputStream(null);
            return is;
        }
        this.retrieveRemoteObject(this.engine.volatileBackend);
        InputStream is = this.file.getInputStream();
        this.file.setInputStream(null);
        return is;
    }

    public OutputStream RFileAsOutputStream(String path) {
        this.file = this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setRemotePath(path);
        this.file.setOwner(this.engine.owner);
        this.file.setType("output");
        this.file.setLocalResource(OperationDefinition.LOCAL_RESOURCE.VOID);
        this.file.setRemoteResource(OperationDefinition.REMOTE_RESOURCE.PATH_FOR_OUTPUTSTREAM);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        this.retrieveRemoteObject(this.engine.primaryBackend);
        OutputStream os = this.file.getOutputStream();
        this.file.setOutputStream(null);
        return os;
    }

    private void retrieveRemoteObject(String[] backend) {
        try {
            if (this.file.getInputStream() != null || this.file.getOutputStream() != null || this.file.getLocalPath() != null || this.file.getRemotePath() != null) {
                this.engine.service.startOperation(this.file, this.file.getRemotePath(), this.engine.owner, backend, false, this.engine.getContext(), this.engine.isReplaceOption());
            } else {
                this.logger.error("parameters incompatible ");
            }
        }
        catch (Exception e) {
            this.logger.error("get()", (Throwable)e);
        }
    }
}

