/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.home;

import java.util.List;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.data.ApplicationsArea;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.data.JCRApplicationsArea;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRHome
implements Home {
    private final HomeManager homeManager;
    private final JCRUser owner;
    private final JCRRepository repository;
    private final JCRWorkspace workspace;
    private JCRApplicationsArea applicationArea;

    public JCRHome(HomeManager homeManager, JCRUser user) throws Exception {
        this.owner = user;
        this.homeManager = homeManager;
        this.repository = new JCRRepository(user);
        this.workspace = new JCRWorkspace(this, this.repository);
    }

    public HomeManager getHomeManager() {
        return this.homeManager;
    }

    public User getOwner() {
        return this.owner;
    }

    public Workspace getWorkspace() throws WorkspaceFolderNotFoundException, InternalErrorException {
        return this.workspace;
    }

    public ApplicationsArea getDataArea() throws InternalErrorException {
        if (this.applicationArea == null) {
            this.applicationArea = new JCRApplicationsArea(this.workspace);
        }
        return this.applicationArea;
    }

    public List<String> listScopes() throws InternalErrorException {
        try {
            return this.repository.listScopes();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }
}

