/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.search.index;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import gr.uoa.di.madgik.rr.element.search.index.SruConsumerDao;
import gr.uoa.di.madgik.rr.element.search.index.SruConsumerService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SruConsumer
extends DataSource {
    private static final Logger logger = LoggerFactory.getLogger(SruConsumer.class);

    public SruConsumer() throws ResourceRegistryException {
        super(SruConsumerDao.class, SruConsumerService.class);
        super.setType(DataSource.Type.SruConsumer);
    }

    @Override
    public String deepToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("SruConsumer - ID : " + this.getID() + "\n");
        buf.append("SruConsumer - Functionality : " + this.getFunctionality() + "\n");
        buf.append("SruConsumer - Scopes : ");
        for (String string : this.getScopes()) {
            buf.append(string + " ");
        }
        buf.append("\nSruConsumer - Capabilities : ");
        for (String string : this.getCapabilities()) {
            buf.append(string + " ");
        }
        buf.append("\nSruConsumer - Fields : \n");
        for (FieldIndexContainer fieldIndexContainer : this.getFieldInfo()) {
            buf.append(fieldIndexContainer.deepToString() + "\n");
        }
        return buf.toString();
    }

    @Override
    public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.exists(SruConsumerDao.class, persistencyType);
    }

    public static List<DataSource> getAll(boolean loadDetails) throws ResourceRegistryException {
        return DataSource.getAll(SruConsumerDao.class, RRContext.DatastoreType.LOCAL, loadDetails);
    }

    public static List<DataSource> getAll(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return DataSource.getAll(SruConsumerDao.class, persistencyType, loadDetails);
    }

    @Override
    public List<DataSourceService> getDataSourceServices() throws ResourceRegistryException {
        if (this.boundDataSourceServices == null) {
            if (this.item.getBoundDataSourceServices() != null) {
                logger.info("item.getBoundDataSourceServices : " + this.item.getBoundDataSourceServices());
                ArrayList<DataSourceService> ret = new ArrayList<DataSourceService>();
                for (String ds : this.item.getBoundDataSourceServices()) {
                    DataSourceService s = SruConsumerService.getById(true, ds);
                    if (s != null) {
                        ret.add(s);
                        continue;
                    }
                    logger.warn("Could not find bound sru datasource service with id " + ds);
                    List<DataSourceService> services = SruConsumerService.getAll(true);
                    logger.warn("all datasource ids are : ");
                    for (DataSourceService service : services) {
                        logger.warn(" ~> service id : " + service.getID());
                    }
                }
                this.boundDataSourceServices = ret;
                return ret;
            }
            return SruConsumerService.getAll(true);
        }
        return this.boundDataSourceServices;
    }

    public static DataSource getById(boolean loadDetails, String id) throws ResourceRegistryException {
        SruConsumer f = new SruConsumer();
        f.setID(id);
        return f.load(loadDetails) ? f : null;
    }
}

