/*
 * Decompiled with CFR 0.152.
 */
package search.library.util.cql.parser;

import search.library.util.cql.parser.SimpleNode;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLFuseNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.GCQLSortNode;
import search.library.util.cql.query.tree.GCQLTermNode;

public class PrintJJTree {
    public static void main(String[] args) {
        String TESTQUERY1 = "((((author any \"Joe\") and (title proximity \" invorves \")) not (gDocCollectionLang == \"fr\")) or ((gDocCollectionID == \"A\") and ((title any \"Will\") or (author any \"Norm\"))))";
        String TESTQUERY2 = "((geo geosearch \"11 7 20 100\") and ((type exact \"new\") and ((geo geosearch \"-2 -6 8 4\") and ((gDocCollectionLang == \"en\") and (((desc any \"new\") and (gDocCollectionID == \"C\")) or ((abstract exact \"new\") and ((spec any \"new\") or (tech any \"new\"))))))))";
        String q = "((ac6e40cd-f6b7-4e5e-a199-30e3944064e3 = tuna) and (((gDocCollectionID == 8b554f50-9add-11e2-91cf-988c12b92fe5) or (gDocCollectionID == d686c177-8d4c-4947-b85a-f6e8ef65620e)))) project * fuse tuna";
        q = "((gDocCollectionID == \"faoAutocompleteCollection\") and ((label = \"Bullis Jr., H.R.\") and (label = \u0633\u0645\u0643))) project gDocCollectionID gDocCollectionLang label type";
        GCQLNode head = GCQLQueryTreeManager.parseGCQLString(q);
        GCQLQueryTreeManager.printTreeSerialization(head);
        System.out.println(head.toCQL());
        System.out.println(PrintJJTree.excludeCollectionClause(head).toCQL());
    }

    private static String getRankMode(GCQLNode head) {
        if (head instanceof GCQLFuseNode) {
            String rankMode = ((GCQLFuseNode)head).getFuseMode().toCQL();
            head = ((GCQLFuseNode)head).subtree;
            return rankMode;
        }
        if (head instanceof GCQLProjectNode) {
            return PrintJJTree.getRankMode(((GCQLProjectNode)head).subtree);
        }
        if (head instanceof GCQLSortNode) {
            return PrintJJTree.getRankMode(((GCQLSortNode)head).subtree);
        }
        return "no";
    }

    public static void printMyTree(SimpleNode node, int n) {
        int numChildren = node.jjtGetNumChildren();
        System.out.println();
        for (int i = 0; i < n; ++i) {
            System.out.print(" ");
        }
        System.out.println(node.toString() + " ***** " + node.getText());
        int k = n + 1;
        for (int i = 0; i < numChildren; ++i) {
            PrintJJTree.printMyTree((SimpleNode)node.jjtGetChild(i), k);
        }
    }

    public static GCQLNode excludeCollectionClause(GCQLNode head) {
        if (head instanceof GCQLProjectNode) {
            ((GCQLProjectNode)head).subtree = PrintJJTree.excludeCollectionClause(((GCQLProjectNode)head).subtree);
            return head;
        }
        if (head instanceof GCQLFuseNode) {
            ((GCQLFuseNode)head).subtree = PrintJJTree.excludeCollectionClause(((GCQLFuseNode)head).subtree);
            return head;
        }
        if (head instanceof GCQLSortNode) {
            ((GCQLSortNode)head).subtree = PrintJJTree.excludeCollectionClause(((GCQLSortNode)head).subtree);
            return head;
        }
        if (head instanceof GCQLAndNode) {
            ((GCQLAndNode)head).left = PrintJJTree.excludeCollectionClause(((GCQLAndNode)head).left);
            ((GCQLAndNode)head).right = PrintJJTree.excludeCollectionClause(((GCQLAndNode)head).right);
            GCQLNode left = ((GCQLAndNode)head).left;
            GCQLNode right = ((GCQLAndNode)head).right;
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            return head;
        }
        if (head instanceof GCQLOrNode) {
            ((GCQLOrNode)head).left = PrintJJTree.excludeCollectionClause(((GCQLOrNode)head).left);
            ((GCQLOrNode)head).right = PrintJJTree.excludeCollectionClause(((GCQLOrNode)head).right);
            GCQLNode left = ((GCQLOrNode)head).left;
            GCQLNode right = ((GCQLOrNode)head).right;
            if (left == null && right == null) {
                return null;
            }
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            return head;
        }
        if (head instanceof GCQLTermNode) {
            String index = ((GCQLTermNode)head).getIndex();
            if (index.equals("gDocCollectionID") || index.equals("gDocCollectionLang")) {
                return null;
            }
            return head;
        }
        return head;
    }
}

