/*
 * Decompiled with CFR 0.152.
 */
package search.library.util.cql.query.tree;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Vector;
import search.library.util.cql.parser.ParseException;
import search.library.util.cql.parser.SimpleNode;
import search.library.util.cql.parser.gCQLParser;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLBooleanNode;
import search.library.util.cql.query.tree.GCQLFuseNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLNotNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLPrefixNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLProxNode;
import search.library.util.cql.query.tree.GCQLRelation;
import search.library.util.cql.query.tree.GCQLSortNode;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.Modifier;
import search.library.util.cql.query.tree.ModifierSet;

public class GCQLQueryTreeManager {
    public static GCQLNode parseGCQLString(String gCQLStr) {
        gCQLParser parser = new gCQLParser(System.in);
        String newStr = "#" + gCQLStr + "#";
        InputStream is = GCQLQueryTreeManager.stringToStream(newStr);
        parser.ReInit(is);
        try {
            SimpleNode parseJJtree = parser.Start();
            GCQLNode gTree = GCQLQueryTreeManager.createCQLQueryTreeFromJJTree(parseJJtree);
            System.out.println(gTree.toCQL());
            return gTree;
        }
        catch (ParseException e) {
            System.out.println("-------------------------------");
            System.out.println("Sorry, couldn't parse that.");
            System.out.println(e.getMessage());
            System.out.println("-------------------------------");
            e.printStackTrace();
            return null;
        }
    }

    public static void printTreeSerialization(GCQLNode head) {
        head.printNode(0);
    }

    public static GCQLNode createCQLQueryTreeFromJJTree(SimpleNode simpleNode) {
        SimpleNode expressionNode = simpleNode;
        while (!expressionNode.toString().equals("gCQLQuery") && !expressionNode.toString().equals("CQLQuery")) {
            expressionNode = (SimpleNode)expressionNode.jjtGetChild(0);
        }
        GCQLSortNode sortNode = null;
        GCQLProjectNode projectNode = null;
        GCQLFuseNode fuseNode = null;
        GCQLPrefixNode prefixNode = null;
        int numChildren = expressionNode.jjtGetNumChildren();
        switch (numChildren) {
            case 0: {
                GCQLTermNode emptyTermNode = new GCQLTermNode();
                emptyTermNode.setTerm("");
                return emptyTermNode;
            }
            case 1: {
                SimpleNode scopedClauseNode = (SimpleNode)expressionNode.jjtGetChild(0);
                GCQLNode mainTree = GCQLQueryTreeManager.parseScopedClause(scopedClauseNode);
                return mainTree;
            }
            case 2: {
                SimpleNode scopedClauseNode = (SimpleNode)expressionNode.jjtGetChild(0);
                GCQLNode mainTree = GCQLQueryTreeManager.parseScopedClause(scopedClauseNode);
                SimpleNode extensionNode = (SimpleNode)expressionNode.jjtGetChild(1);
                if (extensionNode.toString().equals("SortSpec")) {
                    sortNode = new GCQLSortNode();
                    Vector<ModifierSet> sortIndexes = GCQLQueryTreeManager.parseExtensionNode(extensionNode);
                    sortNode.sortIndexes = sortIndexes;
                    sortNode.subtree = mainTree;
                    return sortNode;
                }
                if (extensionNode.toString().equals("ProjectSpec")) {
                    projectNode = new GCQLProjectNode();
                    Vector<ModifierSet> projectIndexes = GCQLQueryTreeManager.parseExtensionNode(extensionNode);
                    projectNode.projectIndexes = projectIndexes;
                    projectNode.subtree = mainTree;
                    return projectNode;
                }
                if (extensionNode.toString().equals("FuseSpec")) {
                    ModifierSet fuseMode;
                    fuseNode = new GCQLFuseNode();
                    fuseNode.fuseMode = fuseMode = GCQLQueryTreeManager.parseExtensionNode(extensionNode).firstElement();
                    fuseNode.subtree = mainTree;
                    return fuseNode;
                }
                SimpleNode cqlNode = (SimpleNode)expressionNode.jjtGetChild(1);
                extensionNode = (SimpleNode)expressionNode.jjtGetChild(0);
                mainTree = GCQLQueryTreeManager.createCQLQueryTreeFromJJTree(cqlNode);
                prefixNode = GCQLQueryTreeManager.parsePrefixNode(extensionNode, mainTree);
                return prefixNode;
            }
            case 3: {
                SimpleNode scopedClauseNode = (SimpleNode)expressionNode.jjtGetChild(0);
                GCQLNode mainTree = GCQLQueryTreeManager.parseScopedClause(scopedClauseNode);
                int firstChildType = 0;
                SimpleNode extensionNode1 = (SimpleNode)expressionNode.jjtGetChild(1);
                if (extensionNode1.toString().equals("SortSpec")) {
                    sortNode = new GCQLSortNode();
                    Vector<ModifierSet> sortIndexes = GCQLQueryTreeManager.parseExtensionNode(extensionNode1);
                    sortNode.sortIndexes = sortIndexes;
                    sortNode.subtree = mainTree;
                    firstChildType = 0;
                } else if (extensionNode1.toString().equals("ProjectSpec")) {
                    projectNode = new GCQLProjectNode();
                    Vector<ModifierSet> projectIndexes = GCQLQueryTreeManager.parseExtensionNode(extensionNode1);
                    projectNode.projectIndexes = projectIndexes;
                    projectNode.subtree = mainTree;
                    firstChildType = 1;
                } else if (extensionNode1.toString().equals("FuseSpec")) {
                    ModifierSet fuseMode;
                    fuseNode = new GCQLFuseNode();
                    fuseNode.fuseMode = fuseMode = GCQLQueryTreeManager.parseExtensionNode(extensionNode1).firstElement();
                    fuseNode.subtree = mainTree;
                    firstChildType = 2;
                }
                SimpleNode extensionNode2 = (SimpleNode)expressionNode.jjtGetChild(2);
                if (extensionNode2.toString().equals("SortSpec")) {
                    sortNode = new GCQLSortNode();
                    Vector<ModifierSet> sortIndexes = GCQLQueryTreeManager.parseExtensionNode(extensionNode2);
                    sortNode.sortIndexes = sortIndexes;
                    switch (firstChildType) {
                        case 1: {
                            sortNode.subtree = projectNode;
                            break;
                        }
                        case 2: {
                            sortNode.subtree = fuseNode;
                        }
                    }
                    return sortNode;
                }
                if (extensionNode2.toString().equals("ProjectSpec")) {
                    projectNode = new GCQLProjectNode();
                    Vector<ModifierSet> projectIndexes = GCQLQueryTreeManager.parseExtensionNode(extensionNode2);
                    projectNode.projectIndexes = projectIndexes;
                    switch (firstChildType) {
                        case 0: {
                            projectNode.subtree = sortNode;
                            break;
                        }
                        case 2: {
                            projectNode.subtree = fuseNode;
                        }
                    }
                    return projectNode;
                }
                if (extensionNode2.toString().equals("FuseSpec")) {
                    ModifierSet fuseMode;
                    fuseNode = new GCQLFuseNode();
                    fuseNode.fuseMode = fuseMode = GCQLQueryTreeManager.parseExtensionNode(extensionNode2).firstElement();
                    switch (firstChildType) {
                        case 0: {
                            fuseNode.subtree = sortNode;
                            break;
                        }
                        case 1: {
                            fuseNode.subtree = projectNode;
                        }
                    }
                    return fuseNode;
                }
            }
            case 4: {
                ModifierSet fuseMode;
                SimpleNode scopedClauseNode = (SimpleNode)expressionNode.jjtGetChild(0);
                GCQLNode mainTree = GCQLQueryTreeManager.parseScopedClause(scopedClauseNode);
                SimpleNode extensionSortNode = (SimpleNode)expressionNode.jjtGetChild(1);
                sortNode = new GCQLSortNode();
                Vector<ModifierSet> sortIndexes = GCQLQueryTreeManager.parseExtensionNode(extensionSortNode);
                sortNode.sortIndexes = sortIndexes;
                sortNode.subtree = mainTree;
                SimpleNode extensionProjectNode = (SimpleNode)expressionNode.jjtGetChild(2);
                projectNode = new GCQLProjectNode();
                Vector<ModifierSet> projectIndexes = GCQLQueryTreeManager.parseExtensionNode(extensionProjectNode);
                projectNode.projectIndexes = projectIndexes;
                projectNode.subtree = sortNode;
                SimpleNode extensionFuseNode = (SimpleNode)expressionNode.jjtGetChild(3);
                fuseNode = new GCQLFuseNode();
                fuseNode.fuseMode = fuseMode = GCQLQueryTreeManager.parseExtensionNode(extensionFuseNode).firstElement();
                fuseNode.subtree = projectNode;
                return fuseNode;
            }
        }
        return null;
    }

    private static Vector<ModifierSet> parseExtensionNode(SimpleNode extensionNode) {
        int numChildren = extensionNode.jjtGetNumChildren();
        Vector<ModifierSet> vector = new Vector<ModifierSet>();
        for (int i = 0; i < numChildren; ++i) {
            SimpleNode singleSpecNode = (SimpleNode)extensionNode.jjtGetChild(i);
            ModifierSet modSet = GCQLQueryTreeManager.parseSingleSpecNode(singleSpecNode);
            vector.add(modSet);
        }
        return vector;
    }

    private static GCQLPrefixNode parsePrefixNode(SimpleNode prefixNode, GCQLNode mainTree) {
        int numChildren = prefixNode.jjtGetNumChildren();
        if (numChildren == 2) {
            SimpleNode prefixNd = (SimpleNode)prefixNode.jjtGetChild(0);
            String prefix = prefixNd.getText();
            SimpleNode uriNd = (SimpleNode)prefixNode.jjtGetChild(1);
            String uri = uriNd.getText();
            GCQLPrefixNode toReturn = new GCQLPrefixNode(prefix, uri, mainTree);
            return toReturn;
        }
        SimpleNode uriNd = (SimpleNode)prefixNode.jjtGetChild(0);
        String uri = uriNd.getText();
        GCQLPrefixNode toReturn = new GCQLPrefixNode("gcube", uri, mainTree);
        return toReturn;
    }

    private static ModifierSet parseSingleSpecNode(SimpleNode singleSpecNode) {
        int numChildren = singleSpecNode.jjtGetNumChildren();
        switch (numChildren) {
            case 1: {
                SimpleNode indexNode = (SimpleNode)singleSpecNode.jjtGetChild(0);
                String indexName = indexNode.getText();
                ModifierSet modifierSet = new ModifierSet(indexName);
                return modifierSet;
            }
            case 2: {
                SimpleNode indexNode = (SimpleNode)singleSpecNode.jjtGetChild(0);
                String indexName = indexNode.getText();
                ModifierSet modifierSet = new ModifierSet(indexName);
                SimpleNode modifierListNode = (SimpleNode)singleSpecNode.jjtGetChild(1);
                ArrayList<Modifier> modifiers = GCQLQueryTreeManager.parseGCQLModifiersListNode(modifierListNode);
                modifierSet.setModifiers(modifiers);
                return modifierSet;
            }
        }
        return null;
    }

    private static GCQLNode parseScopedClause(SimpleNode scopedClauseNode) {
        int numChildren = scopedClauseNode.jjtGetNumChildren();
        switch (numChildren) {
            case 1: {
                SimpleNode searchClauseNode = (SimpleNode)scopedClauseNode.jjtGetChild(0);
                return GCQLQueryTreeManager.parseSearchClauseNode(searchClauseNode);
            }
            case 3: {
                SimpleNode firstSearchClauseNode = (SimpleNode)scopedClauseNode.jjtGetChild(0);
                GCQLNode firstSearchClause = GCQLQueryTreeManager.parseSearchClauseNode(firstSearchClauseNode);
                SimpleNode secondSearchClauseNode = (SimpleNode)scopedClauseNode.jjtGetChild(2);
                GCQLNode secondSearchClause = GCQLQueryTreeManager.parseSearchClauseNode(secondSearchClauseNode);
                SimpleNode booleanNode = (SimpleNode)scopedClauseNode.jjtGetChild(1);
                GCQLBooleanNode booleanClause = GCQLQueryTreeManager.parseBooleanGroupNode(booleanNode);
                booleanClause.left = firstSearchClause;
                booleanClause.right = secondSearchClause;
                return booleanClause;
            }
        }
        return null;
    }

    private static GCQLBooleanNode parseBooleanGroupNode(SimpleNode booleanGroupNode) {
        int numChildren = booleanGroupNode.jjtGetNumChildren();
        switch (numChildren) {
            case 1: {
                SimpleNode booleanOperator = (SimpleNode)booleanGroupNode.jjtGetChild(0);
                String booleanStr = booleanOperator.getText();
                if (booleanStr.equals("and")) {
                    GCQLAndNode andNode = new GCQLAndNode();
                    return andNode;
                }
                if (booleanStr.equals("or")) {
                    GCQLOrNode orNode = new GCQLOrNode();
                    return orNode;
                }
                if (booleanStr.equals("not")) {
                    GCQLNotNode notNode = new GCQLNotNode();
                    return notNode;
                }
                GCQLProxNode proxNode = new GCQLProxNode();
                return proxNode;
            }
            case 2: {
                SimpleNode modifiersNode = (SimpleNode)booleanGroupNode.jjtGetChild(1);
                ArrayList<Modifier> modifiers = GCQLQueryTreeManager.parseGCQLModifiersListNode(modifiersNode);
                SimpleNode booleanOperator = (SimpleNode)booleanGroupNode.jjtGetChild(0);
                String booleanStr = booleanOperator.getText();
                if (booleanStr.equals("and")) {
                    GCQLAndNode andNode = new GCQLAndNode();
                    ModifierSet modifSet = new ModifierSet("and");
                    modifSet.setModifiers(modifiers);
                    andNode.ms = modifSet;
                    return andNode;
                }
                if (booleanStr.equals("or")) {
                    GCQLOrNode orNode = new GCQLOrNode();
                    ModifierSet modifSet = new ModifierSet("or");
                    modifSet.setModifiers(modifiers);
                    orNode.ms = modifSet;
                    return orNode;
                }
                if (booleanStr.equals("not")) {
                    GCQLNotNode notNode = new GCQLNotNode();
                    ModifierSet modifSet = new ModifierSet("not");
                    modifSet.setModifiers(modifiers);
                    notNode.ms = modifSet;
                    return notNode;
                }
                GCQLProxNode proxNode = new GCQLProxNode();
                ModifierSet modifSet = new ModifierSet("prox");
                modifSet.setModifiers(modifiers);
                proxNode.ms = modifSet;
                return proxNode;
            }
        }
        return null;
    }

    private static GCQLNode parseSearchClauseNode(SimpleNode searchClauseNode) {
        GCQLTermNode termNode = new GCQLTermNode();
        int numChildren = searchClauseNode.jjtGetNumChildren();
        switch (numChildren) {
            case 1: {
                SimpleNode searchTerm = (SimpleNode)searchClauseNode.jjtGetChild(0);
                if (searchTerm.toString().equals("CQLQuery")) {
                    SimpleNode scopedClause = (SimpleNode)searchTerm.jjtGetChild(0);
                    return GCQLQueryTreeManager.parseScopedClause(scopedClause);
                }
                String searchTermStr = searchTerm.getText();
                termNode.setTerm(searchTermStr);
                return termNode;
            }
            case 3: {
                termNode = new GCQLTermNode();
                SimpleNode tempNode = (SimpleNode)searchClauseNode.jjtGetChild(0);
                String index = tempNode.getText();
                termNode.setIndex(index);
                tempNode = (SimpleNode)searchClauseNode.jjtGetChild(1);
                GCQLRelation relation = GCQLQueryTreeManager.parseGCQLRelationNode(tempNode);
                termNode.setRelation(relation);
                SimpleNode searchTerm = (SimpleNode)searchClauseNode.jjtGetChild(2);
                String searchTermStr = searchTerm.getText();
                termNode.setTerm(searchTermStr);
                return termNode;
            }
        }
        return null;
    }

    static GCQLRelation parseGCQLRelationNode(SimpleNode relNode) {
        GCQLRelation rel = new GCQLRelation();
        int numChildren = relNode.jjtGetNumChildren();
        switch (numChildren) {
            case 1: {
                SimpleNode comparitor = (SimpleNode)relNode.jjtGetChild(0);
                String relBase = comparitor.getText();
                rel.setBase(relBase);
                return rel;
            }
            case 2: {
                SimpleNode comparitor = (SimpleNode)relNode.jjtGetChild(0);
                String relBase = comparitor.getText();
                rel.setBase(relBase);
                SimpleNode modifiersList = (SimpleNode)relNode.jjtGetChild(1);
                ArrayList<Modifier> modifiers = GCQLQueryTreeManager.parseGCQLModifiersListNode(modifiersList);
                rel.setModifiers(modifiers);
                return rel;
            }
        }
        return null;
    }

    static ArrayList<Modifier> parseGCQLModifiersListNode(SimpleNode modifiersListNode) {
        int numModifiers = modifiersListNode.jjtGetNumChildren();
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        for (int i = 0; i < numModifiers; ++i) {
            SimpleNode modif = (SimpleNode)modifiersListNode.jjtGetChild(i);
            Modifier modifier = GCQLQueryTreeManager.parseGCQLModifierNode(modif);
            modifiers.add(modifier);
        }
        return modifiers;
    }

    static Modifier parseGCQLModifierNode(SimpleNode modifNode) {
        int numChildren = modifNode.jjtGetNumChildren();
        switch (numChildren) {
            case 1: {
                SimpleNode modifierNameNode = (SimpleNode)modifNode.jjtGetChild(0);
                String modifName = modifierNameNode.getText();
                Modifier modifier = new Modifier(modifName);
                return modifier;
            }
            case 3: {
                SimpleNode modifierNameNode = (SimpleNode)modifNode.jjtGetChild(0);
                String modifName = modifierNameNode.getText();
                SimpleNode tempNode = (SimpleNode)modifNode.jjtGetChild(1);
                String comparSymbol = tempNode.getText();
                tempNode = (SimpleNode)modifNode.jjtGetChild(2);
                String modifValue = tempNode.getText();
                Modifier modifier = new Modifier(modifName, comparSymbol, modifValue);
                return modifier;
            }
        }
        return null;
    }

    private static InputStream stringToStream(String str) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes("UTF-8"));
            return is;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

