/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.jgroups.JGroupEventMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsCacheReplicator
implements CacheReplicator {
    public static final long DEFAULT_ASYNC_INTERVAL = 1000L;
    private static final Logger LOG = LoggerFactory.getLogger((String)JGroupsCacheReplicator.class.getName());
    private final long asynchronousReplicationInterval;
    private final boolean replicatePuts;
    private final boolean replicateUpdates;
    private final boolean replicateUpdatesViaCopy;
    private final boolean replicateRemovals;
    private boolean alive;

    public JGroupsCacheReplicator(boolean replicatePuts, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals) {
        this(replicatePuts, replicateUpdates, replicateUpdatesViaCopy, replicateRemovals, -1L);
    }

    public JGroupsCacheReplicator(boolean replicatePuts, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals, long asynchronousReplicationInterval) {
        this.replicatePuts = replicatePuts;
        this.replicateUpdates = replicateUpdates;
        this.replicateUpdatesViaCopy = replicateUpdatesViaCopy;
        this.replicateRemovals = replicateRemovals;
        this.asynchronousReplicationInterval = asynchronousReplicationInterval;
        this.alive = true;
    }

    public boolean alive() {
        return this.alive;
    }

    public boolean isReplicateUpdatesViaCopy() {
        return this.replicateUpdatesViaCopy;
    }

    public boolean notAlive() {
        return !this.alive;
    }

    public void dispose() {
        this.alive = false;
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive() || !this.replicatePuts) {
            return;
        }
        this.replicatePutNotification(cache, element);
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive() || !this.replicateRemovals) {
            return;
        }
        this.replicateRemoveNotification(cache, element);
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive() || !this.replicateUpdates) {
            return;
        }
        if (this.replicateUpdatesViaCopy) {
            this.replicatePutNotification(cache, element);
        } else {
            this.replicateRemoveNotification(cache, element);
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (this.replicateRemovals) {
            String cacheName = cache.getName();
            LOG.debug("Remove all elements called on {}", (Object)cacheName);
            JGroupEventMessage e = new JGroupEventMessage(3, null, null, cacheName, this.asynchronousReplicationInterval);
            this.sendNotification(cache, e);
        }
    }

    private void replicatePutNotification(Ehcache cache, Element element) {
        if (!element.isKeySerializable()) {
            LOG.warn("Key {} is not Serializable and cannot be replicated.", element.getObjectKey());
            return;
        }
        if (!element.isSerializable()) {
            LOG.warn("Object with key {} is not Serializable and cannot be updated via copy", element.getObjectKey());
            return;
        }
        JGroupEventMessage e = new JGroupEventMessage(0, (Serializable)element.getObjectKey(), element, cache.getName(), this.asynchronousReplicationInterval);
        this.sendNotification(cache, e);
    }

    private void replicateRemoveNotification(Ehcache cache, Element element) {
        if (!element.isKeySerializable()) {
            LOG.warn("Key {} is not Serializable and cannot be replicated.", element.getObjectKey());
            return;
        }
        JGroupEventMessage e = new JGroupEventMessage(1, (Serializable)element.getObjectKey(), null, cache.getName(), this.asynchronousReplicationInterval);
        this.sendNotification(cache, e);
    }

    protected void sendNotification(Ehcache cache, JGroupEventMessage eventMessage) {
        List<CachePeer> peers = this.listRemoteCachePeers(cache);
        for (CachePeer peer : peers) {
            try {
                peer.send(Arrays.asList(eventMessage));
            }
            catch (RemoteException e) {
                LOG.warn("Failed to send message '" + (Object)((Object)eventMessage) + "' to peer '" + peer + "'", (Throwable)e);
            }
        }
    }

    private List<CachePeer> listRemoteCachePeers(Ehcache cache) {
        CacheManager cacheManager = cache.getCacheManager();
        CacheManagerPeerProvider provider = cacheManager.getCacheManagerPeerProvider("JGroups");
        return provider.listRemoteCachePeers(cache);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

