/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.proxies;

import java.net.URI;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.common.clients.exceptions.UnsupportedRequestException;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tml.Utils;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.proxies.Path;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.tml.stubs.TReaderStub;
import org.gcube.data.tml.stubs.Types;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.patterns.EdgePattern;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.patterns.Patterns;
import org.gcube.data.trees.streams.TreeStreams;

public class DefaultTReader
implements TReader {
    private final ProxyDelegate<TReaderStub> delegate;

    public DefaultTReader(ProxyDelegate<TReaderStub> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Tree get(String id) throws UnknownTreeException {
        try {
            return this.get(id, (Pattern)Patterns.tree((EdgePattern[])new EdgePattern[0]));
        }
        catch (InvalidTreeException e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Tree get(final String id, final Pattern pattern) throws UnknownTreeException, InvalidTreeException {
        Utils.notNull("identifier", id);
        Utils.notNull("pattern", pattern);
        Call<TReaderStub, Tree> call = new Call<TReaderStub, Tree>(){

            public Tree call(TReaderStub endpoint) throws Exception {
                Types.LookupRequest params = new Types.LookupRequest(id, pattern);
                return endpoint.lookup(params).asTree();
            }
        };
        try {
            Tree e = (Tree)this.delegate.make((Call)call);
            if (e == null) {
                throw new ServiceException("unexpected null response");
            }
            return e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(UnknownTreeException.class, InvalidTreeException.class);
        }
    }

    @Override
    public Stream<Tree> get(Stream<String> ids, Pattern pattern) {
        URI locator = Streams.publishStringsIn(ids).withDefaults();
        return this.get(locator, pattern);
    }

    @Override
    public Stream<Tree> get(final URI locator, final Pattern pattern) throws UnsupportedOperationException, UnsupportedRequestException, ServiceException {
        Utils.notNull("stream locator", locator);
        Utils.notNull("pattern", pattern);
        Call<TReaderStub, String> call = new Call<TReaderStub, String>(){

            public String call(TReaderStub endpoint) throws Exception {
                Types.LookupStreamRequest request = new Types.LookupStreamRequest(locator.toString(), pattern);
                return endpoint.lookupStream(request);
            }
        };
        try {
            String outcomeLocator = (String)this.delegate.make((Call)call);
            if (outcomeLocator == null) {
                throw new ServiceException("unexpected null response");
            }
            return TreeStreams.treesIn((URI)URI.create(outcomeLocator));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Stream<Tree> get(final Pattern pattern) {
        Utils.notNull("pattern", pattern);
        Call<TReaderStub, String> call = new Call<TReaderStub, String>(){

            public String call(TReaderStub endpoint) throws Exception {
                Types.QueryRequest request = new Types.QueryRequest(pattern);
                return endpoint.query(request);
            }
        };
        try {
            String outcomeLocator = (String)this.delegate.make((Call)call);
            if (outcomeLocator == null) {
                throw new ServiceException("unexpected null response");
            }
            return TreeStreams.treesIn((URI)URI.create(outcomeLocator));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Node getNode(final String ... path) throws UnknownPathException {
        Utils.notNull("path", path);
        Call<TReaderStub, Node> call = new Call<TReaderStub, Node>(){

            public Node call(TReaderStub service) throws Exception {
                return service.lookupNode(new Path(path)).asNode();
            }
        };
        try {
            Node node = (Node)this.delegate.make((Call)call);
            if (node == null) {
                throw new ServiceException("unexpected null response");
            }
            return node;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(UnknownPathException.class);
        }
    }

    @Override
    public Stream<Node> getNodes(Stream<Path> paths) {
        URI pathRs = Streams.publish(paths).using((Generator)new Utils.PathSerialiser()).withDefaults();
        return this.getNodes(pathRs);
    }

    @Override
    public Stream<Node> getNodes(final URI paths) {
        Call<TReaderStub, String> call = new Call<TReaderStub, String>(){

            public String call(TReaderStub endpoint) throws Exception {
                return endpoint.lookupNodeStream(paths.toString());
            }
        };
        try {
            String locator = (String)this.delegate.make((Call)call);
            return TreeStreams.nodesIn((URI)URI.create(locator));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

