/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.proxies;

import java.net.URI;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.data.streams.Stream;
import org.gcube.data.tml.Utils;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.proxies.TWriter;
import org.gcube.data.tml.stubs.TWriterStub;
import org.gcube.data.tml.stubs.Types;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.streams.TreeStreams;

public class DefaultTWriter
implements TWriter {
    private final ProxyDelegate<TWriterStub> delegate;

    public DefaultTWriter(ProxyDelegate<TWriterStub> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Tree add(final Tree tree) throws InvalidTreeException {
        Utils.notNull("tree", tree);
        Call<TWriterStub, Tree> call = new Call<TWriterStub, Tree>(){

            public Tree call(TWriterStub endpoint) throws Exception {
                Types.NodeHolder response = endpoint.add(new Types.NodeHolder(tree));
                return response.asTree();
            }
        };
        try {
            Tree e = (Tree)this.delegate.make((Call)call);
            if (e == null) {
                throw new ServiceException("unexpected null response");
            }
            return e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(InvalidTreeException.class);
        }
    }

    @Override
    public Stream<Tree> add(Stream<Tree> trees) {
        URI locator = TreeStreams.publishTreesIn(trees).withDefaults();
        return this.add(locator);
    }

    @Override
    public Stream<Tree> add(final URI locator) {
        Utils.notNull("resultset locator", locator);
        Call<TWriterStub, String> call = new Call<TWriterStub, String>(){

            public String call(TWriterStub endpoint) throws Exception {
                return endpoint.addStream(locator.toString());
            }
        };
        try {
            String outcomeLocator = (String)this.delegate.make((Call)call);
            if (outcomeLocator == null) {
                throw new ServiceException("unexpected null response");
            }
            return TreeStreams.treesIn((URI)URI.create(outcomeLocator));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Tree update(final Tree delta) throws InvalidTreeException, UnknownTreeException {
        Utils.notNull("delta tree", delta);
        Call<TWriterStub, Tree> call = new Call<TWriterStub, Tree>(){

            public Tree call(TWriterStub endpoint) throws Exception {
                Types.NodeHolder response = endpoint.update(new Types.NodeHolder(delta));
                return response.asTree();
            }
        };
        try {
            Tree e = (Tree)this.delegate.make((Call)call);
            if (e == null) {
                throw new ServiceException("unexpected null response");
            }
            return e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).as(UnknownTreeException.class, InvalidTreeException.class);
        }
    }

    @Override
    public Stream<Tree> update(Stream<Tree> deltas) {
        URI locator = TreeStreams.publishTreesIn(deltas).withDefaults();
        return this.update(locator);
    }

    @Override
    public Stream<Tree> update(final URI locator) {
        Utils.notNull("resultset locator", locator);
        Call<TWriterStub, String> call = new Call<TWriterStub, String>(){

            public String call(TWriterStub endpoint) throws Exception {
                return endpoint.updateStream(locator.toString());
            }
        };
        try {
            String outcomeLocator = (String)this.delegate.make((Call)call);
            if (outcomeLocator == null) {
                throw new ServiceException("unexpected null response");
            }
            return TreeStreams.treesIn((URI)URI.create(outcomeLocator));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

