/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.SerializationException;
import org.apache.abdera.ext.serializer.annotation.Convention;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConventions
implements Conventions,
Cloneable,
Serializable {
    private final Map<Class<? extends Annotation>, Pattern> conventions = new HashMap<Class<? extends Annotation>, Pattern>();
    private final boolean isCaseSensitive;

    protected AbstractConventions() {
        this(false);
    }

    protected AbstractConventions(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    @Override
    public Iterator<Class<? extends Annotation>> iterator() {
        return this.conventions.keySet().iterator();
    }

    @Override
    public void setConvention(String pattern, Class<? extends Annotation> annotationType) {
        Pattern regex = this.isCaseSensitive ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        this.conventions.put(annotationType, regex);
    }

    @Override
    public void setConvention(Class<? extends Annotation> annotationType) {
        Convention conv = annotationType.getAnnotation(Convention.class);
        if (conv == null) {
            throw new IllegalArgumentException("No Convention Annotation [" + annotationType + "]");
        }
        this.setConvention(conv.value(), annotationType);
    }

    @Override
    public Class<? extends Annotation> matchConvention(AccessibleObject accessor) {
        return this.matchConvention(accessor, null);
    }

    @Override
    public Class<? extends Annotation> matchConvention(AccessibleObject accessor, Class<? extends Annotation> expect) {
        if (accessor == null) {
            return null;
        }
        String name = ((Member)((Object)accessor)).getName();
        for (Map.Entry<Class<? extends Annotation>, Pattern> entry : this.conventions.entrySet()) {
            if (!entry.getValue().matcher(name).matches() || expect != null && expect != entry.getKey()) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public boolean isMatch(AccessibleObject accessor, Class<? extends Annotation> expect) {
        return this.matchConvention(accessor, expect) != null;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.conventions == null ? 0 : ((Object)this.conventions).hashCode());
        result = 31 * result + (this.isCaseSensitive ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractConventions other = (AbstractConventions)obj;
        if (this.conventions == null ? other.conventions != null : !((Object)this.conventions).equals(other.conventions)) {
            return false;
        }
        return this.isCaseSensitive == other.isCaseSensitive;
    }

    @Override
    public Conventions clone() {
        try {
            return (Conventions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.copy();
        }
    }

    protected Conventions copy() {
        throw new SerializationException(new CloneNotSupportedException());
    }
}

