/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.Serializable;
import org.apache.abdera.model.Category;
import org.apache.abdera.protocol.server.CategoryInfo;
import org.apache.abdera.protocol.server.RequestContext;

public class SimpleCategoryInfo
implements CategoryInfo,
Serializable {
    private static final long serialVersionUID = -4013333222147077975L;
    private final String label;
    private final String term;
    private final String scheme;

    public SimpleCategoryInfo(String term) {
        this(term, null, null);
    }

    public SimpleCategoryInfo(String term, String scheme) {
        this(term, scheme, null);
    }

    public SimpleCategoryInfo(String term, String scheme, String label) {
        this.term = term;
        this.scheme = scheme;
        this.label = label;
    }

    public String getLabel(RequestContext request) {
        return this.label;
    }

    public String getScheme(RequestContext request) {
        return this.scheme;
    }

    public String getTerm(RequestContext request) {
        return this.term;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleCategoryInfo other = (SimpleCategoryInfo)obj;
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme)) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    public Category asCategoryElement(RequestContext request) {
        Category cat = request.getAbdera().getFactory().newCategory();
        cat.setTerm(this.term);
        if (this.scheme != null) {
            cat.setScheme(this.scheme);
        }
        if (this.label != null) {
            cat.setLabel(this.label);
        }
        return cat;
    }
}

